/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.commands.RunPreviewCommand$;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.PreviewService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.services.exception.RunPreviewException;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001E\t\u00019!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015!\u0006\u0001\"\u0011;\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015A\u0006\u0001\"\u0011Z\u000f\u0015\u0001\u0017\u0003#\u0001b\r\u0015\u0001\u0012\u0003#\u0001c\u0011\u0015!$\u0002\"\u0001g\u0011\u001d9'B1A\u0005\u0002!Da!\u001b\u0006!\u0002\u0013Y\u0004\"\u00026\u000b\t\u0003Y\u0007b\u0002:\u000b#\u0003%\ta\u001d\u0002\u0012%Vt\u0007K]3wS\u0016<8i\\7nC:$'B\u0001\n\u0014\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u000b\u0016\u0003\ra7\u000f\u001d\u0006\u0003-]\tQa^3bm\u0016T!\u0001G\r\u0002\t5,H.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0013\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001\u00027b]\u001eT\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t1qJ\u00196fGR\u0004\"AJ\u0014\u000e\u0003EI!\u0001K\t\u0003)%sG/\u001a:oC2<V-\u0019<f\u0007>lW.\u00198e\u0003]9xN]6ta\u0006\u001cWmU3sm&\u001cW-T1oC\u001e,'\u000f\u0005\u0002,]5\tAF\u0003\u0002.'\u0005A1/\u001a:wS\u000e,7/\u0003\u00020Y\t9rk\u001c:lgB\f7-Z*feZL7-Z'b]\u0006<WM]\u0001\nk&\u001bVM\u001d<jG\u0016\u0004\"a\u000b\u001a\n\u0005Mb#!C+J'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0019ag\u000e\u001d\u0011\u0005\u0019\u0002\u0001\"B\u0015\u0004\u0001\u0004Q\u0003\"\u0002\u0019\u0004\u0001\u0004\t\u0014!C2p[6\fg\u000eZ%e)\u0005Y\u0004C\u0001\u001fF\u001d\ti4\t\u0005\u0002?\u00036\tqH\u0003\u0002A7\u00051AH]8pizR\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A)Q\u0001\bKb,7-\u001e;f)\ti\"\nC\u0003L\u000b\u0001\u0007A*\u0001\u0004qCJ\fWn\u001d\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bQ\u0001\\:qi)T!!U\r\u0002\u000f\u0015\u001cG.\u001b9tK&\u00111K\u0014\u0002\u0015\u000bb,7-\u001e;f\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u0002\t9\fW.Z\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0006\u0002</\")1j\u0002a\u0001\u0019\u00069QM\\1cY\u0016$GC\u0001._!\tYF,D\u0001B\u0013\ti\u0016IA\u0004C_>dW-\u00198\t\u000b}C\u0001\u0019A\u001e\u0002\u0007U\u0014\u0018.A\tSk:\u0004&/\u001a<jK^\u001cu.\\7b]\u0012\u0004\"A\n\u0006\u0014\u0005)\u0019\u0007CA.e\u0013\t)\u0017I\u0001\u0004B]f\u0014VM\u001a\u000b\u0002C\u0006)A*\u0011\"F\u0019V\t1(\u0001\u0004M\u0003\n+E\nI\u0001\u000eGJ,\u0017\r^3D_6l\u0017M\u001c3\u0015\u00071|\u0007\u000f\u0005\u0002N[&\u0011aN\u0014\u0002\b\u0007>lW.\u00198e\u0011\u0015yf\u00021\u0001<\u0011\u001d\th\u0002%AA\u0002i\u000bAa]=oG\u000692M]3bi\u0016\u001cu.\\7b]\u0012$C-\u001a4bk2$HEM\u000b\u0002i*\u0012!,^\u0016\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\nk:\u001c\u0007.Z2lK\u0012T!a_!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002~q\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class RunPreviewCommand
implements InternalWeaveCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final UIService uIService;

    public static boolean createCommand$default$2() {
        return RunPreviewCommand$.MODULE$.createCommand$default$2();
    }

    public static Command createCommand(String string, boolean bl) {
        return RunPreviewCommand$.MODULE$.createCommand(string, bl);
    }

    public static String LABEL() {
        return RunPreviewCommand$.MODULE$.LABEL();
    }

    public String commandId() {
        return Commands$.MODULE$.DW_RUN_PREVIEW();
    }

    public Object execute(ExecuteCommandParams params) {
        String uri = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        boolean sync = Commands$.MODULE$.argAsBooleanOrDefault(params.getArguments(), 1, false);
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            ProjectKind projectKind = (ProjectKind)maybeProjectKind.get();
            PreviewService previewService = projectKind.toolingService(PreviewService.class);
            VirtualFileSystem virtualFile = projectKind.vfs();
            VirtualFile file = virtualFile.file(uri);
            if (file != null) {
                PreviewResult result = previewService.scheduleRunPreview(file, sync);
                if (sync) {
                    return JavaConverters$.MODULE$.mapAsJavaMap(result.toMap());
                }
            } else {
                String message = new StringBuilder(52).append("Unable to run preview because file `").append(uri).append("` was not found.").toString();
                if (sync) {
                    throw new RunPreviewException(message);
                }
                this.uIService.showMessage(new MessageParams(MessageType.Warning, message));
            }
        } else {
            this.uIService.showMessage(new MessageParams(MessageType.Error, new StringBuilder(50).append("No project is associated to: ").append(uri).append(". ").append(this.commandId()).append(" cannot be executed").toString()));
        }
        return null;
    }

    public String name() {
        return "Runs Preview.";
    }

    public String description(ExecuteCommandParams params) {
        return "Running Preview.";
    }

    @Override
    public boolean enabled(String uri) {
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            ProjectKind projectKind = (ProjectKind)maybeProjectKind.get();
            return projectKind.toolingService(PreviewService.class).canRunPreview(projectKind.toolingService(ProjectFileSystemService.class).file(uri));
        }
        return false;
    }

    public RunPreviewCommand(WorkspaceServiceManager workspaceServiceManager, UIService uIService) {
        this.workspaceServiceManager = workspaceServiceManager;
        this.uIService = uIService;
        InternalWeaveCommand.$init$(this);
    }
}

