package org.mule.weave.dsp

import org.eclipse.lsp4j.debug.launch.DSPLauncher
import org.mule.weave.lsp.IDEExecutors
import org.mule.weave.lsp.jobs.JobManagerService
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.project.components.ProcessLauncher
import org.mule.weave.lsp.services.ClientLoggerFactory
import org.mule.weave.lsp.services.DataWeaveTestService
import org.mule.weave.lsp.services.UIService
import org.mule.weave.v2.editor.VirtualFileSystem
import org.slf4j.LoggerFactory

import java.io.InputStream
import java.io.OutputStream
import java.net.ServerSocket

/**
  * Starts The DAP Server
  */
object DataWeaveDebuggerAdapterProtocolLauncher {
  private val logger = LoggerFactory.getLogger("org.mule.weave.dsp.DataWeaveDebuggerAdapterProtocolLauncher")

  def launch(virtualFileSystem: VirtualFileSystem,
             loggerFactory: ClientLoggerFactory,
             uIService: UIService,
             processLauncher: ProcessLauncher,
             projectKind: ProjectKind,
             jobManagerService: JobManagerService,
             dataWeaveTestService: DataWeaveTestService,
             onServerStarted: () => Unit,
             dapPort: Int): Unit = {
    logger.info(s"Starting Adapter Protocol Process at ${dapPort}.")
    val serverSocket = new ServerSocket(dapPort)
    onServerStarted()
    val socket = serverSocket.accept()
    logger.info(s"Connection established.")
    val in: InputStream = socket.getInputStream
    val out: OutputStream = socket.getOutputStream
    val testDebugServer: DataWeaveDebuggerProtocolAdapter =
      new DataWeaveDebuggerProtocolAdapter(
        virtualFileSystem = virtualFileSystem,
        loggerFactory = loggerFactory,
        uIService = uIService,
        launcher = processLauncher,
        projectKind = projectKind,
        executor = IDEExecutors.debuggingExecutor(),
        jobManagerService = jobManagerService,
        weaveTestManager = dataWeaveTestService)

    val launcher = DSPLauncher.createServerLauncher(testDebugServer, in, out)
    testDebugServer.connect(launcher.getRemoteProxy)
    launcher.startListening
    logger.info("Debugger Adapter Finished.")
  }

}

