/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.dx.platform.api.protocol.ClientAware;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.lsp.EmbeddedLanguageServerConfiguration;
import org.mule.weave.lsp.IDEExecutors$;
import org.mule.weave.lsp.WeaveLanguageServer;
import org.mule.weave.lsp.extension.client.LanguageClientDelegate;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolService;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.ProjectKindContext;
import org.mule.weave.lsp.project.ProjectKindFactory;
import org.mule.weave.lsp.project.ProjectSettings;
import org.mule.weave.lsp.project.ProjectSettings$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveDocumentService;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher$;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor;
import org.mule.weave.lsp.services.DiagnosticsPublisher;
import org.mule.weave.lsp.services.WorkspaceEditApplier;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.services.delegate.TextDocumentServiceDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0014)\u0001EB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011!\u0001\bA!A!\u0002\u0013\t\b\"B<\u0001\t\u0003A\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003+A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u0011\u00055\u0002\u0001)A\u0005\u0003OA\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005}\u0002\u0001)A\u0005\u0003gA1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D!Y\u00111\n\u0001A\u0002\u0003\u0007I\u0011BA'\u0011-\ty\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0012\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003W\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0007C\u0006\u0002r\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0004\"CA:\u0001\t\u0007I\u0011BA;\u0011!\ti\b\u0001Q\u0001\n\u0005]\u0004\"CA@\u0001\t\u0007I\u0011BAA\u0011!\tI\t\u0001Q\u0001\n\u0005\r\u0005\"CAF\u0001\t\u0007I\u0011BAG\u0011!\t)\n\u0001Q\u0001\n\u0005=\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!!6\u0001\t\u0003\n9\u000eC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005]\b\u0001\"\u0011\u0002z\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011i\u0002\u0001C!\u0005?AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u0003>\u0001!IAa\u0010\u00037\u0015k'-\u001a3eK\u0012<V-\u0019<f\u0019\u0006tw-^1hKN+'O^3s\u0015\tI#&A\u0002mgBT!a\u000b\u0017\u0002\u000b],\u0017M^3\u000b\u00055r\u0013\u0001B7vY\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001IRDi\u0015\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001\\1oO*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u0019y%M[3diB\u00111HQ\u0007\u0002y)\u0011QHP\u0001\tg\u0016\u0014h/[2fg*\u0011q\bQ\u0001\u0006YN\u0004HG\u001b\u0006\u0003\u0003:\nq!Z2mSB\u001cX-\u0003\u0002Dy\tqA*\u00198hk\u0006<WmU3sm\u0016\u0014\bcA#O!6\taI\u0003\u0002H\u0011\u0006A\u0001O]8u_\u000e|GN\u0003\u0002J\u0015\u0006\u0019\u0011\r]5\u000b\u0005-c\u0015\u0001\u00039mCR4wN]7\u000b\u00055c\u0013A\u00013y\u0013\tyeIA\u0006DY&,g\u000e^!xCJ,\u0007CA\u001eR\u0013\t\u0011FH\u0001\bMC:<W/Y4f\u00072LWM\u001c;\u0011\u0005Q3V\"A+\u000b\u0005uB\u0013BA,V\u0005a9vN]6ta\u0006\u001cWmU3sm&\u001cW\rT5ti\u0016tWM]\u0001\u0013aJ|'.Z2u\u0017&tGMR1di>\u0014\u0018\u0010\u0005\u0002[;6\t1L\u0003\u0002]Q\u00059\u0001O]8kK\u000e$\u0018B\u00010\\\u0005I\u0001&o\u001c6fGR\\\u0015N\u001c3GC\u000e$xN]=\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t\t'-D\u0001)\u0013\t\u0019\u0007FA\u0012F[\n,G\rZ3e\u0019\u0006tw-^1hKN+'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001fA\u0014x\u000e^8d_2\u001cVM\u001d<jG\u0016\u0004\"A\u001a6\u000e\u0003\u001dT!a\u00125\u000b\u0005%D\u0013!C3yi\u0016t7/[8o\u0013\tYwM\u0001\rECR\fw+Z1wKB\u0013x\u000e^8d_2\u001cVM\u001d<jG\u0016\fqc^8sWN\u0004\u0018mY3TKJ4\u0018nY3NC:\fw-\u001a:\u0011\u0005Qs\u0017BA8V\u0005]9vN]6ta\u0006\u001cWmU3sm&\u001cW-T1oC\u001e,'/A\tk_\nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\u0004\"A];\u000e\u0003MT!\u0001\u001e\u0015\u0002\t)|'m]\u0005\u0003mN\u0014\u0011CS8c\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q1\u0011P_>}{z\u0004\"!\u0019\u0001\t\u000ba3\u0001\u0019A-\t\u000b}3\u0001\u0019\u00011\t\u000b\u00114\u0001\u0019A3\t\u000b14\u0001\u0019A7\t\u000bA4\u0001\u0019A9\u0002\r1|wmZ3s+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIAL\u0001\u0006g24GG[\u0005\u0005\u0003\u001b\t9A\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003M!X\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"V\u0001\tI\u0016dWmZ1uK&!\u0011qDA\r\u0005m!V\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\t\u0016dWmZ1uK\u0006!B/\u001a=u\t>\u001cW/\\3oiN+'O^5dK\u0002\nq\u0003^3yi\u0012{7-^7f]R\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u0016\u0005\u0005\u001d\u0002c\u0001+\u0002*%\u0019\u00111F+\u0003E\u0011\u000bG/Y,fCZ,Gi\\2v[\u0016tGoU3sm&\u001cW\rR5ta\u0006$8\r[3s\u0003a!X\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\u00136\u0004H\u000eI\u0001\u000fY\u0006tw-^1hK\u000ec\u0017.\u001a8u+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004[\u0001\u0007G2LWM\u001c;\n\t\u0005u\u0012q\u0007\u0002\u0017\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\t\u0016dWmZ1uK\u0006yA.\u00198hk\u0006<Wm\u00117jK:$\b%A\ndY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180\u0006\u0002\u0002FA\u0019A+a\u0012\n\u0007\u0005%SKA\nDY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180A\fdY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u0018p\u0018\u0013fcR!\u0011qJA.!\u0011\t\t&a\u0016\u000e\u0005\u0005M#BAA+\u0003\u0015\u00198-\u00197b\u0013\u0011\tI&a\u0015\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003;\u0002\u0012\u0011!a\u0001\u0003\u000b\n1\u0001\u001f\u00132\u0003Q\u0019G.[3oi2{wmZ3s\r\u0006\u001cGo\u001c:zA\u0005a1\r\\5f]RdunZ4feV\u0011\u0011Q\r\t\u0004)\u0006\u001d\u0014bAA5+\na1\t\\5f]RdunZ4fe\u0006\u00012\r\\5f]RdunZ4fe~#S-\u001d\u000b\u0005\u0003\u001f\ny\u0007C\u0005\u0002^M\t\t\u00111\u0001\u0002f\u0005i1\r\\5f]RdunZ4fe\u0002\n\u0001b]3ui&twm]\u000b\u0003\u0003o\u00022AWA=\u0013\r\tYh\u0017\u0002\u0010!J|'.Z2u'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0015o>\u00148n\u001d9bG\u0016,E-\u001b;BaBd\u0017.\u001a:\u0016\u0005\u0005\r\u0005c\u0001+\u0002\u0006&\u0019\u0011qQ+\u0003)]{'o[:qC\u000e,W\tZ5u\u0003B\u0004H.[3s\u0003U9xN]6ta\u0006\u001cW-\u00123ji\u0006\u0003\b\u000f\\5fe\u0002\nA\u0003Z5bO:|7\u000f^5dgB+(\r\\5tQ\u0016\u0014XCAAH!\r!\u0016\u0011S\u0005\u0004\u0003'+&\u0001\u0006#jC\u001etwn\u001d;jGN\u0004VO\u00197jg\",'/A\u000beS\u0006<gn\\:uS\u000e\u001c\b+\u001e2mSNDWM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002\u001c\u0006M\u0006CBAO\u0003O\u000bY+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003K3\u0014\u0001B;uS2LA!!+\u0002 \n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u00055\u0016qV\u0007\u0002}%\u0019\u0011\u0011\u0017 \u0003!%s\u0017\u000e^5bY&TXMU3tk2$\bbBA[7\u0001\u0007\u0011qW\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u00055\u0016\u0011X\u0005\u0004\u0003ws$\u0001E%oSRL\u0017\r\\5{KB\u000b'/Y7t\u0003-Ig.\u001b;jC2L'0\u001a3\u0015\t\u0005=\u0013\u0011\u0019\u0005\b\u0003kc\u0002\u0019AAb!\u0011\ti+!2\n\u0007\u0005\u001dgHA\tJ]&$\u0018.\u00197ju\u0016$\u0007+\u0019:b[N\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u001b\u0004b!!(\u0002(\u0006=\u0007\u0003BA)\u0003#LA!a5\u0002T\t1\u0011I\\=SK\u001a\fA!\u001a=jiR\u0011\u0011qJ\u0001\u0017O\u0016$H+\u001a=u\t>\u001cW/\\3oiN+'O^5dKR\u0011\u0011Q\u001c\t\u0005\u0003?\f\u0019/\u0004\u0002\u0002b*\u0011Q\b[\u0005\u0005\u0003K\f\tO\u0001\rXK\u00064X\rV3yi\u0012{7-^7f]R\u001cVM\u001d<jG\u0016D3aHAu!\u0011\tY/a=\u000e\u0005\u00055(bA\u001f\u0002p*\u0019\u0011\u0011\u001f \u0002\u000f)\u001cxN\u001c:qG&!\u0011Q_Aw\u00051Q5o\u001c8EK2,w-\u0019;f\u0003M9W\r^,pe.\u001c\b/Y2f'\u0016\u0014h/[2f)\t\tY\u0010E\u0002<\u0003{L1!a@=\u0005A9vN]6ta\u0006\u001cWmU3sm&\u001cW-A\u0004d_:tWm\u0019;\u0015\t\u0005=#Q\u0001\u0005\u0007\u0003s\t\u0003\u0019\u0001)\u0002\u0011\u0015DXmY;u_J$\"Aa\u0003\u0011\t\u0005u%QB\u0005\u0005\u0005\u001f\tyJA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003Y!\u0017\u000eZ\"iC:<WmQ8oM&<WO]1uS>tG\u0003BA(\u0005+Aq!!.$\u0001\u0004\u00119\u0002\u0005\u0003\u0002.\ne\u0011b\u0001B\u000e}\taB)\u001b3DQ\u0006tw-Z\"p]\u001aLw-\u001e:bi&|g\u000eU1sC6\u001c\u0018!\u00073jI\u000eC\u0017M\\4f/>\u00148n\u001d9bG\u00164u\u000e\u001c3feN$B!a\u0014\u0003\"!9\u0011Q\u0017\u0013A\u0002\t\r\u0002\u0003BAW\u0005KI1Aa\n?\u0005}!\u0015\u000eZ\"iC:<WmV8sWN\u0004\u0018mY3G_2$WM]:QCJ\fWn]\u0001\u001fI&\u001c8m\u001c<fe\u0006sGMU3hSN$XM\u001d)s_*,7\r^&j]\u0012$BA!\f\u00034A\u0019!La\f\n\u0007\tE2LA\u0006Qe>TWm\u0019;LS:$\u0007b\u0002B\u001bK\u0001\u0007!qG\u0001\u0015C\u0012$W\rZ,pe.\u001c\b/Y2f\r>dG-\u001a:\u0011\t\u00055&\u0011H\u0005\u0004\u0005wq$aD,pe.\u001c\b/Y2f\r>dG-\u001a:\u0002#\r\u0014X-\u0019;f!J|'.Z2u\u0017&tG\r\u0006\u0004\u0003.\t\u0005#1\n\u0005\b\u0005\u00072\u0003\u0019\u0001B#\u0003=\u0001(o\u001c6fGRlU\r^1eCR\f\u0007c\u0001.\u0003H%\u0019!\u0011J.\u0003-\u0011+g-Y;miB\u0013xN[3di6+G/\u00193bi\u0006Dq!!\u0011'\u0001\u0004\t)\u0005")
public class EmbeddedWeaveLanguageServer
implements LanguageServer,
ClientAware<LanguageClient>,
WorkspaceServiceListener {
    private final ProjectKindFactory projectKindFactory;
    private final EmbeddedLanguageServerConfiguration configuration;
    private final DataWeaveProtocolService protocolService;
    private final WorkspaceServiceManager workspaceServiceManager;
    private final JobManagerService jobManagerService;
    private final Logger logger;
    private final TextDocumentServiceDelegate textDocumentService;
    private final DataWeaveDocumentServiceDispatcher textDocumentServiceImpl;
    private final LanguageClientDelegate languageClient;
    private ClientLoggerFactory clientLoggerFactory;
    private ClientLogger clientLogger;
    private final ProjectSettings settings;
    private final WorkspaceEditApplier workspaceEditApplier;
    private final DiagnosticsPublisher diagnosticsPublisher;

    private Logger logger() {
        return this.logger;
    }

    private TextDocumentServiceDelegate textDocumentService() {
        return this.textDocumentService;
    }

    private DataWeaveDocumentServiceDispatcher textDocumentServiceImpl() {
        return this.textDocumentServiceImpl;
    }

    private LanguageClientDelegate languageClient() {
        return this.languageClient;
    }

    private ClientLoggerFactory clientLoggerFactory() {
        return this.clientLoggerFactory;
    }

    private void clientLoggerFactory_$eq(ClientLoggerFactory x$1) {
        this.clientLoggerFactory = x$1;
    }

    private ClientLogger clientLogger() {
        return this.clientLogger;
    }

    private void clientLogger_$eq(ClientLogger x$1) {
        this.clientLogger = x$1;
    }

    private ProjectSettings settings() {
        return this.settings;
    }

    private WorkspaceEditApplier workspaceEditApplier() {
        return this.workspaceEditApplier;
    }

    private DiagnosticsPublisher diagnosticsPublisher() {
        return this.diagnosticsPublisher;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logger().debug(new StringBuilder(11).append("Initialize ").append(this.configuration.lspID()).toString());
        return CompletableFuture.supplyAsync(() -> {
            this.logger().debug(new StringBuilder(13).append("Initializing ").append($this.configuration.lspID()).toString());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown().get()));
            this.clientLoggerFactory_$eq(new ClientLoggerFactory(this.languageClient()));
            this.clientLogger_$eq(this.clientLoggerFactory().createLogger(WeaveLanguageServer.class, $this.configuration.lspID()));
            $this.workspaceServiceManager.addWorkspaceServiceListeners(this);
            this.settings().load(params.getInitializationOptions());
            if (params.getWorkspaceFolders() != null) {
                params.getWorkspaceFolders().forEach(workspaceFolder -> this.discoverAndRegisterProjectKind((WorkspaceFolder)workspaceFolder));
            }
            this.textDocumentService().delegate_$eq(this.textDocumentServiceImpl());
            if ($this.configuration.fileScheme().isDefined()) {
                $this.workspaceServiceManager.diagnosticsPublisherService().addPublisher(this.diagnosticsPublisher());
                $this.workspaceServiceManager.workspaceEditService().addApplier(this.workspaceEditApplier());
                $this.workspaceServiceManager.textDocumentTranslatorService().addTranslator((String)$this.configuration.fileScheme().get(), (WeaveLanguageServerBuilder.TextDocumentTranslator)$this.configuration.textDocumentLocator().get());
            }
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
            capabilities.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(true), Arrays.asList((Object[])new String[]{"."})));
            capabilities.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setFoldingRangeProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeActionProvider(Predef$.MODULE$.boolean2Boolean($this.configuration.codeActions()));
            capabilities.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeLensProvider(new CodeLensOptions(Predef$.MODULE$.boolean2Boolean($this.configuration.codeLens())));
            capabilities.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentRangeFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList((Object[])new String[]{"("}), Arrays.asList((Object[])new String[]{","})));
            WorkspaceFoldersOptions workspaceFoldersOptions = new WorkspaceFoldersOptions();
            workspaceFoldersOptions.setSupported(Predef$.MODULE$.boolean2Boolean(true));
            workspaceFoldersOptions.setChangeNotifications(Predef$.MODULE$.boolean2Boolean(true));
            WorkspaceServerCapabilities workspaceServerCapabilities = new WorkspaceServerCapabilities(workspaceFoldersOptions);
            capabilities.setWorkspace(workspaceServerCapabilities);
            ServerInfo serverInfo = new ServerInfo(new StringBuilder(21).append("Embedded DataWeave (").append($this.configuration.lspID()).append(")").toString());
            this.logger().debug(new StringBuilder(46).append("Initialize: Finished. Server: ").append(serverInfo).append(", Capabilities: ").append(capabilities).toString());
            return new InitializeResult(capabilities, serverInfo);
        });
    }

    public void initialized(InitializedParams params) {
        this.clientLogger().logInfo("Initialized");
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.supplyAsync(() -> {
            Option<WeaveLanguageServerBuilder.TextDocumentTranslator> option;
            if ($this.configuration.fileScheme().isDefined()) {
                $this.workspaceServiceManager.diagnosticsPublisherService().removePublisher(this.diagnosticsPublisher());
                $this.workspaceServiceManager.workspaceEditService().removeApplier(this.workspaceEditApplier());
                option = $this.workspaceServiceManager.textDocumentTranslatorService().removeTranslator((String)$this.configuration.fileScheme().get());
            } else {
                option = BoxedUnit.UNIT;
            }
            $this.workspaceServiceManager.addWorkspaceServiceListeners(this);
            this.logger().debug("Stopped");
            return null;
        });
    }

    public void exit() {
    }

    @JsonDelegate
    public WeaveTextDocumentService getTextDocumentService() {
        return this.textDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceServiceManager.workspaceService();
    }

    public void connect(LanguageClient client) {
        this.languageClient().delegate_$eq(client);
    }

    public ExecutorService executor() {
        return IDEExecutors$.MODULE$.defaultExecutor();
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.settings().update(params.getSettings());
    }

    @Override
    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        params.getEvent().getRemoved().forEach(removedWorkspaceFolder -> {
            Option<ProjectKind> option = $this.workspaceServiceManager.onProjectKindRemoved(removedWorkspaceFolder.getUri());
            if (option instanceof Some) {
                Some some = (Some)option;
                ProjectKind projectKind = (ProjectKind)some.value();
                this.textDocumentServiceImpl().onProjectRemoved(projectKind);
                projectKind.shutdown();
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logger().debug(new StringBuilder(44).append("There is no projectKind registered for URI: ").append(removedWorkspaceFolder.getUri()).toString());
                return;
            }
            throw new MatchError(option);
        });
        params.getEvent().getAdded().forEach(addedWorkspaceFolder -> {
            try {
                this.discoverAndRegisterProjectKind((WorkspaceFolder)addedWorkspaceFolder);
            }
            catch (Exception e) {
                this.clientLogger().logError(new StringBuilder(48).append("Unable to discover project for workspaceFolder: ").append(addedWorkspaceFolder.getUri()).toString(), e);
            }
        });
    }

    private ProjectKind discoverAndRegisterProjectKind(WorkspaceFolder addedWorkspaceFolder) {
        DefaultProjectMetadata projectMetadata = new DefaultProjectMetadata((Option<String>)Option$.MODULE$.apply((Object)addedWorkspaceFolder.getUri()), this.settings());
        ProjectKind projectKind = this.createProjectKind(projectMetadata, this.clientLoggerFactory());
        this.textDocumentServiceImpl().onProjectKindCreated(projectKind, new DataWeaveDocumentService(projectKind, this.executor(), true, true));
        this.workspaceServiceManager.onProjectKindCreated(addedWorkspaceFolder.getUri(), projectKind, new DefaultBaseWorkspaceServiceContributor(projectKind, projectMetadata, this.protocolService.getClient(), this.workspaceServiceManager.commandManagerService(), this.configuration.textDocumentLocator()));
        return projectKind;
    }

    private ProjectKind createProjectKind(DefaultProjectMetadata projectMetadata, ClientLoggerFactory clientLoggerFactory) {
        WorkspaceEditService workspaceEditsService = this.workspaceServiceManager.workspaceEditService();
        ProjectKind projectKind = this.projectKindFactory.createKind(new ProjectKindContext(projectMetadata, clientLoggerFactory, this.protocolService.getClient(), this.jobManagerService, workspaceEditsService));
        projectKind.initialize();
        projectMetadata.setEventBus(projectKind.eventBus());
        return projectKind;
    }

    public EmbeddedWeaveLanguageServer(ProjectKindFactory projectKindFactory, EmbeddedLanguageServerConfiguration configuration, DataWeaveProtocolService protocolService, WorkspaceServiceManager workspaceServiceManager, JobManagerService jobManagerService) {
        this.projectKindFactory = projectKindFactory;
        this.configuration = configuration;
        this.protocolService = protocolService;
        this.workspaceServiceManager = workspaceServiceManager;
        this.jobManagerService = jobManagerService;
        WorkspaceServiceListener.$init$(this);
        this.logger = LoggerFactory.getLogger(EmbeddedWeaveLanguageServer.class);
        this.textDocumentService = new TextDocumentServiceDelegate();
        this.textDocumentServiceImpl = new DataWeaveDocumentServiceDispatcher(configuration.codeLens(), configuration.textDocumentLocator(), DataWeaveDocumentServiceDispatcher$.MODULE$.$lessinit$greater$default$3());
        this.languageClient = new LanguageClientDelegate();
        this.settings = new ProjectSettings(ProjectSettings$.MODULE$.apply$default$1(), ProjectSettings$.MODULE$.apply$default$2(), ProjectSettings$.MODULE$.apply$default$3(), ProjectSettings$.MODULE$.apply$default$4(), ProjectSettings$.MODULE$.apply$default$5(), ProjectSettings$.MODULE$.apply$default$6(), ProjectSettings$.MODULE$.apply$default$7(), ProjectSettings$.MODULE$.apply$default$8(), ProjectSettings$.MODULE$.apply$default$9(), ProjectSettings$.MODULE$.apply$default$10(), ProjectSettings$.MODULE$.apply$default$11());
        this.workspaceEditApplier = new WorkspaceEditApplier(this.languageClient(), configuration.fileScheme());
        this.diagnosticsPublisher = new DiagnosticsPublisher(this.languageClient(), configuration.fileScheme());
    }
}

