/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.lsp.actions.CodeActionsManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.commands.InsertDocumentationCommand$;
import org.mule.weave.lsp.commands.LSPWeaveTextDocument;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration$;
import org.mule.weave.lsp.extension.protocol.SampleInput;
import org.mule.weave.lsp.extension.services.DidFocusChangeParams;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.TextDocumentTranslatorService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent;
import org.mule.weave.lsp.services.events.DocumentSavedEvent;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.v2.completion.Suggestion;
import org.mule.weave.v2.completion.SuggestionResult;
import org.mule.weave.v2.completion.SuggestionType$;
import org.mule.weave.v2.editor.AstNodeResult;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.editor.RegionKind$;
import org.mule.weave.v2.editor.SymbolInformation;
import org.mule.weave.v2.editor.SymbolKind$;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.InputDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.scope.Reference;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.signature.FunctionSignatureResult;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0011Ec\u0001B\u001a5\u0001}B\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003a\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001dy\u0007A1A\u0005\nADaa\u001e\u0001!\u0002\u0013\t\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005\u007f\"A\u0011Q\u0002\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011\u0011\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011Q\u0006\u0001!\u0002\u0013\ti\u0002C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u00022!A\u0011q\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u00111\u000f\u0001!\u0002\u0013\t)\u0005C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\t)\r\u0001C!\u0003\u000fDq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u000e\u0001!\tEa\u0004\t\u000f\t\u0005\u0002\u0001\"\u0003\u0003$!9!1\f\u0001\u0005\n\tu\u0003b\u0002B@\u0001\u0011\u0005#\u0011\u0011\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011y\u000e\u0001C\u0005\u0005CDqA!;\u0001\t\u0013\u0011Y\u000fC\u0004\u0003p\u0002!IA!=\t\u000f\tm\b\u0001\"\u0003\u0003~\"911\u0001\u0001\u0005\n\r\u0015\u0001bBB\u0006\u0001\u0011\u00053Q\u0002\u0005\b\u0007+\u0001A\u0011IB\f\u0011\u001d\u0019Y\u0003\u0001C!\u0007[Aqa!\u0013\u0001\t\u0003\u001aY\u0005C\u0004\u0004R\u0001!\tea\u0015\t\u000f\r\u0015\u0004\u0001\"\u0001\u0004h!91\u0011\u0010\u0001\u0005B\rm\u0004bBBL\u0001\u0011\u00053\u0011\u0014\u0005\b\u0007\u0017\u0004A\u0011BBg\u0011\u001d\u0019)\u000e\u0001C!\u0007/Dqa!>\u0001\t\u0003\u001a9\u0010C\u0004\u0005\u000e\u0001!\t\u0005b\u0004\t\u000f\u0011\u0005\u0002\u0001\"\u0011\u0005$!9A\u0011\b\u0001\u0005\n\u0011m\"\u0001\u0007#bi\u0006<V-\u0019<f\t>\u001cW/\\3oiN+'O^5dK*\u0011QGN\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0007O\u0001\u0004YN\u0004(BA\u001d;\u0003\u00159X-\u0019<f\u0015\tYD(\u0001\u0003nk2,'\"A\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\u0005\n\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006!A.\u00198h\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012\"\u0003\r=\u0013'.Z2u!\tIU*D\u0001K\u0015\t)4J\u0003\u0002Mm\u0005IQ\r\u001f;f]NLwN\\\u0005\u0003\u001d*\u0013\u0001dV3bm\u0016$V\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\u0003-\u0001(o\u001c6fGR\\\u0015N\u001c3\u0011\u0005E#V\"\u0001*\u000b\u0005M3\u0014a\u00029s_*,7\r^\u0005\u0003+J\u00131\u0002\u0015:pU\u0016\u001cGoS5oI\u0006AQ\r_3dkR|'\u000f\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005q#\u0015\u0001B;uS2L!AX-\u0003\u0011\u0015CXmY;u_J\f!d];qa>\u0014H/\u00113e+:LG\u000fV3ti\u000e{G-\u001a'f]N\u0004\"!\u00193\u000e\u0003\tT\u0011aY\u0001\u0006g\u000e\fG.Y\u0005\u0003K\n\u0014qAQ8pY\u0016\fg.A\u000btkB\u0004xN\u001d;Sk:l\u0015\r\u001d9j]\u001edUM\\:\u0002\rqJg.\u001b;?)\u0015I7\u000e\\7o!\tQ\u0007!D\u00015\u0011\u0015yU\u00011\u0001Q\u0011\u00151V\u00011\u0001X\u0011\u0015yV\u00011\u0001a\u0011\u00151W\u00011\u0001a\u0003\u0019awnZ4feV\t\u0011\u000f\u0005\u0002sk6\t1O\u0003\u0002uy\u0005)1\u000f\u001c45U&\u0011ao\u001d\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005yAo\\8mS:<7+\u001a:wS\u000e,7/F\u0001{!\tQ70\u0003\u0002}i\t9B)\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-Z\u0001\u0011i>|G.\u001b8h'\u0016\u0014h/[2fg\u0002\n\u0011\u0002\u001d:pU\u0016\u001cGOR*\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da'A\u0002wMNLA!a\u0003\u0002\u0006\tA\u0002K]8kK\u000e$h)\u001b7f'f\u001cH/Z7TKJ4\u0018nY3\u0002\u0015A\u0014xN[3di\u001a\u001b\u0006%\u0001\ttG\u0016t\u0017M]5pgN+'O^5dKV\u0011\u00111\u0003\t\u0004U\u0006U\u0011bAA\fi\tYr+Z1wKN\u001bWM\\1sS>l\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\f\u0011c]2f]\u0006\u0014\u0018n\\:TKJ4\u0018nY3!+\t\ti\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\r\u0015$\u0017\u000e^8s\u0015\r\t9\u0003O\u0001\u0003mJJA!a\u000b\u0002\"\t\tb+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0002\tY47\u000fI\u0001\u001aG>$W-Q2uS>t7/T1oC\u001e,'oU3sm&\u001cW-\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:Y\nq!Y2uS>t7/\u0003\u0003\u0002>\u0005]\"!G\"pI\u0016\f5\r^5p]Nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\f!dY8eK\u0006\u001bG/[8og6\u000bg.Y4feN+'O^5dK\u0002\na\u0003^3yi\u0012{7-^7f]R$&/\u00198tY\u0006$xN]\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002n9!\u0011\u0011JA4\u001d\u0011\tY%!\u0019\u000f\t\u00055\u0013q\f\b\u0005\u0003\u001f\niF\u0004\u0003\u0002R\u0005mc\u0002BA*\u00033j!!!\u0016\u000b\u0007\u0005]c(\u0001\u0004=e>|GOP\u0005\u0002{%\u00111\bP\u0005\u0003siJ!\u0001\u0014\u001d\n\t\u0005\r\u0014QM\u0001\u0004CBL'B\u0001'9\u0013\u0011\tI'a\u001b\u00025]+\u0017M^3MC:<W/Y4f'\u0016\u0014h/\u001a:Ck&dG-\u001a:\u000b\t\u0005\r\u0014QM\u0005\u0005\u0003_\n\tH\u0001\fUKb$Hi\\2v[\u0016tG\u000f\u0016:b]Nd\u0017\r^8s\u0015\u0011\tI'a\u001b\u0002/Q,\u0007\u0010\u001e#pGVlWM\u001c;Ue\u0006t7\u000f\\1u_J\u0004\u0013a\u00023jI>\u0003XM\u001c\u000b\u0005\u0003s\ny\bE\u0002b\u0003wJ1!! c\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005E\u00031\u0001\u0002\u0004\u0006Iq\u000e]3o!\u0006\u0014\u0018-\u001c\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003\u0015a7\u000f\u001d\u001bk\u0015\r\ti\tP\u0001\bK\u000ed\u0017\u000e]:f\u0013\u0011\t\t*a\"\u00033\u0011KGm\u00149f]R+\u0007\u0010\u001e#pGVlWM\u001c;QCJ\fWn]\u0001\nI&$7\t[1oO\u0016$B!!\u001f\u0002\u0018\"9\u0011\u0011T\u000bA\u0002\u0005m\u0015A\u00029be\u0006l7\u000f\u0005\u0003\u0002\u0006\u0006u\u0015\u0002BAP\u0003\u000f\u00131\u0004R5e\u0007\"\fgnZ3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018\u0001\u00033jI\u000ecwn]3\u0015\t\u0005e\u0014Q\u0015\u0005\b\u000333\u0002\u0019AAT!\u0011\t))!+\n\t\u0005-\u0016q\u0011\u0002\u001b\t&$7\t\\8tKR+\u0007\u0010\u001e#pGVlWM\u001c;QCJ\fWn]\u0001\bI&$7+\u0019<f)\u0011\tI(!-\t\u000f\u0005eu\u00031\u0001\u00024B!\u0011QQA[\u0013\u0011\t9,a\"\u00033\u0011KGmU1wKR+\u0007\u0010\u001e#pGVlWM\u001c;QCJ\fWn]\u0001\u000fI&$gi\\2vg\u000eC\u0017M\\4f)\u0011\tI(!0\t\u000f\u0005e\u0005\u00041\u0001\u0002@B\u0019\u0011*!1\n\u0007\u0005\r'J\u0001\u000bES\u00124unY;t\u0007\"\fgnZ3QCJ\fWn]\u0001\u000bG>l\u0007\u000f\\3uS>tG\u0003BAe\u0003g\u0004R\u0001WAf\u0003\u001fL1!!4Z\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003#\fY.a8\u0002n6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.\u0001\u0005nKN\u001c\u0018mZ3t\u0015\u0011\tI.a\"\u0002\u000f)\u001cxN\u001c:qG&!\u0011Q\\Aj\u0005\u0019)\u0015\u000e\u001e5feB1\u0011\u0011]Ar\u0003Ol\u0011aW\u0005\u0004\u0003K\\&\u0001\u0002'jgR\u0004B!!\"\u0002j&!\u00111^AD\u00059\u0019u.\u001c9mKRLwN\\%uK6\u0004B!!\"\u0002p&!\u0011\u0011_AD\u00059\u0019u.\u001c9mKRLwN\u001c'jgRDq!!>\u001a\u0001\u0004\t90\u0001\u0005q_NLG/[8o!\u0011\t))!?\n\t\u0005m\u0018q\u0011\u0002\u0011\u0007>l\u0007\u000f\\3uS>t\u0007+\u0019:b[N\fQeZ3u'V<w-Z:uS>t7/\u00118e\u0007J,\u0017\r^3D_6\u0004H.\u001a;j_:d\u0015n\u001d;\u0015\r\u0005='\u0011\u0001B\u0006\u0011\u001d\u0011\u0019A\u0007a\u0001\u0005\u000b\ta\u0002^8pY&twmU3sm&\u001cW\r\u0005\u0003\u0002 \t\u001d\u0011\u0002\u0002B\u0005\u0003C\u00111dV3bm\u0016$unY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007bBA{5\u0001\u0007\u0011q_\u0001\u000eg&<g.\u0019;ve\u0016DU\r\u001c9\u0015\t\tE!\u0011\u0004\t\u00061\u0006-'1\u0003\t\u0005\u0003\u000b\u0013)\"\u0003\u0003\u0003\u0018\u0005\u001d%!D*jO:\fG/\u001e:f\u0011\u0016d\u0007\u000fC\u0004\u0002\u001an\u0001\rAa\u0007\u0011\t\u0005\u0015%QD\u0005\u0005\u0005?\t9IA\nTS\u001et\u0017\r^;sK\"+G\u000e\u001d)be\u0006l7/\u0001\nhKRLe\u000e];u\t&\u0014Xm\u0019;jm\u0016\u001cH\u0003\u0002B\u0013\u0005\u0013\u0002bAa\n\u0003.\tERB\u0001B\u0015\u0015\r\u0011YCY\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0018\u0005S\u00111aU3r!\u0011\u0011\u0019D!\u0012\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\t!\u0002Z5sK\u000e$\u0018N^3t\u0015\u0011\u0011YD!\u0010\u0002\r!,\u0017\rZ3s\u0015\u0011\u0011yD!\u0011\u0002\u0007\u0005\u001cHO\u0003\u0003\u0003D\u0005\u0015\u0012A\u00029beN,'/\u0003\u0003\u0003H\tU\"AD%oaV$H)\u001b:fGRLg/\u001a\u0005\b\u0005\u0017b\u0002\u0019\u0001B'\u00031i\u0017-\u001f2f\u0003N$hj\u001c3f!\u0015\t'q\nB*\u0013\r\u0011\tF\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tU#qK\u0007\u0003\u0005{IAA!\u0017\u0003>\t9\u0011i\u001d;O_\u0012,\u0017!F2sK\u0006$X-T1qa&tw\rV3ti2+gn\u001d\u000b\u0005\u0005?\u0012Y\u0007\u0005\u0004\u0002b\n\u0005$QM\u0005\u0004\u0005GZ&!C!se\u0006LH*[:u!\u0011\t)Ia\u001a\n\t\t%\u0014q\u0011\u0002\t\u0007>$W\rT3og\"9!QN\u000fA\u0002\t=\u0014aA;sYB!!\u0011\u000fB=\u001d\u0011\u0011\u0019H!\u001e\u0011\u0007\u0005M#-C\u0002\u0003x\t\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B>\u0005{\u0012aa\u0015;sS:<'b\u0001B<E\u0006A1m\u001c3f\u0019\u0016t7\u000f\u0006\u0003\u0003\u0004\ne\u0005#\u0002-\u0002L\n\u0015\u0005\u0007\u0002BD\u0005\u001b\u0003b!!9\u0002d\n%\u0005\u0003\u0002BF\u0005\u001bc\u0001\u0001B\u0006\u0003\u0010z\t\t\u0011!A\u0003\u0002\tE%aA0%cE!!1\u0013B3!\r\t'QS\u0005\u0004\u0005/\u0013'a\u0002(pi\"Lgn\u001a\u0005\b\u00033s\u0002\u0019\u0001BN!\u0011\t)I!(\n\t\t}\u0015q\u0011\u0002\u000f\u0007>$W\rT3ogB\u000b'/Y7t\u0003A\u0019\u0018-\u001c9mK\u0012\u000bG/\u0019'f]N,7\u000f\u0006\u0006\u0003`\t\u0015&q\u0017Bd\u00057DqAa* \u0001\u0004\u0011I+A\u0007nCf\u0014WmU2f]\u0006\u0014\u0018n\u001c\t\u0006C\n=#1\u0016\t\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*\u0019!\u0011\u0017*\u0002\u0015\r|W\u000e]8oK:$8/\u0003\u0003\u00036\n=&\u0001C*dK:\f'/[8\t\u000f\tev\u00041\u0001\u0003<\u0006qa.Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0003\u0002B_\u0005\u0007l!Aa0\u000b\t\t\u0005'QH\u0001\nm\u0006\u0014\u0018.\u00192mKNLAA!2\u0003@\nqa*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002Be?\u0001\u0007!1Z\u0001\u0010S:\u0004X\u000f\u001e#je\u0016\u001cG/\u001b<fgB1!Q\u001aBl\u0005cqAAa4\u0003T:!\u00111\u000bBi\u0013\u0005\u0019\u0017b\u0001BkE\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0018\u00053T1A!6c\u0011\u001d\u0011in\ba\u0001\u0005_\n1!\u001e:j\u00035!wnY*uCJ$(+\u00198hKR\u0011!1\u001d\t\u0005\u0003\u000b\u0013)/\u0003\u0003\u0003h\u0006\u001d%!\u0002*b]\u001e,\u0017A\u0004:v]6\u000b\u0007\u000f]5oO2+gn\u001d\u000b\u0005\u0005K\u0012i\u000fC\u0004\u0003:\u0006\u0002\rAa/\u0002\u001b%t\u0007/\u001e;GS2,g*Y7f)\u0011\u0011\u0019Pa>\u0011\u0007\u0005\u0013)0C\u0002\u0003|\tCqA!?#\u0001\u0004\u0011\t$\u0001\u0002jI\u00061\u0012\r\u001a3E_\u000e,X.\u001a8uCRLwN\u001c'f]N,7\u000f\u0006\u0004\u0003`\t}8\u0011\u0001\u0005\b\u0005\u007f\u0019\u0003\u0019\u0001B*\u0011\u001d\u0011in\ta\u0001\u0005_\n\u0011#\u00193e+:LG\u000fV3ti2+gn]3t)\u0019\u0011yfa\u0002\u0004\n!9!q\b\u0013A\u0002\tM\u0003b\u0002BoI\u0001\u0007!qN\u0001\u0010e\u0016\u001cx\u000e\u001c<f\u0007>$W\rT3ogR!1qBB\t!\u0015A\u00161\u001aB3\u0011\u001d\u0019\u0019\"\na\u0001\u0005K\n!\"\u001e8sKN|GN^3e\u000311w\u000e\u001c3j]\u001e\u0014\u0016M\\4f)\u0011\u0019Iba\t\u0011\u000ba\u000bYma\u0007\u0011\r\u0005\u0005\u00181]B\u000f!\u0011\t)ia\b\n\t\r\u0005\u0012q\u0011\u0002\r\r>dG-\u001b8h%\u0006tw-\u001a\u0005\b\u000333\u0003\u0019AB\u0013!\u0011\t)ia\n\n\t\r%\u0012q\u0011\u0002\u001a\r>dG-\u001b8h%\u0006tw-\u001a*fcV,7\u000f\u001e)be\u0006l7/\u0001\u0006d_\u0012,\u0017i\u0019;j_:$Baa\f\u0004BA)\u0001,a3\u00042A1\u0011\u0011]Ar\u0007g\u0001\u0002\"!5\u0002\\\u000eU21\b\t\u0005\u0003\u000b\u001b9$\u0003\u0003\u0004:\u0005\u001d%aB\"p[6\fg\u000e\u001a\t\u0005\u0003\u000b\u001bi$\u0003\u0003\u0004@\u0005\u001d%AC\"pI\u0016\f5\r^5p]\"9\u0011\u0011T\u0014A\u0002\r\r\u0003\u0003BAC\u0007\u000bJAaa\u0012\u0002\b\n\u00012i\u001c3f\u0003\u000e$\u0018n\u001c8QCJ\fWn]\u0001\u0016e\u0016\u001cx\u000e\u001c<f\u0007>l\u0007\u000f\\3uS>t\u0017\n^3n)\u0011\u0019iea\u0014\u0011\u000ba\u000bY-a:\t\u000f\rM\u0001\u00061\u0001\u0002h\u0006)\u0001n\u001c<feR!1QKB/!\u0015A\u00161ZB,!\u0011\t)i!\u0017\n\t\rm\u0013q\u0011\u0002\u0006\u0011>4XM\u001d\u0005\b\u00033K\u0003\u0019AB0!\u0011\t)i!\u0019\n\t\r\r\u0014q\u0011\u0002\f\u0011>4XM\u001d)be\u0006l7/\u0001\u0007u_NKXNY8m\u0017&tG\r\u0006\u0003\u0004j\r=\u0004\u0003BAC\u0007WJAa!\u001c\u0002\b\nQ1+_7c_2\\\u0015N\u001c3\t\u000f\rE$\u00061\u0001\u0004t\u0005!1.\u001b8e!\r\t7QO\u0005\u0004\u0007o\u0012'aA%oi\u0006qAm\\2v[\u0016tGoU=nE>dG\u0003BB?\u0007\u001f\u0003R\u0001WAf\u0007\u007f\u0002b!!9\u0002d\u000e\u0005\u0005\u0003CAi\u00037\u001c\u0019i!#\u0011\t\u0005\u00155QQ\u0005\u0005\u0007\u000f\u000b9IA\tTs6\u0014w\u000e\\%oM>\u0014X.\u0019;j_:\u0004B!!\"\u0004\f&!1QRAD\u00059!unY;nK:$8+_7c_2Dq!!',\u0001\u0004\u0019\t\n\u0005\u0003\u0002\u0006\u000eM\u0015\u0002BBK\u0003\u000f\u0013A\u0003R8dk6,g\u000e^*z[\n|G\u000eU1sC6\u001c\u0018A\u00033fM&t\u0017\u000e^5p]R!11TBb!\u0015A\u00161ZBO!!\t\t.a7\u0004 \u000eE\u0006\u0007BBQ\u0007K\u0003b!!9\u0002d\u000e\r\u0006\u0003\u0002BF\u0007K#1ba*-\u0003\u0003\u0005\tQ!\u0001\u0004*\n\u0019q\f\n\u001a\u0012\t\tM51\u0016\t\u0005\u0003\u000b\u001bi+\u0003\u0003\u00040\u0006\u001d%\u0001\u0003'pG\u0006$\u0018n\u001c81\t\rM6q\u0017\t\u0007\u0003C\f\u0019o!.\u0011\t\t-5q\u0017\u0003\f\u0007sc\u0013\u0011!A\u0001\u0006\u0003\u0019YLA\u0002`IM\nBAa%\u0004>B!\u0011QQB`\u0013\u0011\u0019\t-a\"\u0003\u00191{7-\u0019;j_:d\u0015N\\6\t\u000f\u0005eE\u00061\u0001\u0004FB!\u0011QQBd\u0013\u0011\u0019I-a\"\u0003!\u0011+g-\u001b8ji&|g\u000eU1sC6\u001c\u0018A\u0003:fg>dg/Z+sYR!1qZBi!\u0015\t'q\nB8\u0011\u001d\u0019\u0019.\fa\u0001\u0005w\u000b!\"\\8ek2,g*Y7f\u0003)1wN]7biRLgn\u001a\u000b\u0005\u00073\u001ci\u000fE\u0003Y\u0003\u0017\u001cY\u000e\r\u0003\u0004^\u000e\u0005\bCBAq\u0003G\u001cy\u000e\u0005\u0003\u0003\f\u000e\u0005HaCBr]\u0005\u0005\t\u0011!B\u0001\u0007K\u00141a\u0018\u00135#\u0011\u0011\u0019ja:\u0011\t\u0005\u00155\u0011^\u0005\u0005\u0007W\f9I\u0001\u0005UKb$X\tZ5u\u0011\u001d\tIJ\fa\u0001\u0007_\u0004B!!\"\u0004r&!11_AD\u0005a!unY;nK:$hi\u001c:nCR$\u0018N\\4QCJ\fWn]\u0001\u0010e\u0006tw-\u001a$pe6\fG\u000f^5oOR!1\u0011 C\u0003!\u0015A\u00161ZB~a\u0011\u0019i\u0010\"\u0001\u0011\r\u0005\u0005\u00181]B\u0000!\u0011\u0011Y\t\"\u0001\u0005\u0017\u0011\rq&!A\u0001\u0002\u000b\u00051Q\u001d\u0002\u0004?\u0012*\u0004bBAM_\u0001\u0007Aq\u0001\t\u0005\u0003\u000b#I!\u0003\u0003\u0005\f\u0005\u001d%!\b#pGVlWM\u001c;SC:<WMR8s[\u0006$H/\u001b8h!\u0006\u0014\u0018-\\:\u0002\rI,g.Y7f)\u0011!\t\u0002\"\u0007\u0011\u000ba\u000bY\rb\u0005\u0011\t\u0005\u0015EQC\u0005\u0005\t/\t9IA\u0007X_J\\7\u000f]1dK\u0016#\u0017\u000e\u001e\u0005\b\u00033\u0003\u0004\u0019\u0001C\u000e!\u0011\t)\t\"\b\n\t\u0011}\u0011q\u0011\u0002\r%\u0016t\u0017-\\3QCJ\fWn]\u0001\u000be\u00164WM]3oG\u0016\u001cH\u0003\u0002C\u0013\tc\u0001R\u0001WAf\tO\u0001D\u0001\"\u000b\u0005.A1\u0011\u0011]Ar\tW\u0001BAa#\u0005.\u0011YAqF\u0019\u0002\u0002\u0003\u0005)\u0011ABU\u0005\ryFE\u000e\u0005\b\u00033\u000b\u0004\u0019\u0001C\u001a!\u0011\t)\t\"\u000e\n\t\u0011]\u0012q\u0011\u0002\u0010%\u00164WM]3oG\u0016\u0004\u0016M]1ng\u0006\tr-\u001a;D_6\u0004H.\u001a;j_:$\u0016\u0010]3\u0015\t\u0011uB1\t\t\u0005\u0003\u000b#y$\u0003\u0003\u0005B\u0005\u001d%AE\"p[BdW\r^5p]&#X-\\&j]\u0012Dq\u0001\"\u00123\u0001\u0004!9%A\u0002tk\u001e\u0004B\u0001\"\u0013\u0005N5\u0011A1\n\u0006\u0005\u0003\u000b\f)#\u0003\u0003\u0005P\u0011-#AC*vO\u001e,7\u000f^5p]\u0002")
public class DataWeaveDocumentService
implements WeaveTextDocumentService {
    private final ProjectKind projectKind;
    private final Executor executor;
    private final boolean supportAddUnitTestCodeLens;
    private final boolean supportRunMappingLens;
    private final Logger logger;
    private final DataWeaveToolingService toolingServices;
    private final ProjectFileSystemService projectFS;
    private final WeaveScenarioManagerService scenariosService;
    private final VirtualFileSystem vfs;
    private final CodeActionsManagerService codeActionsManagerService;
    private final WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator;

    private Logger logger() {
        return this.logger;
    }

    private DataWeaveToolingService toolingServices() {
        return this.toolingServices;
    }

    private ProjectFileSystemService projectFS() {
        return this.projectFS;
    }

    private WeaveScenarioManagerService scenariosService() {
        return this.scenariosService;
    }

    private VirtualFileSystem vfs() {
        return this.vfs;
    }

    private CodeActionsManagerService codeActionsManagerService() {
        return this.codeActionsManagerService;
    }

    private WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator() {
        return this.textDocumentTranslator;
    }

    public void didOpen(DidOpenTextDocumentParams openParam) {
        TextDocumentItem textDocument = openParam.getTextDocument();
        String uri = textDocument.getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().update(uri, openParam.getTextDocument().getText());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentOpenedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentOpenedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        String uri = textDocument.getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().update(uri, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.toolingServices().closeDocument(uri);
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().closed(uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentClosedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentClosedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().saved(params.getTextDocument().getUri());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentSavedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentSavedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void didFocusChange(DidFocusChangeParams params) {
        String uri = params.textDocumentIdentifier().getUri();
        Option maybeVirtualFile = Option$.MODULE$.apply((Object)this.projectFS().file(uri));
        Option option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(position.getTextDocument().getUri());
            return this.getSuggestionsAndCreateCompletionList(toolingService, position);
        }, this.executor);
    }

    private Either<java.util.List<CompletionItem>, CompletionList> getSuggestionsAndCreateCompletionList(WeaveDocumentToolingService toolingService, CompletionParams position) {
        int offset = toolingService.offsetOf(position.getPosition().getLine(), position.getPosition().getCharacter());
        SuggestionResult suggestionResult = toolingService.completion(offset);
        ArrayList result = new ArrayList();
        IntRef i = IntRef.create((int)0);
        Suggestion[] suggestions = suggestionResult.suggestions();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])suggestions)).foreach((Function1 & Serializable & scala.Serializable)sug -> {
            DataWeaveDocumentService.$anonfun$getSuggestionsAndCreateCompletionList$1(this, i, suggestionResult, toolingService, result, sug);
            return BoxedUnit.UNIT;
        });
        return Either.forRight((Object)new CompletionList(false, result));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Position position;
            int offset;
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Option maybeResult = toolingService.signatureInfo(offset = toolingService.offsetOf((position = params.getPosition()).getLine(), position.getCharacter()));
            Option option = maybeResult;
            if (option instanceof Some) {
                Some some = (Some)option;
                FunctionSignatureResult signatureResult = (FunctionSignatureResult)some.value();
                SignatureInformation[] signatures = (SignatureInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).map((Function1 & Serializable & scala.Serializable)s -> {
                    ParameterInformation[] informations = (ParameterInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.parameters())).map((Function1 & Serializable & scala.Serializable)p -> new ParameterInformation(new StringBuilder(2).append(p.name()).append(": ").append(p.wtype().toString()).toString(), ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParameterInformation.class)));
                    MarkupContent documentation = (MarkupContent)s.docAsMarkdown().map((Function1 & Serializable & scala.Serializable)d -> new MarkupContent("markdown", d)).orNull(Predef$.MODULE$.$conforms());
                    String arguments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])informations)).map((Function1 & Serializable & scala.Serializable)i -> (String)i.getLabel().getLeft(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                    return new SignatureInformation(new StringBuilder(2).append(signatureResult.name()).append("(").append(arguments).append(")").toString(), documentation, Arrays.asList((Object[])informations));
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SignatureInformation.class)));
                int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).indexWhere((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.active()));
                return new SignatureHelp(Arrays.asList((Object[])signatures), Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(signatureResult.currentArgIndex()));
            }
            if (None$.MODULE$.equals(option)) {
                return new SignatureHelp();
            }
            throw new MatchError((Object)option);
        });
    }

    private Seq<InputDirective> getInputDirectives(Option<AstNode> maybeAstNode) {
        return (Seq)maybeAstNode.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AstNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DocumentNode) {
                    DocumentNode documentNode = (DocumentNode)A1;
                    return (B1)documentNode;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(AstNode x1) {
                AstNode astNode = x1;
                return astNode instanceof DocumentNode;
            }
        }).map((Function1 & Serializable & scala.Serializable)documentNode -> (Seq)AstNodeHelper$.MODULE$.getInputs(documentNode).filter((Function1 & Serializable & scala.Serializable)inputDirective -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$getInputDirectives$3(inputDirective)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private ArrayList<CodeLens> createMappingTestLens(String url) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        Option<File> maybeFile = ProjectStructureHelper$.MODULE$.defaultTestSourceFolder(this.projectKind.structure());
        if (maybeFile.isDefined()) {
            Command command = new Command("Create Integration Mapping", Commands$.MODULE$.DW_CREATE_TEST_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl((File)maybeFile.get()), url));
            object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
        } else {
            object = BoxedUnit.UNIT;
        }
        return lenses;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.supplyAsync(() -> DataWeaveDocumentService.$anonfun$codeLens$1(this, params));
    }

    private ArrayList<CodeLens> sampleDataLenses(Option<Scenario> maybeScenario, NameIdentifier nameIdentifier, Seq<InputDirective> inputDirectives, String uri) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        if (maybeScenario.isEmpty()) {
            Object object2;
            if (inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, Scenario$.MODULE$.PLAYGROUND_SCENARIO()));
                object2 = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$sampleDataLenses$1(this, nameIdentifier, uri, lenses, id)));
            object = BoxedUnit.UNIT;
        } else {
            SampleInput[] scenarioInputs = ((Scenario)maybeScenario.get()).inputs();
            Map inputs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name());
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).isEmpty() && inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, ((Scenario)maybeScenario.get()).name()));
                object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    if (!inputs.contains((Object)id.variable().name())) {
                        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier.name(), ((Scenario)maybeScenario.get()).name(), uri, id.variable().name(), this.inputFileName((InputDirective)id)));
                        return BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null)));
                    }
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
        }
        return lenses;
    }

    private Range docStartRange() {
        Position docStart = new Position(0, 0);
        return new Range(docStart, docStart);
    }

    private CodeLens runMappingLens(NameIdentifier nameIdentifier) {
        Command runMappingCommand = new Command("Run Mapping", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl(Path.of(this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), "false"));
        return new CodeLens(this.docStartRange(), runMappingCommand, null);
    }

    private String inputFileName(InputDirective id) {
        String extension = (String)id.mime().map((Function1 & Serializable & scala.Serializable)mime -> {
            String string = mime.mime();
            if ("application/json".equals(string)) {
                return ".json";
            }
            if ("application/java".equals(string)) {
                return ".dwl";
            }
            if ("application/xml".equals(string)) {
                return ".xml";
            }
            if ("application/yaml".equals(string)) {
                return ".yaml";
            }
            if ("application/x-ndjson".equals(string)) {
                return ".ndjson";
            }
            if ("application/octet-stream".equals(string)) {
                return ".bin";
            }
            if ("application/x-java-properties".equals(string)) {
                return ".properties";
            }
            if ("multipart/form-data".equals(string)) {
                return ".multipart";
            }
            if ("multipart/x-www-form-urlencoded".equals(string)) {
                return ".urlencoded";
            }
            if ("application/csv".equals(string) ? true : "text/csv".equals(string)) {
                return ".csv";
            }
            if ("text/plain".equals(string)) {
                return ".txt";
            }
            return new StringBuilder(1).append(".").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split("/"))).last()).toString();
        }).orElse((Function0 & Serializable & scala.Serializable)() -> id.dataFormat().map((Function1 & Serializable & scala.Serializable)id -> {
            String string = id.id();
            if ("text".equals(string)) {
                return ".txt";
            }
            if ("java".equals(string)) {
                return ".dwl";
            }
            if ("excel".equals(string)) {
                return ".xlsx";
            }
            if ("binary".equals(string)) {
                return ".bin";
            }
            return new StringBuilder(1).append(".").append(string).toString();
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".json");
        return new StringBuilder(0).append(id.variable().name()).append(extension).toString();
    }

    private ArrayList<CodeLens> addDocumentationLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result = new ArrayList<CodeLens>();
        Seq functionNodes = AstNodeHelper$.MODULE$.collectChildrenWith(ast, FunctionDirectiveNode.class);
        ((IterableLike)functionNodes.filter((Function1 & Serializable & scala.Serializable)fd -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$1(fd)))).foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$2(uri, result, astNode)));
        return result;
    }

    private ArrayList<CodeLens> addUnitTestLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result;
        block0: {
            result = new ArrayList<CodeLens>();
            AstNode astNode2 = ast;
            if (!(astNode2 instanceof ModuleNode)) break block0;
            ModuleNode moduleNode = (ModuleNode)astNode2;
            Seq topLevelFunctions = AstNodeHelper$.MODULE$.collectDirectChildrenWith((AstNode)moduleNode, FunctionDirectiveNode.class);
            topLevelFunctions.foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addUnitTestLenses$1(uri, result, astNode)));
        }
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<java.util.List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService service = this.toolingServices().openDocument(params.getTextDocument().getUri());
            FoldingRange[] regions = (FoldingRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])service.foldingRegions())).map((Function1 & Serializable & scala.Serializable)fr -> {
                FoldingRange range = new FoldingRange(fr.location().startPosition().line() - 1, fr.location().endPosition().line() - 1);
                int n = fr.kind();
                String kind = RegionKind$.MODULE$.COMMENTS() == n ? "comment" : "region";
                range.setKind(kind);
                return range;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FoldingRange.class)));
            return Arrays.asList((Object[])regions);
        });
    }

    public CompletableFuture<java.util.List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        String uri = params.getTextDocument().getUri();
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, new StringBuilder(110).append("Invalid request codeAction(").append(params.getTextDocument().getUri()).append("), virtual file not registered as opened yet didOpen should have been called first.").toString(), null);
            return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(error));
        }
        Optional contextMetadata = this.projectKind.metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        return CompletableFuture.supplyAsync(() -> {
            Seq<CodeAction> actions = this.codeActionsManagerService().codeActionsFor(params, contextMetadata);
            ArrayList result = new ArrayList();
            actions.foreach((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)result.add(Either.forRight((Object)a))));
            return result;
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Position position = params.getPosition();
            int offset = toolingService.offsetOf(position.getLine(), position.getCharacter());
            return (Hover)toolingService.hoverResult(offset).map((Function1 & Serializable & scala.Serializable)hm -> {
                Hover hoverResult = new Hover();
                boolean x$1 = false;
                boolean x$2 = true;
                boolean x$3 = false;
                Seq x$4 = (Seq)new .colon.colon((Object)"Documentation", (List)Nil$.MODULE$);
                boolean x$5 = true;
                boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                boolean x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$1, x$2, x$6, x$7, x$8, x$3, x$9, x$5, x$10, x$11, x$12, x$13, x$4, x$14, x$15, x$16);
                String expressionType = (String)Option$.MODULE$.apply((Object)hm.resultType()).map((Function1 & Serializable & scala.Serializable)wt -> new StringBuilder(9).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`\n").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                String documentation = new StringBuilder(1).append(expressionType).append("\n").append(hm.markdownDocs().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                hoverResult.setContents(new MarkupContent("markdown", documentation));
                hoverResult.setRange(LSPConverters$.MODULE$.toRange(hm.weaveLocation()));
                return hoverResult;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)toolingService.typeOf(offset)).map((Function1 & Serializable & scala.Serializable)wt -> {
                Hover hoverResult;
                block0: {
                    hoverResult = new Hover();
                    boolean x$17 = false;
                    boolean x$18 = true;
                    boolean x$19 = false;
                    boolean x$20 = true;
                    boolean x$21 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                    boolean x$22 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                    boolean x$23 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                    boolean x$24 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                    boolean x$25 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                    boolean x$26 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                    boolean x$27 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                    boolean x$28 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                    Seq x$29 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
                    boolean x$30 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                    boolean x$31 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                    Option x$32 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                    WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$20, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
                    String expressionType = new StringBuilder(8).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`").toString();
                    hoverResult.setContents(new MarkupContent("markdown", expressionType));
                    if (wt.location().startPosition().index() < 0) break block0;
                    hoverResult.setRange(LSPConverters$.MODULE$.toRange(wt.location()));
                }
                return hoverResult;
            })).orNull(Predef$.MODULE$.$conforms());
        }, this.executor);
    }

    public SymbolKind toSymbolKind(int kind) {
        int n = kind;
        if (SymbolKind$.MODULE$.Array() == n) {
            return SymbolKind.Array;
        }
        if (SymbolKind$.MODULE$.Boolean() == n) {
            return SymbolKind.Boolean;
        }
        if (SymbolKind$.MODULE$.Class() == n) {
            return SymbolKind.Class;
        }
        if (SymbolKind$.MODULE$.Constant() == n) {
            return SymbolKind.Constant;
        }
        if (SymbolKind$.MODULE$.Field() == n) {
            return SymbolKind.Field;
        }
        if (SymbolKind$.MODULE$.Module() == n) {
            return SymbolKind.Module;
        }
        if (SymbolKind$.MODULE$.Property() == n) {
            return SymbolKind.Property;
        }
        if (SymbolKind$.MODULE$.Namespace() == n) {
            return SymbolKind.Namespace;
        }
        if (SymbolKind$.MODULE$.String() == n) {
            return SymbolKind.String;
        }
        if (SymbolKind$.MODULE$.Variable() == n) {
            return SymbolKind.Variable;
        }
        if (SymbolKind$.MODULE$.Constructor() == n) {
            return SymbolKind.Constructor;
        }
        if (SymbolKind$.MODULE$.Enum() == n) {
            return SymbolKind.Enum;
        }
        if (SymbolKind$.MODULE$.Method() == n) {
            return SymbolKind.Method;
        }
        if (SymbolKind$.MODULE$.Function() == n) {
            return SymbolKind.Function;
        }
        if (SymbolKind$.MODULE$.File() == n) {
            return SymbolKind.File;
        }
        if (SymbolKind$.MODULE$.Package() == n) {
            return SymbolKind.Package;
        }
        if (SymbolKind$.MODULE$.Interface() == n) {
            return SymbolKind.Interface;
        }
        return SymbolKind.Property;
    }

    public CompletableFuture<java.util.List<Either<org.eclipse.lsp4j.SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            TextDocumentIdentifier document = params.getTextDocument();
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(document.getUri());
            ArrayList result = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toolingService.documentSymbol())).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$documentSymbol$2(this, result, e)));
            return result;
        }, this.executor);
    }

    public CompletableFuture<Either<java.util.List<? extends Location>, java.util.List<? extends LocationLink>>> definition(DefinitionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            ArrayList result = new ArrayList();
            Link[] definitions = toolingService.definitions(offset);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definitions)).foreach((Function1 & Serializable & scala.Serializable)ll -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$2(this, params, result, ll)));
            return Either.forRight(result);
        }, this.executor);
    }

    private Option<String> resolveUrl(NameIdentifier moduleName) {
        WeaveResourceResolver resourceResolver = this.vfs().asResourceResolver();
        Option maybeUrl = resourceResolver.resolve(moduleName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.url());
        return maybeUrl;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            toolingService.formatDocument((WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            Range range = params.getRange();
            int startOffset = toolingService.offsetOf(range.getStart().getLine(), range.getStart().getCharacter());
            int endOffset = toolingService.offsetOf(range.getEnd().getLine(), range.getEnd().getCharacter());
            toolingService.format(startOffset, endOffset, (WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] ref2 = toolingService.rename(offset, params.getNewName());
            WorkspaceEdit edit = new WorkspaceEdit();
            NameIdentifier localNameIdentifier = toolingService.file().getNameIdentifier();
            Map renamesByDocument = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref2)).groupBy((Function1 & Serializable & scala.Serializable)ref -> (NameIdentifier)ref.moduleSource().getOrElse((Function0 & Serializable & scala.Serializable)() -> localNameIdentifier));
            renamesByDocument.foreach((Function1 & Serializable & scala.Serializable)references -> {
                Option<String> option = this.resolveUrl((NameIdentifier)references._1());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String url = (String)some.value();
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])references._2())).map((Function1 & Serializable & scala.Serializable)reference -> {
                        Location location = this.textDocumentTranslator().translate(url, LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
                        ArrayList<TextEdit> changes = (ArrayList<TextEdit>)edit.getChanges().get(location.getUri());
                        if (changes == null) {
                            changes = new ArrayList<TextEdit>();
                        }
                        changes.add(new TextEdit(location.getRange(), params.getNewName()));
                        return edit.getChanges().put(location.getUri(), changes);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.util.List.class)));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            return edit;
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] referencesResult = toolingService.references(offset);
            return JavaConverters$.MODULE$.seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referencesResult)).map((Function1 & Serializable & scala.Serializable)r -> {
                String url = r.isLocalReference() ? params.getTextDocument().getUri() : (String)this.resolveUrl((NameIdentifier)r.moduleSource().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                Range range = LSPConverters$.MODULE$.toRange(r.referencedNode().location());
                return this.textDocumentTranslator().translate(url, range);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
        }, this.executor);
    }

    private CompletionItemKind getCompletionType(Suggestion sug) {
        int n = sug.itemType();
        if (SuggestionType$.MODULE$.Class() == n) {
            return CompletionItemKind.Class;
        }
        if (SuggestionType$.MODULE$.Constructor() == n) {
            return CompletionItemKind.Constructor;
        }
        if (SuggestionType$.MODULE$.Field() == n) {
            return CompletionItemKind.Field;
        }
        if (SuggestionType$.MODULE$.Enum() == n) {
            return CompletionItemKind.Enum;
        }
        if (SuggestionType$.MODULE$.Function() == n) {
            return CompletionItemKind.Function;
        }
        if (SuggestionType$.MODULE$.Keyword() == n) {
            return CompletionItemKind.Keyword;
        }
        if (SuggestionType$.MODULE$.Module() == n) {
            return CompletionItemKind.Module;
        }
        if (SuggestionType$.MODULE$.Method() == n) {
            return CompletionItemKind.Method;
        }
        if (SuggestionType$.MODULE$.Property() == n) {
            return CompletionItemKind.Property;
        }
        if (SuggestionType$.MODULE$.Variable() == n) {
            return CompletionItemKind.Variable;
        }
        return CompletionItemKind.Property;
    }

    public static final /* synthetic */ void $anonfun$getSuggestionsAndCreateCompletionList$1(DataWeaveDocumentService $this, IntRef i$1, SuggestionResult suggestionResult$1, WeaveDocumentToolingService toolingService$1, ArrayList result$1, Suggestion sug) {
        String index = Integer.toString(i$1.elem);
        String prefix = new StringOps(Predef$.MODULE$.augmentString("0")).$times(suggestionResult$1.suggestions().length - index.length());
        CompletionItem item = new CompletionItem(sug.name());
        item.setDetail((String)sug.wtype().map((Function1 & Serializable & scala.Serializable)wt -> {
            boolean x$1 = false;
            boolean x$2 = true;
            boolean x$3 = true;
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
            boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
            boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$8();
            boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
            boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
            boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
            boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
            Seq x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
            boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
            boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
            Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
            WeaveTypeEmitterConfig emitterConfig = new WeaveTypeEmitterConfig(x$1, x$3, x$4, x$2, x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            return wt.toString(emitterConfig);
        }).orNull(Predef$.MODULE$.$conforms()));
        item.setSortText(new StringBuilder(0).append(prefix).append(index).toString());
        item.setDocumentation(new MarkupContent("markdown", (String)sug.markdownDocumentation().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
        int startIndex = suggestionResult$1.replacementStart();
        int endIndex = suggestionResult$1.replacementEnd();
        org.mule.weave.v2.parser.location.Position startPosition = toolingService$1.file().asResource().positionOf(startIndex);
        org.mule.weave.v2.parser.location.Position endPosition = toolingService$1.file().asResource().positionOf(endIndex);
        TextEdit edit = new TextEdit(new Range(LSPConverters$.MODULE$.toPosition(startPosition), LSPConverters$.MODULE$.toPosition(endPosition)), sug.template().toVSCodeString());
        item.setTextEdit(Either.forLeft((Object)edit));
        item.setFilterText(sug.template().toVSCodeString());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind($this.getCompletionType(sug));
        result$1.add(item);
        ++i$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getInputDirectives$3(InputDirective inputDirective) {
        return !NameIdentifier$.MODULE$.INSERTED_FAKE_VARIABLE().equals((Object)inputDirective.variable()) && AstNodeHelper$.MODULE$.notInjectedNode((AstNode)inputDirective);
    }

    public static final /* synthetic */ AstNode $anonfun$codeLens$2(AstNodeResult x$1) {
        return x$1.astNode();
    }

    public static final /* synthetic */ Object $anonfun$codeLens$3(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        result$2.addAll($this.addDocumentationLenses(ast, uri$1));
        if ($this.supportAddUnitTestCodeLens) {
            return BoxesRunTime.boxToBoolean((boolean)result$2.addAll($this.addUnitTestLenses(ast, uri$1)));
        }
        return BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ java.util.List $anonfun$codeLens$1(DataWeaveDocumentService $this, CodeLensParams params$2) {
        block5: {
            block7: {
                block6: {
                    uri = params$2.getTextDocument().getUri();
                    result = new ArrayList<CodeLens>();
                    documentToolingService = $this.toolingServices().openDocument(params$2.getTextDocument().getUri());
                    nameIdentifier = documentToolingService.file().getNameIdentifier();
                    maybeAstNode = documentToolingService.ast().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$2(org.mule.weave.v2.editor.AstNodeResult ), (Lorg/mule/weave/v2/editor/AstNodeResult;)Lorg/mule/weave/v2/parser/ast/AstNode;)());
                    maybeString = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
                    if (documentToolingService.file().readOnly()) break block5;
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = maybeString;
                    if (!(var11_10 instanceof Some)) break block6;
                    var9_8 = true;
                    var10_9 = (Some)var11_10;
                    var12_11 = (String)var10_9.value();
                    v0 = WeaveASTQueryUtils$.MODULE$.MODULE();
                    var13_12 = var12_11;
                    if (v0 != null ? v0.equals(var13_12) == false : var13_12 != null) break block6;
                    BoxesRunTime.boxToBoolean((boolean)result.addAll($this.createMappingTestLens(documentToolingService.file().url())));
                    break block7;
                }
                if (!var9_8) ** GOTO lbl-1000
                var14_13 = (String)var10_9.value();
                v1 = WeaveASTQueryUtils$.MODULE$.MAPPING();
                var15_14 = var14_13;
                if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                    maybeScenario = $this.scenariosService().activeScenario(nameIdentifier);
                    inputDirectives = $this.getInputDirectives((Option<AstNode>)maybeAstNode);
                    result.addAll($this.sampleDataLenses(maybeScenario, nameIdentifier, inputDirectives, uri));
                    if ($this.supportRunMappingLens) {
                        BoxesRunTime.boxToBoolean((boolean)result.add($this.runMappingLens(nameIdentifier)));
                    }
                } else if (var9_8) {
                    var18_17 = (String)var10_9.value();
                    v2 = WeaveASTQueryUtils$.MODULE$.BAT();
                    var19_18 = var18_17;
                    if (!(v2 != null ? v2.equals(var19_18) == false : var19_18 != null)) {
                        command = new Command("Run BAT Test", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(new Object[]{URLUtils$.MODULE$.toLSPUrl(Path.of($this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.BAT_CONFIG_TYPE_NAME(), "false"}));
                        BoxesRunTime.boxToBoolean((boolean)result.add(new CodeLens($this.docStartRange(), command, null)));
                    }
                }
            }
            maybeAstNode.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$3(org.mule.weave.lsp.services.DataWeaveDocumentService java.util.ArrayList java.lang.String org.mule.weave.v2.parser.ast.AstNode ), (Lorg/mule/weave/v2/parser/ast/AstNode;)Ljava/lang/Object;)((DataWeaveDocumentService)$this, result, (String)uri));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$sampleDataLenses$1(DataWeaveDocumentService $this, NameIdentifier nameIdentifier$1, String uri$2, ArrayList lenses$1, InputDirective id) {
        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier$1.name(), Scenario$.MODULE$.PLAYGROUND_SCENARIO(), uri$2, id.variable().name(), $this.inputFileName(id)));
        return lenses$1.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$1(FunctionDirectiveNode fd) {
        return fd.weaveDoc().isEmpty() && !(fd.literal() instanceof OverloadedFunctionNode);
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$2(String uri$3, ArrayList result$3, FunctionDirectiveNode astNode) {
        Command command = InsertDocumentationCommand$.MODULE$.createCommand(uri$3, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$3.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addUnitTestLenses$1(String uri$4, ArrayList result$4, FunctionDirectiveNode astNode) {
        Command command = CreateUnitTest$.MODULE$.createCommand(uri$4, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$4.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$documentSymbol$2(DataWeaveDocumentService $this, ArrayList result$6, SymbolInformation e) {
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setName(e.name());
        symbol.setSelectionRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setKind($this.toSymbolKind(e.kind()));
        return result$6.add(Either.forRight((Object)symbol));
    }

    public static final /* synthetic */ boolean $anonfun$definition$4(Link ll$1, SampleInput sampleInput) {
        return sampleInput.name().equals(ll$1.linkLocation().name());
    }

    public static final /* synthetic */ void $anonfun$definition$5(LocationLink link$1, SampleInput sampleInput) {
        Position position = new Position(0, 0);
        link$1.setTargetRange(new Range(position, position));
        link$1.setTargetSelectionRange(new Range(position, position));
        link$1.setTargetUri(sampleInput.uri());
    }

    public static final /* synthetic */ void $anonfun$definition$3(Link ll$1, LocationLink link$1, Scenario activeScenario) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeScenario.inputs())).find((Function1 & Serializable & scala.Serializable)sampleInput -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$4(ll$1, sampleInput))).foreach((Function1 & Serializable & scala.Serializable)sampleInput -> {
            DataWeaveDocumentService.$anonfun$definition$5(link$1, sampleInput);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$definition$2(DataWeaveDocumentService $this, DefinitionParams params$7, ArrayList result$7, Link ll) {
        LocationLink link = new LocationLink();
        link.setOriginSelectionRange(LSPConverters$.MODULE$.toRange(ll.linkLocation().location()));
        Reference reference = ll.reference();
        link.setTargetRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        link.setTargetSelectionRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        if (reference.isLocalReference()) {
            link.setTargetUri(params$7.getTextDocument().getUri());
            $this.scenariosService().activeScenario($this.vfs().file(params$7.getTextDocument().getUri()).getNameIdentifier()).foreach((Function1 & Serializable & scala.Serializable)activeScenario -> {
                DataWeaveDocumentService.$anonfun$definition$3(ll, link, activeScenario);
                return BoxedUnit.UNIT;
            });
        } else {
            NameIdentifier moduleName = (NameIdentifier)reference.moduleSource().get();
            Option<String> maybeUrl = $this.resolveUrl(moduleName);
            Option<String> option = maybeUrl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String url = (String)some.value();
                link.setTargetUri(url);
            } else if (None$.MODULE$.equals(option)) {
                $this.logger().warn(new StringBuilder(23).append("Resource not found for ").append(moduleName).toString());
            } else {
                throw new MatchError(option);
            }
        }
        return result$7.add(link);
    }

    public DataWeaveDocumentService(ProjectKind projectKind, Executor executor, boolean supportAddUnitTestCodeLens, boolean supportRunMappingLens) {
        this.projectKind = projectKind;
        this.executor = executor;
        this.supportAddUnitTestCodeLens = supportAddUnitTestCodeLens;
        this.supportRunMappingLens = supportRunMappingLens;
        this.logger = LoggerFactory.getLogger(DataWeaveDocumentService.class);
        this.toolingServices = projectKind.toolingService(DataWeaveToolingService.class);
        this.projectFS = projectKind.toolingService(ProjectFileSystemService.class);
        this.scenariosService = projectKind.toolingService(WeaveScenarioManagerService.class);
        this.vfs = projectKind.vfs();
        this.codeActionsManagerService = projectKind.toolingService(CodeActionsManagerService.class);
        this.textDocumentTranslator = projectKind.toolingService(TextDocumentTranslatorService.class);
    }
}

