/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.Debouncer;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnActiveScenarioChanged;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.services.exception.RunPreviewException;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0012%\u0001=B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001da\u0006A1A\u0005\nuCa\u0001\u001a\u0001!\u0002\u0013q\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005u\u0001\u0001\u0007\t\u0011)Q\u0005O\"IQ\u000f\u0001a\u0001\u0002\u0004%IA\u001e\u0005\n{\u0002\u0001\r\u00111A\u0005\nyD!\"!\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003x\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!A\u00111\u0003\u0001!B\u0013\t9\u0001C\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 !I\u0011q\u0007\u0001A\u0002\u0013%\u0011\u0011\b\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002\"!I\u0011q\b\u0001A\u0002\u0013%\u0011q\u0004\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007B\u0001\"a\u0012\u0001A\u0003&\u0011\u0011\u0005\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017B\u0001\"a\u001a\u0001A\u0003%\u0011Q\n\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u0000\u0001!I!!\"\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u00111\u0016\u0001\u0005\n\u0005M\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0001\u0003\u0017Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002f\u0002!\t!a9\u0003\u001dA\u0013XM^5foN+'O^5dK*\u0011QEJ\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0005K\u0001\u0004YN\u0004(BA\u0015+\u0003\u00159X-\u0019<f\u0015\tYC&\u0001\u0003nk2,'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003oaj\u0011\u0001J\u0005\u0003s\u0011\u0012a\u0002V8pY&twmU3sm&\u001cW-\u0001\u0007bO\u0016tGoU3sm&\u001cW\r\u0005\u0002=\u007f5\tQH\u0003\u0002?M\u0005)\u0011mZ3oi&\u0011\u0001)\u0010\u0002\u0012/\u0016\fg/Z!hK:$8+\u001a:wS\u000e,\u0017aE<fCZ,G*\u00198hk\u0006<Wm\u00117jK:$\bCA\"I\u001b\u0005!%BA#G\u0003!\u0001(o\u001c;pG>d'BA$'\u0003%)\u0007\u0010^3og&|g.\u0003\u0002J\t\n9B)\u0019;b/\u0016\fg/\u001a)s_R|7m\u001c7DY&,g\u000e^\u0001\u0010i>|G.\u001b8h'\u0016\u0014h/[2fgB\u0011q\u0007T\u0005\u0003\u001b\u0012\u0012q\u0003R1uC^+\u0017M^3U_>d\u0017N\\4TKJ4\u0018nY3\u0002\u0015)|'-T1oC\u001e,'\u000f\u0005\u0002Q'6\t\u0011K\u0003\u0002SM\u0005!!n\u001c2t\u0013\t!\u0016KA\tK_\nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD#B,Y3j[\u0006CA\u001c\u0001\u0011\u0015QT\u00011\u0001<\u0011\u0015\tU\u00011\u0001C\u0011\u0015QU\u00011\u0001L\u0011\u0015qU\u00011\u0001P\u0003\u0019awnZ4feV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002bY\u0005)1\u000f\u001c45U&\u00111\r\u0019\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005AQM^3oi\n+8/F\u0001h!\tA7.D\u0001j\u0015\tQg%A\u0003vi&d7/\u0003\u0002mS\n\u0001\u0012J\u001c;fe:\fG.\u0012<f]R\u0014Uo]\u0001\rKZ,g\u000e\u001e\"vg~#S-\u001d\u000b\u0003_J\u0004\"!\r9\n\u0005E\u0014$\u0001B+oSRDqa]\u0005\u0002\u0002\u0003\u0007q-A\u0002yIE\n\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\u0017A\u0014xN[3di.Kg\u000eZ\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\u0011!PJ\u0001\baJ|'.Z2u\u0013\ta\u0018PA\u0006Qe>TWm\u0019;LS:$\u0017a\u00049s_*,7\r^&j]\u0012|F%Z9\u0015\u0005=|\bbB:\r\u0003\u0003\u0005\ra^\u0001\raJ|'.Z2u\u0017&tG\rI\u0001\fK:\f'\r\\3WC2,X-\u0006\u0002\u0002\bA\u0019\u0011'!\u0003\n\u0007\u0005-!GA\u0004C_>dW-\u00198\u0002\u001f\u0015t\u0017M\u00197f-\u0006dW/Z0%KF$2a\\A\t\u0011!\u0019x\"!AA\u0002\u0005\u001d\u0011\u0001D3oC\ndWMV1mk\u0016\u0004\u0003f\u0001\t\u0002\u0018A\u0019\u0011'!\u0007\n\u0007\u0005m!G\u0001\u0005w_2\fG/\u001b7f\u0003M\u0001XM\u001c3j]\u001e\u0004&o\u001c6fGR\u001cF/\u0019:u+\t\t\t\u0003E\u00032\u0003G\t9#C\u0002\u0002&I\u0012aa\u00149uS>t\u0007\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0007K\u0012LGo\u001c:\u000b\u0007\u0005E\u0002&\u0001\u0002we%!\u0011QGA\u0016\u0005-1\u0016N\u001d;vC24\u0015\u000e\\3\u0002/A,g\u000eZ5oOB\u0013xN[3diN#\u0018M\u001d;`I\u0015\fHcA8\u0002<!A1OEA\u0001\u0002\u0004\t\t#\u0001\u000bqK:$\u0017N\\4Qe>TWm\u0019;Ti\u0006\u0014H\u000fI\u0001\u0011GV\u0014(/\u001a8u-\u001a\u0004&/\u001a<jK^\fAcY;se\u0016tGO\u00164Qe\u00164\u0018.Z<`I\u0015\fHcA8\u0002F!A1/FA\u0001\u0002\u0004\t\t#A\tdkJ\u0014XM\u001c;WMB\u0013XM^5fo\u0002\n\u0001\u0003\u001d:fm&,w\u000fR3c_Vt7-\u001a:\u0016\u0005\u00055\u0003#B\u001c\u0002P\u0005M\u0013bAA)I\tIA)\u001a2pk:\u001cWM\u001d\t\u0005\u0003+\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%1\u0018M]5bE2,7O\u0003\u0003\u0002^\u0005}\u0013aA1ti*!\u0011\u0011MA\u0018\u0003\u0019\u0001\u0018M]:fe&!\u0011QMA,\u00059q\u0015-\\3JI\u0016tG/\u001b4jKJ\f\u0011\u0003\u001d:fm&,w\u000fR3c_Vt7-\u001a:!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0006_\u00065\u0014q\u000e\u0005\u0006kf\u0001\ra\u001e\u0005\u0006Kf\u0001\raZ\u0001\u000beVt\u0007K]3wS\u0016<H\u0003BA;\u0003w\u00022aQA<\u0013\r\tI\b\u0012\u0002\u000e!J,g/[3x%\u0016\u001cX\u000f\u001c;\t\u000f\u0005u$\u00041\u0001\u0002(\u0005\u0011aOZ\u0001\u000eG\u0006t'+\u001e8Qe\u00164\u0018.Z<\u0015\t\u0005\u001d\u00111\u0011\u0005\b\u0003{Z\u0002\u0019AA\u0014)\u0019\t9!a\"\u0002\n\"9\u0011Q\u0010\u000fA\u0002\u0005\u001d\u0002bBAF9\u0001\u0007\u0011QR\u0001\u0011M&dWmS5oIJ+7o\u001c7wKJ\u0004R!MAH\u0003'K1!!%3\u0005%1UO\\2uS>t\u0007\u0007E\u00032\u0003G\t)\n\u0005\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003C\u00032!a'3\u001b\t\tiJC\u0002\u0002 :\na\u0001\u0010:p_Rt\u0014bAARe\u00051\u0001K]3eK\u001aLA!a*\u0002*\n11\u000b\u001e:j]\u001eT1!a)3\u0003!1\u0017\u000e\\3LS:$G\u0003BAJ\u0003_Cq!!-\u001e\u0001\u0004\t)*A\u0004gS2,WK\u001d7\u0015\t\u0005M\u0015Q\u0017\u0005\b\u0003os\u0002\u0019AA]\u0003Y!wnY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007\u0003BA\u0015\u0003wKA!!0\u0002,\tYr+Z1wK\u0012{7-^7f]R$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\f!c]2iK\u0012,H.\u001a*v]B\u0013XM^5foR1\u0011QOAb\u0003\u000bDq!!  \u0001\u0004\t9\u0003C\u0005\u0002H~\u0001\n\u00111\u0001\u0002\b\u0005!1/\u001f8d\u0003q\u00198\r[3ek2,'+\u001e8Qe\u00164\u0018.Z<%I\u00164\u0017-\u001e7uII*\"!!4+\t\u0005\u001d\u0011qZ\u0016\u0003\u0003#\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001c\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0006U'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061QM\\1cY\u0016$\u0012a\\\u0001\bI&\u001c\u0018M\u00197f\u0001")
public class PreviewService
implements ToolingService {
    private final WeaveAgentService agentService;
    private final DataWeaveProtocolClient weaveLanguageClient;
    private final DataWeaveToolingService toolingServices;
    private final JobManagerService jobManager;
    private final Logger logger;
    private InternalEventBus eventBus;
    private ProjectKind projectKind;
    private volatile boolean org$mule$weave$lsp$services$PreviewService$$enableValue;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    private final Debouncer<NameIdentifier> previewDebouncer;

    private Logger logger() {
        return this.logger;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public boolean org$mule$weave$lsp$services$PreviewService$$enableValue() {
        return this.org$mule$weave$lsp$services$PreviewService$$enableValue;
    }

    private void org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(boolean x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart() {
        return this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    }

    public void org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview() {
        return this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    }

    private void org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = x$1;
    }

    private Debouncer<NameIdentifier> previewDebouncer() {
        return this.previewDebouncer;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this, projectKind){
            private final /* synthetic */ PreviewService $outer;
            private final ProjectKind projectKind$1;

            public void onFileChanged(String uri, FileChangeType changeType) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue()) {
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().map((Function1 & Serializable & scala.Serializable)currentVFPreview -> $this.projectKind$1.sampleDataManager().searchSampleDataFolderFor(currentVFPreview.getNameIdentifier()).map((Function1 & Serializable & scala.Serializable)scenarioFolder -> {
                        if (URLUtils$.MODULE$.isChildOf(uri, (File)scenarioFolder) || URLUtils$.MODULE$.isChildOf(URLUtils$.MODULE$.toLSPUrl(scenarioFolder.getPath()), uri)) {
                            return $this.$outer.scheduleRunPreview((VirtualFile)currentVFPreview, $this.$outer.scheduleRunPreview$default$2());
                        }
                        return BoxedUnit.UNIT;
                    }));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile ), $anonfun$onFileChanged$2(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ PreviewService $outer;

            public void onProjectStarted(ProjectMetadata metadata) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().isDefined()) {
                    this.$outer.scheduleRunPreview((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().get(), this.$outer.scheduleRunPreview$default$2());
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)None$.MODULE$);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ActiveScenarioChangedEvent$.MODULE$.ACTIVE_SCENARIO_CHANGED(), new OnActiveScenarioChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onActiveScenarioChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().isDefined() && ((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().get()).url().equals(vf.url()) && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public PreviewResult runPreview(VirtualFile vf) {
        String fileUrl = vf.url();
        if (!this.projectKind().isStarted()) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = "Project is not yet initialized.\nPreview is going to be executed once project initializes.";
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            return new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
        }
        NameIdentifier identifier = vf.getNameIdentifier();
        String content = vf.read();
        this.logger().debug(new StringBuilder(27).append("Trigger run preview for `").append(identifier).append("`.").toString());
        return this.agentService.run(identifier, content, fileUrl);
    }

    public boolean canRunPreview(VirtualFile vf) {
        return URLUtils$.MODULE$.isDWFile(vf.url()) && this.canRunPreview(vf, (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(vf.url()));
    }

    private boolean canRunPreview(VirtualFile vf, Function0<Option<String>> fileKindResolver) {
        if (vf == null) {
            return false;
        }
        Option<URI> fileUrl = URLUtils$.MODULE$.toURI(vf.url());
        if (fileUrl.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$canRunPreview$2(p)))) {
            return false;
        }
        Option mayBeKind = (Option)fileKindResolver.apply();
        boolean isMapping = mayBeKind.forall((Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)kind.equals(WeaveASTQueryUtils$.MODULE$.MAPPING())));
        return !vf.readOnly() && isMapping;
    }

    private Option<String> fileKind(String fileUrl) {
        return this.fileKind(this.toolingServices.openDocument(fileUrl));
    }

    private Option<String> fileKind(WeaveDocumentToolingService documentToolingService) {
        Option maybeAstNode = documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.astNode());
        Option<String> mayBeKind = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
        return mayBeKind;
    }

    public PreviewResult scheduleRunPreview(VirtualFile vf, boolean sync) {
        String fileUrl = vf.url();
        if (!this.canRunPreview(vf)) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = new StringBuilder(42).append("File `").append(vf.getNameIdentifier().name()).append("` is not an executable mapping file.").toString();
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            PreviewResult previewResult = new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
            if (sync) {
                return previewResult;
            }
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else if (!this.projectKind().isStarted()) {
            if (sync) {
                throw new RunPreviewException("Project is not yet initialized, preview cannot be executed at this time.");
            }
            this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)new Some((Object)vf));
            PreviewResult previewResult = this.runPreview(vf);
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else {
            if (sync) {
                return this.runPreview(vf);
            }
            NameIdentifier identifier = vf.getNameIdentifier();
            this.previewDebouncer().debounce(identifier, () -> $this.jobManager.execute(x$2 -> $this.weaveLanguageClient.showPreviewResult(this.runPreview(vf)), "Running preview", new StringBuilder(19).append("Running preview of ").append(identifier).toString()), 300L, TimeUnit.MILLISECONDS);
        }
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)new Some((Object)vf));
        return null;
    }

    public boolean scheduleRunPreview$default$2() {
        return false;
    }

    public void enable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(true);
    }

    public void disable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(false);
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$canRunPreview$2(URI p) {
        String string = p.getScheme();
        String string2 = "preview";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PreviewService(WeaveAgentService agentService, DataWeaveProtocolClient weaveLanguageClient, DataWeaveToolingService toolingServices, JobManagerService jobManager) {
        this.agentService = agentService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.toolingServices = toolingServices;
        this.jobManager = jobManager;
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = false;
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = None$.MODULE$;
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = None$.MODULE$;
        this.previewDebouncer = new Debouncer();
    }
}

