package org.mule.weave.lsp.commands

import com.google.gson.JsonNull
import com.google.gson.JsonPrimitive

import java.util

/**
  * List of Supported Commands
  */
object Commands {

  val COMMAND_ENABLED_SUFFIX = ".enabled"

  val BAT_RUN_BAT_TEST = "bat.runCurrentBatTest"
  val BAT_RUN_BAT_FOLDER = "bat.runFolder"
  val BAT_INSTALL_BAT_CLI = "bat.installCli"

  // Used outside commandProvider
  val DW_LAUNCH_MAPPING = "dw.launchCommand"
  val DW_RUN_PREVIEW = "dw.runPreview"
  val DW_QUICK_FIX = "dw.quickFix"
  val DW_CREATE_PROJECT = "dw.createProject"
  val DW_GENERATE_WEAVE_DOC = "dw.generateWeaveDoc"
  val DW_INSERT_WEAVE_TYPE = "dw.insertWeaveType"
  val DW_CREATE_SCENARIO = "dw.createScenario"
  val DW_CREATE_INPUT_SAMPLE = "dw.createInputSample"
  val DW_EXTRACT_VARIABLE = "dw.extractVariable"
  val DW_EXTRACT_CONSTANT = "dw.extractConstant"
  val DW_EXTRACT_FUNCTION = "dw.extractFunction"
  val DW_CREATE_UNIT_TEST = "dw.createUnitTest"
  val DW_CREATE_TEST_MAPPING = "dw.createTestMapping"

  // Used only through CommandProvider
  val DW_LAUNCH_TEST = "dw.launchTest"
  val DW_ENABLE_PREVIEW = "dw.enablePreview"
  val DW_RELOAD_DEPENDENCIES = "dw.reloadDependencies"
  val DW_RUN_MAPPING = "dw.runCommand"
  val DW_DELETE_INPUT_SAMPLE = "dw.deleteInputSample"
  val DW_DELETE_EXPECTED_OUTPUT = "dw.deleteExpectedOutput"
  val DW_CREATE_MAPPING_TEST = "dw.createMappingTest"
  val DW_ACTIVE_SCENARIO = "dw.activeScenario"
  val DW_DELETE_SCENARIO = "dw.deleteScenario"
  val DW_CREATE_TEST = "dw.createTest"
  val DW_CREATE_MAPPING = "dw.createMapping"
  val DW_CREATE_MODULE = "dw.createModule"

  def optionalArgAsString(arguments: util.List[AnyRef], index: Int): Option[String] = {
    if (arguments.size() <= index) {
      None
    } else {
      val value = arguments.get(index)
      value match {
        case _: JsonNull => None
        case jp: JsonPrimitive => Some(jp.getAsString)
        case stringValue: String => Some(stringValue)
        case d => throw new RuntimeException(s"Expecting `String` but got ${d.getClass.getName}")
      }
    }
  }


  def argAsString(arguments: util.List[AnyRef], index: Int) = {
    if (arguments.size() <= index) {
      throw new RuntimeException(s"Missing argument ${index}.")
    }
    val value = arguments.get(index)
    value match {
      case _: JsonNull => null
      case jp: JsonPrimitive => jp.getAsString
      case stringValue: String => stringValue
      case d => throw new RuntimeException(s"Expecting `String` but got ${d.getClass.getName}")
    }

  }

  def argAsInt(arguments: util.List[AnyRef], index: Int): Int = {
    val value = arguments.get(index)
    value match {
      case jp: JsonPrimitive => jp.getAsInt
      case intValue: Integer => intValue
      case d => throw new RuntimeException(s"Expecting `Int` but got ${d.getClass.getName}")
    }
  }

  def argAsBoolean(arguments: util.List[AnyRef], index: Int): Boolean = {
    val value = arguments.get(index)
    value match {
      case jp: JsonPrimitive => jp.getAsBoolean
      case stringValue: String => stringValue.toBoolean
      case booleanValue: java.lang.Boolean => booleanValue
      case d => throw new RuntimeException(s"Expecting `Boolean` but got ${d.getClass.getName}")
    }
  }

  def argAsBooleanOrDefault(arguments: util.List[AnyRef], index: Int, defaultValue: Boolean): Boolean = {
    if (index >= arguments.size() || index < 0) {
      defaultValue
    } else {
      argAsBoolean(arguments, index)
    }
  }

}
