package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent.VIRTUAL_FILE_DELETED
import org.mule.weave.v2.editor.VirtualFile

class ProjectVirtualFileDeletedEvent(vf: VirtualFile) extends InternalEvent {

  override type T = OnProjectVirtualFileDeletedEvent
  
  override def getType: InternalEventType[OnProjectVirtualFileDeletedEvent] = VIRTUAL_FILE_DELETED

  override def dispatch(handler: OnProjectVirtualFileDeletedEvent): Unit = {
    handler.onVirtualFileDeleted(vf)
  }
}


object ProjectVirtualFileDeletedEvent {
  val VIRTUAL_FILE_DELETED: InternalEventType[OnProjectVirtualFileDeletedEvent] = InternalEventType[OnProjectVirtualFileDeletedEvent]("VIRTUAL_FILE_DELETED")
}

trait OnProjectVirtualFileDeletedEvent extends InternalEventHandler {
  def onVirtualFileDeleted(vf: VirtualFile)
}