/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.dx.platform.api.protocol.ClientAware;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.lsp.IDEExecutors$;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.extension.client.LanguageClientDelegate;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolService;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.ProjectKindContext;
import org.mule.weave.lsp.project.ProjectKindFactory;
import org.mule.weave.lsp.project.ProjectSettings;
import org.mule.weave.lsp.project.ProjectSettings$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveDocumentService;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher$;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor$;
import org.mule.weave.lsp.services.DiagnosticsPublisher;
import org.mule.weave.lsp.services.WorkspaceEditApplier;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.services.delegate.TextDocumentServiceDelegate;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0015+\u0001MB\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011\u0015!\b\u0001\"\u0001v\u0011\u001da\bA1A\u0005\nuDq!!\u0003\u0001A\u0003%a\u0010C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u00111\u0004\u0001!\u0002\u0013\ty\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002 !A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0003\u0003\u0006\u0002*\u0001A)\u0019!C\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003oA\u0011\"!\u001b\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005e\u0004\u0001)A\u0005\u0003[B1\"a\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002~!Y\u0011Q\u0011\u0001A\u0002\u0003\u0007I\u0011BAD\u0011-\t)\n\u0001a\u0001\u0002\u0003\u0006K!a \t\u0017\u0005]\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0014\u0005\f\u0003C\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\u000bC\u0006\u0002(\u0002\u0001\r\u0011!Q!\n\u0005m\u0005\"CAU\u0001\t\u0007I\u0011BAV\u0011!\t\u0019\f\u0001Q\u0001\n\u00055\u0006\"CA[\u0001\t\u0007I\u0011BA\\\u0011!\ti\f\u0001Q\u0001\n\u0005e\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!a@\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u001b\u0001\u0011\u0005#q\u0007\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0003\\\u0001!\tE!\u0018\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j!9!1\u000e\u0001\u0005\n\t5$aE,fCZ,G*\u00198hk\u0006<WmU3sm\u0016\u0014(BA\u0016-\u0003\ra7\u000f\u001d\u0006\u0003[9\nQa^3bm\u0016T!a\f\u0019\u0002\t5,H.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000e\u001fG+B\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000f\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006A1/\u001a:wS\u000e,7O\u0003\u0002B\u0005\u0006)An\u001d95U*\u00111\tM\u0001\bK\u000ed\u0017\u000e]:f\u0013\t)eH\u0001\bMC:<W/Y4f'\u0016\u0014h/\u001a:\u0011\u0007\u001d\u0003&+D\u0001I\u0015\tI%*\u0001\u0005qe>$xnY8m\u0015\tYE*A\u0002ba&T!!\u0014(\u0002\u0011Ad\u0017\r\u001e4pe6T!a\u0014\u0018\u0002\u0005\u0011D\u0018BA)I\u0005-\u0019E.[3oi\u0006;\u0018M]3\u0011\u0005u\u001a\u0016B\u0001+?\u00059a\u0015M\\4vC\u001e,7\t\\5f]R\u0004\"A\u0016-\u000e\u0003]S!a\u0010\u0016\n\u0005e;&\u0001G,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0019&\u001cH/\u001a8fe\u0006\u0011\u0002O]8kK\u000e$8*\u001b8e\r\u0006\u001cGo\u001c:z!\tav,D\u0001^\u0015\tq&&A\u0004qe>TWm\u0019;\n\u0005\u0001l&A\u0005)s_*,7\r^&j]\u00124\u0015m\u0019;pef\fq\u0002\u001d:pi>\u001cw\u000e\\*feZL7-\u001a\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003\u0013\u0016T!A\u001a\u0016\u0002\u0013\u0015DH/\u001a8tS>t\u0017B\u00015e\u0005a!\u0015\r^1XK\u00064X\r\u0015:pi>\u001cw\u000e\\*feZL7-Z\u0001\u0018o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\u0004\"AV6\n\u00051<&aF,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0003EQwNY'b]\u0006<WM]*feZL7-\u001a\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c*\nAA[8cg&\u00111\u000f\u001d\u0002\u0012\u0015>\u0014W*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003wqfT8\u0010\u0005\u0002x\u00015\t!\u0006C\u0003[\u000b\u0001\u00071\fC\u0003b\u000b\u0001\u0007!\rC\u0003j\u000b\u0001\u0007!\u000eC\u0003n\u000b\u0001\u0007a.\u0001\u0004m_\u001e<WM]\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002a\u0005)1\u000f\u001c45U&!\u0011qAA\u0001\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013a\u0005;fqR$unY;nK:$8+\u001a:wS\u000e,WCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b/\u0006AA-\u001a7fO\u0006$X-\u0003\u0003\u0002\u001a\u0005M!a\u0007+fqR$unY;nK:$8+\u001a:wS\u000e,G)\u001a7fO\u0006$X-\u0001\u000buKb$Hi\\2v[\u0016tGoU3sm&\u001cW\rI\u0001\u0018i\u0016DH\u000fR8dk6,g\u000e^*feZL7-Z%na2,\"!!\t\u0011\u0007Y\u000b\u0019#C\u0002\u0002&]\u0013!\u0005R1uC^+\u0017M^3E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018\u0001\u0007;fqR$unY;nK:$8+\u001a:wS\u000e,\u0017*\u001c9mA\u0005iB.\u00198hk\u0006<WmU3sm\u0016\u0014Hi\\2v[\u0016tGoU3sm&\u001cW-\u0006\u0002\u0002.A\u0019a+a\f\n\u0007\u0005ErK\u0001\rECR\fw+Z1wK\u0012{7-^7f]R\u001cVM\u001d<jG\u0016\f\u0001\u0005\u001d:pU\u0016\u001cGoS5oIN\u0014\u0015pV8sWN\u0004\u0018mY3G_2$WM]+sSV\u0011\u0011q\u0007\t\t\u0003s\t9%a\u0013\u0002b5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0011\u0002D\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005\u0005\u0015\u0013!B:dC2\f\u0017\u0002BA%\u0003w\u0011q\u0001\u0016:jK6\u000b\u0007\u000f\u0005\u0003\u0002N\u0005mc\u0002BA(\u0003/\u0002B!!\u0015\u0002D5\u0011\u00111\u000b\u0006\u0004\u0003+\u0012\u0014A\u0002\u001fs_>$h(\u0003\u0003\u0002Z\u0005\r\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002^\u0005}#AB*ue&twM\u0003\u0003\u0002Z\u0005\r\u0003c\u0001/\u0002d%\u0019\u0011QM/\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\"aJ|'.Z2u\u0017&tGm\u001d\"z/>\u00148n\u001d9bG\u00164u\u000e\u001c3feV\u0013\u0018\u000eI\u0001\u000fY\u0006tw-^1hK\u000ec\u0017.\u001a8u+\t\ti\u0007\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019(Z\u0001\u0007G2LWM\u001c;\n\t\u0005]\u0014\u0011\u000f\u0002\u0017\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\t\u0016dWmZ1uK\u0006yA.\u00198hk\u0006<Wm\u00117jK:$\b%A\ndY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180\u0006\u0002\u0002\u0000A\u0019a+!!\n\u0007\u0005\ruKA\nDY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180A\fdY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u0018p\u0018\u0013fcR!\u0011\u0011RAI!\u0011\tY)!$\u000e\u0005\u0005\r\u0013\u0002BAH\u0003\u0007\u0012A!\u00168ji\"I\u00111\u0013\n\u0002\u0002\u0003\u0007\u0011qP\u0001\u0004q\u0012\n\u0014\u0001F2mS\u0016tG\u000fT8hO\u0016\u0014h)Y2u_JL\b%\u0001\u0007dY&,g\u000e\u001e'pO\u001e,'/\u0006\u0002\u0002\u001cB\u0019a+!(\n\u0007\u0005}uK\u0001\u0007DY&,g\u000e\u001e'pO\u001e,'/\u0001\tdY&,g\u000e\u001e'pO\u001e,'o\u0018\u0013fcR!\u0011\u0011RAS\u0011%\t\u0019*FA\u0001\u0002\u0004\tY*A\u0007dY&,g\u000e\u001e'pO\u001e,'\u000fI\u0001\u0012o>\u00148n\u001d9bG\u0016\u001cV\r\u001e;j]\u001e\u001cXCAAW!\ra\u0016qV\u0005\u0004\u0003ck&a\u0004)s_*,7\r^*fiRLgnZ:\u0002%]|'o[:qC\u000e,7+\u001a;uS:<7\u000fI\u0001\u0003\u0013\u0012+\"!!/\u0011\u0007U\nY,C\u0002\u0002^Y\n1!\u0013#!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0005\u0003\u0007\fI\u000e\u0005\u0004\u0002F\u00065\u0017\u0011[\u0007\u0003\u0003\u000fTA!!\u0010\u0002J*\u0019\u00111\u001a\u001d\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001f\f9MA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!a5\u0002V6\t\u0001)C\u0002\u0002X\u0002\u0013\u0001#\u00138ji&\fG.\u001b>f%\u0016\u001cX\u000f\u001c;\t\u000f\u0005m7\u00041\u0001\u0002^\u00061\u0001/\u0019:b[N\u0004B!a5\u0002`&\u0019\u0011\u0011\u001d!\u0003!%s\u0017\u000e^5bY&TX\rU1sC6\u001c\u0018!E2sK\u0006$X\r\u0015:pU\u0016\u001cGoS5oIR1\u0011\u0011MAt\u0003cDq!!;\u001d\u0001\u0004\tY/A\bqe>TWm\u0019;NKR\fG-\u0019;b!\ra\u0016Q^\u0005\u0004\u0003_l&A\u0006#fM\u0006,H\u000e\u001e)s_*,7\r^'fi\u0006$\u0017\r^1\t\u000f\u0005mD\u00041\u0001\u0002\u0000\u0005Y\u0011N\\5uS\u0006d\u0017N_3e)\u0011\tI)a>\t\u000f\u0005mW\u00041\u0001\u0002zB!\u00111[A~\u0013\r\ti\u0010\u0011\u0002\u0012\u0013:LG/[1mSj,G\rU1sC6\u001c\u0018AF5oSRL\u0017\r\\5{K\u0012\u0004&o\u001c6fGR\\\u0015N\u001c3\u0015\t\u0005%%1\u0001\u0005\b\u0005\u000bq\u0002\u0019AA1\u0003-\u0001(o\u001c6fGR\\\u0015N\u001c3\u0002\u0011MDW\u000f\u001e3po:$\"Aa\u0003\u0011\r\u0005\u0015\u0017Q\u001aB\u0007!\u0011\tYIa\u0004\n\t\tE\u00111\t\u0002\u0007\u0003:L(+\u001a4\u0002\t\u0015D\u0018\u000e\u001e\u000b\u0003\u0003\u0013\u000bacZ3u)\u0016DH\u000fR8dk6,g\u000e^*feZL7-\u001a\u000b\u0003\u00057\u0001BA!\b\u0003\"5\u0011!q\u0004\u0006\u0003\u007f\u0015LAAa\t\u0003 \tAr+Z1wKR+\u0007\u0010\u001e#pGVlWM\u001c;TKJ4\u0018nY3)\u0007\u0005\u00129\u0003\u0005\u0003\u0003*\tERB\u0001B\u0016\u0015\ry$Q\u0006\u0006\u0004\u0005_\u0001\u0015a\u00026t_:\u0014\boY\u0005\u0005\u0005g\u0011YC\u0001\u0007Kg>tG)\u001a7fO\u0006$X-A\nhKR<vN]6ta\u0006\u001cWmU3sm&\u001cW\r\u0006\u0002\u0003:A\u0019QHa\u000f\n\u0007\tubH\u0001\tX_J\\7\u000f]1dKN+'O^5dK\u000691m\u001c8oK\u000e$H\u0003BAE\u0005\u0007Ba!a\u001d$\u0001\u0004\u0011\u0016\u0001C3yK\u000e,Ho\u001c:\u0015\u0005\t%\u0003\u0003BAc\u0005\u0017JAA!\u0014\u0002H\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\feS\u0012\u001c\u0005.\u00198hK\u000e{gNZ5hkJ\fG/[8o)\u0011\tIIa\u0015\t\u000f\u0005mW\u00051\u0001\u0003VA!\u00111\u001bB,\u0013\r\u0011I\u0006\u0011\u0002\u001d\t&$7\t[1oO\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u000b'/Y7t\u0003e!\u0017\u000eZ\"iC:<WmV8sWN\u0004\u0018mY3G_2$WM]:\u0015\t\u0005%%q\f\u0005\b\u000374\u0003\u0019\u0001B1!\u0011\t\u0019Na\u0019\n\u0007\t\u0015\u0004IA\u0010ES\u0012\u001c\u0005.\u00198hK^{'o[:qC\u000e,gi\u001c7eKJ\u001c\b+\u0019:b[N\f1e\u0019:fCR,G*\u00198hk\u0006<WmU3sm\u0016\u0014Hi\\2v[\u0016tGoU3sm&\u001cW\r\u0006\u0002\u0002.\u0005qB-[:d_Z,'/\u00118e%\u0016<\u0017n\u001d;feB\u0013xN[3di.Kg\u000e\u001a\u000b\u0005\u0003C\u0012y\u0007C\u0004\u0003r!\u0002\rAa\u001d\u0002)\u0005$G-\u001a3X_J\\7\u000f]1dK\u001a{G\u000eZ3s!\u0011\t\u0019N!\u001e\n\u0007\t]\u0004IA\bX_J\\7\u000f]1dK\u001a{G\u000eZ3s\u0001")
public class WeaveLanguageServer
implements LanguageServer,
ClientAware<LanguageClient>,
WorkspaceServiceListener {
    private DataWeaveDocumentService languageServerDocumentService;
    private final ProjectKindFactory projectKindFactory;
    private final DataWeaveProtocolService protocolService;
    private final WorkspaceServiceManager workspaceServiceManager;
    private final JobManagerService jobManagerService;
    private final Logger logger;
    private final TextDocumentServiceDelegate textDocumentService;
    private final DataWeaveDocumentServiceDispatcher textDocumentServiceImpl;
    private final TrieMap<String, ProjectKind> projectKindsByWorkspaceFolderUri;
    private final LanguageClientDelegate languageClient;
    private ClientLoggerFactory clientLoggerFactory;
    private ClientLogger clientLogger;
    private final ProjectSettings workspaceSettings;
    private final String ID;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private TextDocumentServiceDelegate textDocumentService() {
        return this.textDocumentService;
    }

    private DataWeaveDocumentServiceDispatcher textDocumentServiceImpl() {
        return this.textDocumentServiceImpl;
    }

    private DataWeaveDocumentService languageServerDocumentService$lzycompute() {
        WeaveLanguageServer weaveLanguageServer = this;
        synchronized (weaveLanguageServer) {
            if (!this.bitmap$0) {
                this.languageServerDocumentService = this.createLanguageServerDocumentService();
                this.bitmap$0 = true;
            }
        }
        return this.languageServerDocumentService;
    }

    private DataWeaveDocumentService languageServerDocumentService() {
        if (!this.bitmap$0) {
            return this.languageServerDocumentService$lzycompute();
        }
        return this.languageServerDocumentService;
    }

    private TrieMap<String, ProjectKind> projectKindsByWorkspaceFolderUri() {
        return this.projectKindsByWorkspaceFolderUri;
    }

    private LanguageClientDelegate languageClient() {
        return this.languageClient;
    }

    private ClientLoggerFactory clientLoggerFactory() {
        return this.clientLoggerFactory;
    }

    private void clientLoggerFactory_$eq(ClientLoggerFactory x$1) {
        this.clientLoggerFactory = x$1;
    }

    private ClientLogger clientLogger() {
        return this.clientLogger;
    }

    private void clientLogger_$eq(ClientLogger x$1) {
        this.clientLogger = x$1;
    }

    private ProjectSettings workspaceSettings() {
        return this.workspaceSettings;
    }

    private String ID() {
        return this.ID;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logger().debug(new StringBuilder(11).append("Initialize ").append(this.ID()).toString());
        return CompletableFuture.supplyAsync(() -> {
            this.logger().debug(new StringBuilder(13).append("Initializing ").append(this.ID()).toString());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown().get()));
            this.clientLoggerFactory_$eq(new ClientLoggerFactory(this.languageClient()));
            this.clientLogger_$eq(this.clientLoggerFactory().createLogger(WeaveLanguageServer.class, this.ID()));
            $this.workspaceServiceManager.addWorkspaceServiceListeners(this);
            this.workspaceSettings().load(params.getInitializationOptions());
            if (params.getWorkspaceFolders() != null) {
                params.getWorkspaceFolders().forEach(workspaceFolder -> this.discoverAndRegisterProjectKind((WorkspaceFolder)workspaceFolder));
            }
            this.textDocumentService().delegate_$eq(this.textDocumentServiceImpl());
            $this.workspaceServiceManager.diagnosticsPublisherService().setDefaultPublisher(new DiagnosticsPublisher(this.languageClient(), (Option<String>)Option$.MODULE$.empty()));
            $this.workspaceServiceManager.workspaceEditService().setDefaultApplier(new WorkspaceEditApplier(this.languageClient(), (Option<String>)Option$.MODULE$.empty()));
            CommandManagerService commandManagerService = $this.workspaceServiceManager.commandManagerService();
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
            capabilities.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(true), Arrays.asList((Object[])new String[]{"."})));
            capabilities.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setFoldingRangeProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeActionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeLensProvider(new CodeLensOptions(Predef$.MODULE$.boolean2Boolean(true)));
            capabilities.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentRangeFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList((Object[])new String[]{"("}), Arrays.asList((Object[])new String[]{","})));
            List<Object> list = Arrays.asList((Object[])commandManagerService.commandIds());
            capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(list));
            WorkspaceFoldersOptions workspaceFoldersOptions = new WorkspaceFoldersOptions();
            workspaceFoldersOptions.setSupported(Predef$.MODULE$.boolean2Boolean(true));
            workspaceFoldersOptions.setChangeNotifications(Predef$.MODULE$.boolean2Boolean(true));
            WorkspaceServerCapabilities workspaceServerCapabilities = new WorkspaceServerCapabilities(workspaceFoldersOptions);
            capabilities.setWorkspace(workspaceServerCapabilities);
            ServerInfo serverInfo = new ServerInfo("DataWeave", this.workspaceSettings().languageLevelVersion().value());
            this.logger().debug(new StringBuilder(46).append("Initialize: Finished. Server: ").append(serverInfo).append(", Capabilities: ").append(capabilities).toString());
            return new InitializeResult(capabilities, serverInfo);
        });
    }

    private ProjectKind createProjectKind(DefaultProjectMetadata projectMetadata, ClientLoggerFactory clientLoggerFactory) {
        WorkspaceEditService workspaceEditsService = this.workspaceServiceManager.workspaceEditService();
        ProjectKind projectKind = this.projectKindFactory.createKind(new ProjectKindContext(projectMetadata, clientLoggerFactory, this.protocolService.getClient(), this.jobManagerService, workspaceEditsService));
        projectKind.initialize();
        return projectKind;
    }

    public void initialized(InitializedParams params) {
        this.projectKindsByWorkspaceFolderUri().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            this.jobManagerService.schedule(x$2 -> this.initializedProjectKind((ProjectKind)entry._2()), new StringBuilder(29).append("Starting DataWeave Project [").append(((ProjectKind)entry._2()).project().getName()).append("]").toString(), "Starting DataWeave Project.");
            return BoxedUnit.UNIT;
        });
        this.clientLogger().logInfo("Initialized");
    }

    private void initializedProjectKind(ProjectKind projectKind) {
        try {
            this.clientLogger().logInfo(new StringBuilder(21).append("Project: '").append(projectKind.project().getName()).append("' starting.").toString());
            projectKind.initialized();
            this.clientLogger().logInfo(new StringBuilder(20).append("Project: '").append(projectKind.project().getName()).append("' started.").toString());
        }
        catch (Exception e) {
            this.clientLogger().logError(new StringBuilder(28).append("Unable to start project: '").append(projectKind.project().getName()).append("'.").toString(), e);
        }
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.supplyAsync(() -> {
            this.projectKindsByWorkspaceFolderUri().foreach((Function1 & Serializable & scala.Serializable)entry -> {
                WeaveLanguageServer.$anonfun$shutdown$2(this, entry);
                return BoxedUnit.UNIT;
            });
            $this.workspaceServiceManager.removeWorkspaceServiceListeners(this);
            this.logger().debug("Stopped");
            return null;
        });
    }

    public void exit() {
        System.exit(0);
    }

    @JsonDelegate
    public WeaveTextDocumentService getTextDocumentService() {
        return this.textDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceServiceManager.workspaceService();
    }

    public void connect(LanguageClient client) {
        this.languageClient().delegate_$eq(client);
        this.workspaceServiceManager.onLanguageClientConnected(this.languageClient());
    }

    public ExecutorService executor() {
        return IDEExecutors$.MODULE$.defaultExecutor();
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.workspaceSettings().update(params.getSettings());
    }

    @Override
    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        params.getEvent().getRemoved().forEach(removedWorkspaceFolder -> {
            Option<ProjectKind> option = $this.workspaceServiceManager.onProjectKindRemoved(removedWorkspaceFolder.getUri());
            if (option instanceof Some) {
                Some some = (Some)option;
                ProjectKind projectKind = (ProjectKind)some.value();
                this.textDocumentServiceImpl().onProjectRemoved(projectKind);
                projectKind.shutdown();
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logger().debug(new StringBuilder(44).append("There is no projectKind registered for URI: ").append(removedWorkspaceFolder.getUri()).toString());
                return;
            }
            throw new MatchError(option);
        });
        params.getEvent().getAdded().forEach(addedWorkspaceFolder -> {
            try {
                ProjectKind projectKind = this.discoverAndRegisterProjectKind((WorkspaceFolder)addedWorkspaceFolder);
                this.initializedProjectKind(projectKind);
            }
            catch (Exception e) {
                this.clientLogger().logError(new StringBuilder(48).append("Unable to discover project for workspaceFolder: ").append(addedWorkspaceFolder.getUri()).toString(), e);
            }
        });
    }

    private DataWeaveDocumentService createLanguageServerDocumentService() {
        String url = URLUtils$.MODULE$.toLSPUrl(new File(WeaveDirectoryUtils$.MODULE$.getWorkingHome(), "Playground"));
        DefaultProjectMetadata projectMetadata = new DefaultProjectMetadata(url, this.workspaceSettings().cloneProjectSettings());
        ProjectKind projectKind = this.createProjectKind(projectMetadata, this.clientLoggerFactory());
        DataWeaveDocumentService languageServerDataWeaveDocumentService = new DataWeaveDocumentService(projectKind, this.executor(), false, false);
        String uri = URLUtils$.MODULE$.toLSPUrl(projectMetadata.home());
        this.workspaceServiceManager.standaloneContribution(uri, projectKind, new DefaultBaseWorkspaceServiceContributor(projectKind, projectMetadata, this.protocolService.getClient(), this.workspaceServiceManager.commandManagerService(), DefaultBaseWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5()));
        this.projectKindsByWorkspaceFolderUri().putIfAbsent((Object)uri, (Object)projectKind);
        projectKind.initialize();
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WeaveLanguageServer.class.getClassLoader());
            this.initializedProjectKind(projectKind);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
        return languageServerDataWeaveDocumentService;
    }

    private ProjectKind discoverAndRegisterProjectKind(WorkspaceFolder addedWorkspaceFolder) {
        DefaultProjectMetadata projectMetadata = new DefaultProjectMetadata(addedWorkspaceFolder.getUri(), this.workspaceSettings().cloneProjectSettings());
        ProjectKind projectKind = this.createProjectKind(projectMetadata, this.clientLoggerFactory());
        this.textDocumentServiceImpl().onProjectKindCreated(projectKind, new DataWeaveDocumentService(projectKind, this.executor(), true, true));
        this.workspaceServiceManager.onProjectKindCreated(addedWorkspaceFolder.getUri(), projectKind, new DefaultBaseWorkspaceServiceContributor(projectKind, projectMetadata, this.protocolService.getClient(), this.workspaceServiceManager.commandManagerService(), DefaultBaseWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5()));
        this.projectKindsByWorkspaceFolderUri().putIfAbsent((Object)addedWorkspaceFolder.getUri(), (Object)projectKind);
        return projectKind;
    }

    public static final /* synthetic */ void $anonfun$shutdown$2(WeaveLanguageServer $this, Tuple2 entry) {
        $this.workspaceServiceManager.onProjectKindRemoved((String)entry._1());
        $this.textDocumentServiceImpl().onProjectRemoved((ProjectKind)entry._2());
        ((ProjectKind)entry._2()).shutdown();
    }

    public WeaveLanguageServer(ProjectKindFactory projectKindFactory, DataWeaveProtocolService protocolService, WorkspaceServiceManager workspaceServiceManager, JobManagerService jobManagerService) {
        this.projectKindFactory = projectKindFactory;
        this.protocolService = protocolService;
        this.workspaceServiceManager = workspaceServiceManager;
        this.jobManagerService = jobManagerService;
        WorkspaceServiceListener.$init$(this);
        this.logger = LoggerFactory.getLogger(WeaveLanguageServer.class);
        this.textDocumentService = new TextDocumentServiceDelegate();
        Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)x$1 -> this.languageServerDocumentService();
        boolean x$2 = DataWeaveDocumentServiceDispatcher$.MODULE$.$lessinit$greater$default$1();
        Option<WeaveLanguageServerBuilder.TextDocumentTranslator> x$3 = DataWeaveDocumentServiceDispatcher$.MODULE$.$lessinit$greater$default$2();
        this.textDocumentServiceImpl = new DataWeaveDocumentServiceDispatcher(x$2, x$3, (Function1<String, WeaveTextDocumentService>)x$12);
        this.projectKindsByWorkspaceFolderUri = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.languageClient = new LanguageClientDelegate();
        this.workspaceSettings = new ProjectSettings(ProjectSettings$.MODULE$.apply$default$1(), ProjectSettings$.MODULE$.apply$default$2(), ProjectSettings$.MODULE$.apply$default$3(), ProjectSettings$.MODULE$.apply$default$4(), ProjectSettings$.MODULE$.apply$default$5(), ProjectSettings$.MODULE$.apply$default$6(), ProjectSettings$.MODULE$.apply$default$7(), ProjectSettings$.MODULE$.apply$default$8(), ProjectSettings$.MODULE$.apply$default$9(), ProjectSettings$.MODULE$.apply$default$10(), ProjectSettings$.MODULE$.apply$default$11());
        this.ID = "DATA_WEAVE_LSP";
    }
}

