/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.mule.weave.dsp.DataWeaveDebuggerAdapterProtocolLauncher$;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProcessLauncher;
import org.mule.weave.lsp.project.components.ProcessLauncher$;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveTestService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e4Aa\u0003\u0007\u0001/!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u000b\u0005\u0003A\u0011\u0001\"\t\u000b%\u0003A\u0011\t&\t\u000ba\u0003A\u0011I-\t\u000b!\u0004A\u0011B5\t\u000bU\u0004A\u0011\t&\t\u000bY\u0004A\u0011I<\u0003\u001fI+hnV3bm\u0016\u001cu.\\7b]\u0012T!!\u0004\b\u0002\u0011\r|W.\\1oINT!a\u0004\t\u0002\u00071\u001c\bO\u0003\u0002\u0012%\u0005)q/Z1wK*\u00111\u0003F\u0001\u0005[VdWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0004\t\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019y%M[3diB\u0011\u0011%K\u0007\u0002E)\u00111\u0005J\u0001\bG>lW.\u00198e\u0015\t)c%A\u0005fqR,gn]5p]*\u0011q\u0005K\u0001\u0004CBL'BA\u0013\u0011\u0013\tQ#E\u0001\u0007XK\u00064XmQ8n[\u0006tG-A\fx_J\\7\u000f]1dKN+'O^5dK6\u000bg.Y4feB\u0011Q\u0006M\u0007\u0002])\u0011qFD\u0001\tg\u0016\u0014h/[2fg&\u0011\u0011G\f\u0002\u0018/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\fQ\u0002\\8hO\u0016\u0014h)Y2u_JL\bCA\u00175\u0013\t)dFA\nDY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180A\tk_\nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\b\u0002\t)|'m]\u0005\u0003ye\u0012\u0011CS8c\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f\u0003%)\u0018jU3sm&\u001cW\r\u0005\u0002.\u007f%\u0011\u0001I\f\u0002\n+&\u001bVM\u001d<jG\u0016\fa\u0001P5oSRtD#B\"F\r\u001eC\u0005C\u0001#\u0001\u001b\u0005a\u0001\"B\u0016\u0006\u0001\u0004a\u0003\"\u0002\u001a\u0006\u0001\u0004\u0019\u0004\"\u0002\u001c\u0006\u0001\u00049\u0004\"B\u001f\u0006\u0001\u0004q\u0014!C2p[6\fg\u000eZ%e)\u0005Y\u0005C\u0001'V\u001d\ti5\u000b\u0005\u0002O#6\tqJ\u0003\u0002Q-\u00051AH]8pizR\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)F\u000ba\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A+U\u0001\bKb,7-\u001e;f)\tQf\f\u0005\u0002\\96\t\u0011+\u0003\u0002^#\n1\u0011I\\=SK\u001aDQaX\u0004A\u0002\u0001\fa\u0001]1sC6\u001c\bCA1g\u001b\u0005\u0011'BA2e\u0003\u0015a7\u000f\u001d\u001bk\u0015\t)G#A\u0004fG2L\u0007o]3\n\u0005\u001d\u0014'\u0001F#yK\u000e,H/Z\"p[6\fg\u000e\u001a)be\u0006l7/\u0001\u0006sk:l\u0015\r\u001d9j]\u001e$BA[7piB\u0011\u0011d[\u0005\u0003Yj\u0011q!\u00138uK\u001e,'\u000fC\u0003o\u0011\u0001\u00071*\u0001\u0004d_:4\u0017n\u001a\u0005\u0006a\"\u0001\r!]\u0001\u0015[\u0006L(-\u001a)s_*,7\r\u001e$jY\u0016\u0004\u0016\r\u001e5\u0011\u0007m\u00138*\u0003\u0002t#\n1q\n\u001d;j_:DQ!\u0010\u0005A\u0002y\nAA\\1nK\u0006YA-Z:de&\u0004H/[8o)\tY\u0005\u0010C\u0003`\u0015\u0001\u0007\u0001\r")
public class RunWeaveCommand
implements WeaveCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final ClientLoggerFactory loggerFactory;
    private final JobManagerService jobManagerService;
    private final UIService uIService;

    public String commandId() {
        return Commands$.MODULE$.DW_RUN_MAPPING();
    }

    public Object execute(ExecuteCommandParams params) {
        String configType = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        Option<String> maybeProjectFilePath = Commands$.MODULE$.optionalArgAsString(params.getArguments(), 1);
        return this.runMapping(configType, maybeProjectFilePath, this.uIService);
    }

    private Integer runMapping(String config, Option<String> maybeProjectFilePath, UIService uIService) {
        if (maybeProjectFilePath.isEmpty()) {
            return Predef$.MODULE$.int2Integer(-1);
        }
        File projectFolder = (File)maybeProjectFilePath.map((Function1 & Serializable & scala.Serializable)path -> Paths.get(path, new String[0]).toFile()).get();
        Option maybeProjectKind = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workspaceServiceManager.projectKinds())).find((Function1 & Serializable & scala.Serializable)projectKind -> BoxesRunTime.boxToBoolean((boolean)RunWeaveCommand.$anonfun$runMapping$2(projectFolder, projectKind)));
        if (maybeProjectKind.isEmpty()) {
            uIService.showMessage(new MessageParams(MessageType.Warning, new StringBuilder(66).append("Can not run a DW script, no projectKind registered for file path: ").append(maybeProjectFilePath.get()).toString()));
            return Predef$.MODULE$.int2Integer(-1);
        }
        ProjectKind projectKind2 = (ProjectKind)maybeProjectKind.get();
        if (!projectKind2.isStarted()) {
            uIService.showMessage(new MessageParams(MessageType.Warning, "Can not run a DW script until Project was initialized."));
            return Predef$.MODULE$.int2Integer(-1);
        }
        int port = NetUtils$.MODULE$.freePort();
        CountDownLatch latch = new CountDownLatch(1);
        this.jobManagerService.schedule(status -> {
            ProcessLauncher launcher = ProcessLauncher$.MODULE$.createLauncherByType(config, projectKind2, $this.loggerFactory, uIService, projectKind2.toolingService(ProjectFileSystemService.class));
            DataWeaveDebuggerAdapterProtocolLauncher$.MODULE$.launch(projectKind2.vfs(), $this.loggerFactory, uIService, launcher, projectKind2, $this.jobManagerService, projectKind2.toolingService(DataWeaveTestService.class), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.countDown(), port);
        }, "Starting Debugger Server", "Starting Debugger Server");
        latch.await();
        return Predef$.MODULE$.int2Integer(port);
    }

    public String name() {
        return "Run DataWeave.";
    }

    public String description(ExecuteCommandParams params) {
        return "Running DataWeave Command.";
    }

    public static final /* synthetic */ boolean $anonfun$runMapping$2(File projectFolder$1, ProjectKind projectKind) {
        return projectKind.projectMetadata().home().equals(projectFolder$1);
    }

    public RunWeaveCommand(WorkspaceServiceManager workspaceServiceManager, ClientLoggerFactory loggerFactory, JobManagerService jobManagerService, UIService uIService) {
        this.workspaceServiceManager = workspaceServiceManager;
        this.loggerFactory = loggerFactory;
        this.jobManagerService = jobManagerService;
        this.uIService = uIService;
    }
}

