/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.jobs.Status;
import org.mule.weave.lsp.jobs.Task;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.WorkspaceServiceContributor;
import org.mule.weave.lsp.services.WorkspaceServiceContributorRegistry;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.v2.editor.VirtualFile;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001da\u0006A1A\u0005\nuCa!\u001d\u0001!\u0002\u0013q\u0006b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007u\u0002\u0001\u000b\u0011\u0002;\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011\u0011\u0001\u0001!\u0002\u0013i\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u00026\u0001!I!a\u000e\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u00111\u0012\u0001\u0005B\u00055\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003W\u0003A\u0011IAW\u0011\u001d\t9\f\u0001C!\u0003s\u0013\u0011\u0004R1uC^+\u0017M^3X_J\\7\u000f]1dKN+'O^5dK*\u0011!dG\u0001\tg\u0016\u0014h/[2fg*\u0011A$H\u0001\u0004YN\u0004(B\u0001\u0010 \u0003\u00159X-\u0019<f\u0015\t\u0001\u0013%\u0001\u0003nk2,'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001)SF\u000e\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019y%M[3diB\u0011a\u0006N\u0007\u0002_)\u0011!\u0004\r\u0006\u0003cI\nQ\u0001\\:qi)T!aM\u0011\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011Qg\f\u0002\u0011/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u000e\u001d\u000e\u0003eI!!O\r\u0003G]{'o[:qC\u000e,7+\u001a:wS\u000e,7i\u001c8ue&\u0014W\u000f^8s%\u0016<\u0017n\u001d;ss\u0006\u0019r/Z1wKB\u0013x\u000e^8d_2\u001cE.[3oiB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\taJ|Go\\2pY*\u0011\u0001iG\u0001\nKb$XM\\:j_:L!AQ\u001f\u0003/\u0011\u000bG/Y,fCZ,\u0007K]8u_\u000e|Gn\u00117jK:$\u0018!\u00056pE6\u000bg.Y4feN+'O^5dKB\u0011Q\tS\u0007\u0002\r*\u0011qiG\u0001\u0005U>\u00147/\u0003\u0002J\r\n\t\"j\u001c2NC:\fw-\u001a:TKJ4\u0018nY3\u0002\u001d\r|W.\\1oI6\u000bg.Y4feB\u0011AjT\u0007\u0002\u001b*\u0011ajG\u0001\tG>lW.\u00198eg&\u0011\u0001+\u0014\u0002\u0016\u0007>lW.\u00198e\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f\u0003a9xN]6ta\u0006\u001cWmU3sm&\u001cW\rT5ti\u0016tWM\u001d\t\u0003oMK!\u0001V\r\u00031]{'o[:qC\u000e,7+\u001a:wS\u000e,G*[:uK:,'/\u0001\u0004=S:LGO\u0010\u000b\u0006/bK&l\u0017\t\u0003o\u0001AQAO\u0003A\u0002mBQaQ\u0003A\u0002\u0011CQAS\u0003A\u0002-CQ!U\u0003A\u0002I\u000bA\u0004\u001d:pU\u0016\u001cGoV8sWN\u0004\u0018mY3D_:$(/\u001b2vi>\u00148/F\u0001_!\u0011yf\r\u001b8\u000e\u0003\u0001T!!\u00192\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002dI\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0015\fQa]2bY\u0006L!a\u001a1\u0003\u000fQ\u0013\u0018.Z'baB\u0011\u0011\u000e\\\u0007\u0002U*\u00111nG\u0001\baJ|'.Z2u\u0013\ti'NA\u0006Qe>TWm\u0019;LS:$\u0007CA\u001cp\u0013\t\u0001\u0018DA\u000eX_J\\7\u000f]1dKN+'O^5dK\u000e{g\u000e\u001e:jEV$xN]\u0001\u001eaJ|'.Z2u/>\u00148n\u001d9bG\u0016\u001cuN\u001c;sS\n,Ho\u001c:tA\u0005\trN\u001c#pGVlWM\u001c;DQ\u0006tw-\u001a3\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a^\r\u0002\r\u00154XM\u001c;t\u0013\tIhOA\tP]\u0012{7-^7f]R\u001c\u0005.\u00198hK\u0012\f!c\u001c8E_\u000e,X.\u001a8u\u0007\"\fgnZ3eA\u0005\u0001rN\u001c#pGVlWM\u001c;Pa\u0016tW\rZ\u000b\u0002{B\u0011QO`\u0005\u0003\u007fZ\u0014\u0001c\u00148E_\u000e,X.\u001a8u\u001fB,g.\u001a3\u0002#=tGi\\2v[\u0016tGo\u00149f]\u0016$\u0007%A\tp]\u0012{7-^7f]R4unY;tK\u0012,\"!a\u0002\u0011\u0007U\fI!C\u0002\u0002\fY\u0014\u0011c\u00148E_\u000e,X.\u001a8u\r>\u001cWo]3e\u0003Iyg\u000eR8dk6,g\u000e\u001e$pGV\u001cX\r\u001a\u0011\u0002)=t\u0007K]8kK\u000e$8*\u001b8e\u0007J,\u0017\r^3e)\u0019\t\u0019\"a\u0007\u0002 A!\u0011QCA\f\u001b\u0005!\u0017bAA\rI\n!QK\\5u\u0011\u0019\tiB\u0004a\u0001Q\u0006Y\u0001O]8kK\u000e$8*\u001b8e\u0011\u0019\t\tC\u0004a\u0001]\u0006Yro\u001c:lgB\f7-Z*feZL7-Z\"p]R\u0014\u0018NY;u_J\fAc\u001c8Qe>TWm\u0019;LS:$'+Z7pm\u0016$G\u0003BA\n\u0003OAa!!\b\u0010\u0001\u0004A\u0017!\u0007:fO&\u001cH/\u001a:E_\u000e,X.\u001a8u\u0019&\u001cH/\u001a8feN$B!a\u0005\u0002.!1\u0011Q\u0004\tA\u0002!\f1$\u001e8sK\u001eL7\u000f^3s\t>\u001cW/\\3oi2K7\u000f^3oKJ\u001cH\u0003BA\n\u0003gAa!!\b\u0012\u0001\u0004A\u0017\u0001\u00068pi&4\u0017pQ8oi\u0016DHo\u00115b]\u001e,G\r\u0006\u0003\u0002\u0014\u0005e\u0002bBA\u001e%\u0001\u0007\u0011QH\u0001\u0003m\u001a\u0004B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0004fI&$xN\u001d\u0006\u0004\u0003\u000fj\u0012A\u0001<3\u0013\u0011\tY%!\u0011\u0003\u0017YK'\u000f^;bY\u001aKG.Z\u0001\u0007gfl'm\u001c7\u0015\t\u0005E\u0013\u0011\u0011\t\u0007\u0003'\nY&a\u0018\u000e\u0005\u0005U#bA1\u0002X)\u0019\u0011\u0011L\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\n)FA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004D!!\u0019\u0002nA1\u00111MA3\u0003Sj!!a\u0016\n\t\u0005\u001d\u0014q\u000b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002l\u00055D\u0002\u0001\u0003\f\u0003_\u001a\u0012\u0011!A\u0001\u0006\u0003\t\tHA\u0002`IE\nB!a\u001d\u0002zA!\u0011QCA;\u0013\r\t9\b\u001a\u0002\b\u001d>$\b.\u001b8h!\u0011\tY(! \u000e\u0003AJ1!a 1\u0005E\u0019\u00160\u001c2pY&sgm\u001c:nCRLwN\u001c\u0005\b\u0003\u0007\u001b\u0002\u0019AAC\u0003\u0019\u0001\u0018M]1ngB!\u00111PAD\u0013\r\tI\t\r\u0002\u0016/>\u00148n\u001d9bG\u0016\u001c\u00160\u001c2pYB\u000b'/Y7t\u0003Y!\u0017\u000eZ\"iC:<WmQ8oM&<WO]1uS>tG\u0003BA\n\u0003\u001fCq!a!\u0015\u0001\u0004\t\t\n\u0005\u0003\u0002|\u0005M\u0015bAAKa\taB)\u001b3DQ\u0006tw-Z\"p]\u001aLw-\u001e:bi&|g\u000eU1sC6\u001c\u0018AD3yK\u000e,H/Z\"p[6\fg\u000e\u001a\u000b\u0005\u00037\u000b\u0019\u000b\u0005\u0004\u0002T\u0005m\u0013Q\u0014\t\u0005\u0003+\ty*C\u0002\u0002\"\u0012\u0014a!\u00118z%\u00164\u0007bBAB+\u0001\u0007\u0011Q\u0015\t\u0005\u0003w\n9+C\u0002\u0002*B\u0012A#\u0012=fGV$XmQ8n[\u0006tG\rU1sC6\u001c\u0018!\u00073jI\u000eC\u0017M\\4f/>\u00148n\u001d9bG\u00164u\u000e\u001c3feN$B!a\u0005\u00020\"9\u00111\u0011\fA\u0002\u0005E\u0006\u0003BA>\u0003gK1!!.1\u0005}!\u0015\u000eZ\"iC:<WmV8sWN\u0004\u0018mY3G_2$WM]:QCJ\fWn]\u0001\u0016I&$7\t[1oO\u0016<\u0016\r^2iK\u00124\u0015\u000e\\3t)\u0011\t\u0019\"a/\t\u000f\u0005\ru\u00031\u0001\u0002>B!\u00111PA`\u0013\r\t\t\r\r\u0002\u001c\t&$7\t[1oO\u0016<\u0016\r^2iK\u00124\u0015\u000e\\3t!\u0006\u0014\u0018-\\:")
public class DataWeaveWorkspaceService
implements WorkspaceService,
WorkspaceServiceContributorRegistry {
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final JobManagerService jobManagerService;
    private final CommandManagerService commandManager;
    private final WorkspaceServiceListener workspaceServiceListener;
    private final TrieMap<ProjectKind, WorkspaceServiceContributor> projectWorkspaceContributors;
    private final OnDocumentChanged onDocumentChanged;
    private final OnDocumentOpened onDocumentOpened;
    private final OnDocumentFocused onDocumentFocused;

    private TrieMap<ProjectKind, WorkspaceServiceContributor> projectWorkspaceContributors() {
        return this.projectWorkspaceContributors;
    }

    private OnDocumentChanged onDocumentChanged() {
        return this.onDocumentChanged;
    }

    private OnDocumentOpened onDocumentOpened() {
        return this.onDocumentOpened;
    }

    private OnDocumentFocused onDocumentFocused() {
        return this.onDocumentFocused;
    }

    @Override
    public void onProjectKindCreated(ProjectKind projectKind, WorkspaceServiceContributor workspaceServiceContributor) {
        Option option = this.projectWorkspaceContributors().putIfAbsent((Object)projectKind, (Object)workspaceServiceContributor);
        if (option instanceof Some) {
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.registerDocumentListeners(projectKind);
            return;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void onProjectKindRemoved(ProjectKind projectKind) {
        Option option = this.projectWorkspaceContributors().remove((Object)projectKind);
        if (option instanceof Some) {
            this.unregisterDocumentListeners(projectKind);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private void registerDocumentListeners(ProjectKind projectKind) {
        projectKind.eventBus().register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), this.onDocumentChanged());
        projectKind.eventBus().register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), this.onDocumentOpened());
        projectKind.eventBus().register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), this.onDocumentFocused());
    }

    private void unregisterDocumentListeners(ProjectKind projectKind) {
        projectKind.eventBus().unRegister(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), this.onDocumentChanged());
        projectKind.eventBus().unRegister(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), this.onDocumentOpened());
        projectKind.eventBus().unRegister(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), this.onDocumentFocused());
    }

    private void notifyContextChanged(VirtualFile vf) {
        SetContextValue[] values = (SetContextValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.commandManager.commands())).map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(vf.url());
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SetContextValue.class)));
        SetContextParams params = new SetContextParams(Arrays.asList((Object[])values));
        this.weaveProtocolClient.setContext(params);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        CompletableFuture[] futures = (CompletableFuture[])((TraversableOnce)this.projectWorkspaceContributors().values().map((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> projectWorkspaceContributor.symbol(params), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(CompletableFuture.class));
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures);
        return allFutures.thenApply(x$1 -> {
            ArrayList symbolsInformation = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])futures)).foreach((Function1 & Serializable & scala.Serializable)future -> BoxesRunTime.boxToBoolean((boolean)symbolsInformation.addAll((Collection)future.join())));
            return symbolsInformation;
        });
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.workspaceServiceListener.didChangeConfiguration(params);
        this.projectWorkspaceContributors().values().foreach((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> {
            projectWorkspaceContributor.didChangeConfiguration(params);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return CompletableFuture.supplyAsync(() -> $this.commandManager.commandBy(params.getCommand()).map((Function1 & Serializable & scala.Serializable)c -> {
            ObjectRef result = ObjectRef.create(null);
            $this.jobManagerService.execute(new Task(null, result, (WeaveCommand)c, params){
                private final ObjectRef result$1;
                private final WeaveCommand c$1;
                private final ExecuteCommandParams params$3;

                public void run(Status cancelable) {
                    this.result$1.elem = this.c$1.execute(this.params$3);
                }
                {
                    this.result$1 = result$1;
                    this.c$1 = c$1;
                    this.params$3 = params$3;
                }
            }, new StringBuilder(17).append("Running command: ").append(c.name()).toString(), String.valueOf(c.description(params)));
            return result.elem;
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.workspaceServiceListener.didChangeWorkspaceFolders(params);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.projectWorkspaceContributors().values().foreach((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> {
            projectWorkspaceContributor.didChangeWatchedFiles(params);
            return BoxedUnit.UNIT;
        });
    }

    public DataWeaveWorkspaceService(DataWeaveProtocolClient weaveProtocolClient, JobManagerService jobManagerService, CommandManagerService commandManager, WorkspaceServiceListener workspaceServiceListener) {
        this.weaveProtocolClient = weaveProtocolClient;
        this.jobManagerService = jobManagerService;
        this.commandManager = commandManager;
        this.workspaceServiceListener = workspaceServiceListener;
        this.projectWorkspaceContributors = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.onDocumentChanged = vf -> this.notifyContextChanged(vf);
        this.onDocumentOpened = vf -> this.notifyContextChanged(vf);
        this.onDocumentFocused = vf -> this.notifyContextChanged(vf);
    }
}

