/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SampleInput;
import org.mule.weave.lsp.extension.protocol.ShowScenariosParams;
import org.mule.weave.lsp.extension.protocol.WeaveScenario;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.SampleDataComponent;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService$;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.OnDocumentClosed;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.utils.InputScaffoldingFactory$;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode;
import org.mule.weave.v2.parser.ast.structure.ArrayNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r\rb\u0001B\u001a5\u0001}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005\\\u0001\t\u0015\r\u0011\"\u0001]\u0011!)\u0007A!A!\u0002\u0013i\u0006\"\u00024\u0001\t\u00039\u0007\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0003o\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0005}\u0001\u0001\u0007\t\u0011)Q\u0005_\"IQ\u0010\u0001a\u0001\u0002\u0004%\tB \u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n#\ti\u0001\u0003\u0006\u0002\u0012\u0001\u0001\r\u0011!Q!\n}D\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003/Aq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003[\u0003A\u0011AAX\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!2\u0001\t\u0003\t9\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u00111\u001f\u0001\u0005\u0002\u0005U\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;A\u0011B!\r\u0001#\u0003%\tAa\r\t\u0013\t%\u0003!%A\u0005\u0002\tM\u0002b\u0002B&\u0001\u0011\u0005!Q\n\u0005\n\u0005'\u0002\u0011\u0013!C\u0001\u0005gAqA!\u0016\u0001\t\u0003\u00119\u0006C\u0004\u0003`\u0001!\tB!\u0019\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005o\u0003A\u0011\u0002B]\u0011\u001d\u00119\f\u0001C\u0005\u0005\u0017DqAa5\u0001\t\u0013\u0011)\u000eC\u0004\u0003`\u0002!IA!9\t\u000f\t\u001d\b\u0001\"\u0001\u0003j\"9!\u0011\u001f\u0001\u0005\n\tM\bb\u0002B}\u0001\u0011%!1 \u0005\b\u0005s\u0004A\u0011BB\u0004\u000f\u001d\u0019Y\u0001\u000eE\u0001\u0007\u001b1aa\r\u001b\t\u0002\r=\u0001B\u000240\t\u0003\u0019\t\u0002C\u0005\u0004\u0014=\u0012\r\u0011\"\u0001\u0004\u0016!A1\u0011E\u0018!\u0002\u0013\u00199BA\u000eXK\u00064XmU2f]\u0006\u0014\u0018n\\'b]\u0006<WM]*feZL7-\u001a\u0006\u0003kY\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003oa\n1\u0001\\:q\u0015\tI$(A\u0003xK\u00064XM\u0003\u0002<y\u0005!Q.\u001e7f\u0015\u0005i\u0014aA8sO\u000e\u00011c\u0001\u0001A\rB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n1\u0011I\\=SK\u001a\u0004\"a\u0012%\u000e\u0003QJ!!\u0013\u001b\u0003\u001dQ{w\u000e\\5oON+'O^5dK\u00069B-\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-\u001a\t\u0003\u000f2K!!\u0014\u001b\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017!F<pe.\u001c\b/Y2f\u000b\u0012LGo]*feZL7-\u001a\t\u0003\u000fBK!!\u0015\u001b\u0003)]{'o[:qC\u000e,W\tZ5u'\u0016\u0014h/[2f\u0003M9X-\u0019<f\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0005qe>$xnY8m\u0015\tAf'A\u0005fqR,gn]5p]&\u0011!,\u0016\u0002\u0018\t\u0006$\u0018mV3bm\u0016\u0004&o\u001c;pG>d7\t\\5f]R\f\u0011C^5siV\fGNR5mKNK8\u000f^3n+\u0005i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\u0019)G-\u001b;pe*\u0011!\rO\u0001\u0003mJJ!\u0001Z0\u0003#YK'\u000f^;bY\u001aKG.Z*zgR,W.\u0001\nwSJ$X/\u00197GS2,7+_:uK6\u0004\u0013A\u0002\u001fj]&$h\bF\u0003iS*\\G\u000e\u0005\u0002H\u0001!)!J\u0002a\u0001\u0017\")aJ\u0002a\u0001\u001f\")!K\u0002a\u0001'\")1L\u0002a\u0001;\u0006AQM^3oi\n+8/F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011h'A\u0003vi&d7/\u0003\u0002uc\n\u0001\u0012J\u001c;fe:\fG.\u0012<f]R\u0014Uo]\u0001\rKZ,g\u000e\u001e\"vg~#S-\u001d\u000b\u0003oj\u0004\"!\u0011=\n\u0005e\u0014%\u0001B+oSRDqa\u001f\u0005\u0002\u0002\u0003\u0007q.A\u0002yIE\n\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\u0017A\u0014xN[3di.Kg\u000eZ\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006Y\nq\u0001\u001d:pU\u0016\u001cG/\u0003\u0003\u0002\n\u0005\r!a\u0003)s_*,7\r^&j]\u0012\fq\u0002\u001d:pU\u0016\u001cGoS5oI~#S-\u001d\u000b\u0004o\u0006=\u0001bB>\f\u0003\u0003\u0005\ra`\u0001\raJ|'.Z2u\u0017&tG\rI\u0001\u0010C\u000e$\u0018N^3TG\u0016t\u0017M]5pgV\u0011\u0011q\u0003\t\t\u00033\t\u0019#a\n\u0002<5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0005\")\u0001\u0006d_2dWm\u0019;j_:LA!!\n\u0002\u001c\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0015\u0003oi!!a\u000b\u000b\t\u00055\u0012qF\u0001\nm\u0006\u0014\u0018.\u00192mKNTA!!\r\u00024\u0005\u0019\u0011m\u001d;\u000b\u0007\u0005U\u0012-\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0003s\tYC\u0001\bOC6,\u0017\nZ3oi&4\u0017.\u001a:\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQA!!\u0011\u0002\u0004\u0005Q1m\\7q_:,g\u000e^:\n\t\u0005\u0015\u0013q\b\u0002\t'\u000e,g.\u0019:j_\u0006\u0001\u0012m\u0019;jm\u0016\u001c6-\u001a8be&|7\u000fI\u0001\r[\u0006\u00048kY3oCJLwn\u001d\u000b\u0007\u0003\u001b\n\u0019'!\u001c\u0011\r\u0005=\u0013\u0011LA/\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001B;uS2T!!a\u0016\u0002\t)\fg/Y\u0005\u0005\u00037\n\tF\u0001\u0003MSN$\bc\u0001+\u0002`%\u0019\u0011\u0011M+\u0003\u001b]+\u0017M^3TG\u0016t\u0017M]5p\u0011\u001d\t)g\u0004a\u0001\u0003O\n1#\\1zE\u0016\f5\r^5wKN\u001bWM\\1sS>\u0004R!QA5\u0003wI1!a\u001bC\u0005\u0019y\u0005\u000f^5p]\"9\u0011qN\bA\u0002\u0005E\u0014\u0001D1mYN\u001bWM\\1sS>\u001c\b#B!\u0002t\u0005m\u0012bAA;\u0005\n)\u0011I\u001d:bs\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000b]\fY(! \t\u000bu\u0004\u0002\u0019A@\t\u000b5\u0004\u0002\u0019A8\u0002\u001b1L7\u000f^*dK:\f'/[8t)\u0011\t\t(a!\t\u000f\u0005\u0015\u0015\u00031\u0001\u0002(\u0005qa.Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0001F:fCJ\u001c\u0007nU2f]\u0006\u0014\u0018n\u001c\"z\u001d\u0006lW\r\u0006\u0004\u0002h\u0005-\u0015Q\u0012\u0005\b\u0003\u000b\u0013\u0002\u0019AA\u0014\u0011\u001d\tyI\u0005a\u0001\u0003#\u000bAb]2f]\u0006\u0014\u0018n\u001c(b[\u0016\u0004B!a%\u0002\":!\u0011QSAO!\r\t9JQ\u0007\u0003\u00033S1!a'?\u0003\u0019a$o\\8u}%\u0019\u0011q\u0014\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019+!*\u0003\rM#(/\u001b8h\u0015\r\tyJQ\u0001\u000fC\u000e$\u0018N^3TG\u0016t\u0017M]5p)\u0011\t9'a+\t\u000f\u0005\u00155\u00031\u0001\u0002(\u0005q1m\u001c9z'\u000e,g.\u0019:j_R{GcB<\u00022\u0006U\u0016\u0011\u0018\u0005\b\u0003g#\u0002\u0019AA\u0014\u0003Ei\u0017\r\u001d9j]\u001eLE-\u001a8uS\u001aLWM\u001d\u0005\b\u0003o#\u0002\u0019AA\u001e\u0003-yG\u000eZ*dK:\f'/[8\t\u000f\u0005=E\u00031\u0001\u0002\u0012\u0006\t2/\u001a;BGRLg/Z*dK:\f'/[8\u0015\u000b]\fy,!1\t\u000f\u0005\u0015U\u00031\u0001\u0002(!9\u00111Y\u000bA\u0002\u0005E\u0015!\u00058b[\u0016|e\r\u00165f'\u000e,g.\u0019:j_\u0006qA-\u001a7fi\u0016\u001c6-\u001a8be&|G#B<\u0002J\u0006-\u0007bBAC-\u0001\u0007\u0011q\u0005\u0005\b\u0003\u00074\u0002\u0019AAI\u0003e\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016l\u0015\r\u001d9j]\u001e$Vm\u001d;\u0015\u0011\u0005E\u0017q\\Aq\u0003G\u0004R!QA5\u0003'\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0005\u00033\f)&\u0001\u0002j_&!\u0011Q\\Al\u0005\u00111\u0015\u000e\\3\t\u000f\u0005\u0015u\u00031\u0001\u0002(!9\u0011qR\fA\u0002\u0005E\u0005bBAs/\u0001\u0007\u0011\u0011S\u0001\t[&lW\rV=qK\u0006QAm\\*bm\u0016$Vm\u001d;\u0015\u0011\u0005E\u00171^Aw\u0003cDq!!\"\u0019\u0001\u0004\t9\u0003C\u0004\u0002pb\u0001\r!a\u000f\u0002\u0011M\u001cWM\\1sS>Dq!!:\u0019\u0001\u0004\t\t*\u0001\u0006tCZ,w*\u001e;qkR$\"\"!5\u0002x\u0006e\u00181`A\u0000\u0011\u001d\t))\u0007a\u0001\u0003OAq!a1\u001a\u0001\u0004\t\t\nC\u0004\u0002~f\u0001\r!!%\u0002\u0015=,H\u000f];u\u001d\u0006lW\rC\u0004\u0003\u0002e\u0001\r!!%\u0002\u00159,woQ8oi\u0016tG/\u0001\u0007eK2,G/Z(viB,H\u000fF\u0004x\u0005\u000f\u0011IAa\u0003\t\u000f\u0005\u0015%\u00041\u0001\u0002(!9\u00111\u0019\u000eA\u0002\u0005E\u0005b\u0002B\u00075\u0001\u0007\u0011\u0011S\u0001\n_V$\b/\u001e;Ve2\f1\u0002Z3mKR,\u0017J\u001c9viR9qOa\u0005\u0003\u0016\t]\u0001bBAC7\u0001\u0007\u0011q\u0005\u0005\b\u0003\u0007\\\u0002\u0019AAI\u0011\u001d\u0011Ib\u0007a\u0001\u0003#\u000b\u0001\"\u001b8qkR,&\u000f\\\u0001\u000fGJ,\u0017\r^3TG\u0016t\u0017M]5p)1\t\tNa\b\u0003\"\t\r\"q\u0005B\u0017\u0011\u001d\t)\t\ba\u0001\u0003OAq!a1\u001d\u0001\u0004\t\t\nC\u0004\u0003&q\u0001\r!!%\u0002\u001b%t\u0007/\u001e;GS2,g*Y7f\u0011%\u0011I\u0003\bI\u0001\u0002\u0004\u0011Y#A\tnCf\u0014W-\u00138qkR\u001cuN\u001c;f]R\u0004R!QA5\u0003#C\u0011Ba\f\u001d!\u0003\u0005\rAa\u000b\u0002\u0007U\u0014\u0018.\u0001\rde\u0016\fG/Z*dK:\f'/[8%I\u00164\u0017-\u001e7uIQ*\"A!\u000e+\t\t-\"qG\u0016\u0003\u0005s\u0001BAa\u000f\u0003F5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%A\u0005v]\u000eDWmY6fI*\u0019!1\t\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003H\tu\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A2M]3bi\u0016\u001c6-\u001a8be&|G\u0005Z3gCVdG\u000fJ\u001b\u0002!M\fW\u000e\u001d7f\t\u0006$\u0018MR8mI\u0016\u0014HCBAj\u0005\u001f\u0012\t\u0006C\u0004\u0002\u0006~\u0001\r!a\n\t\u0013\t=r\u0004%AA\u0002\t-\u0012AG:b[BdW\rR1uC\u001a{G\u000eZ3sI\u0011,g-Y;mi\u0012\u0012\u0014AC:dK:\f'/[8PMR1\u00111\u001bB-\u0005;BqAa\u0017\"\u0001\u0004\t\u0019.A\btC6\u0004H.Z\"p]R\f\u0017N\\3s\u0011\u001d\t\u0019-\ta\u0001\u0003#\u000bQ\u0002Z8De\u0016\fG/Z%oaV$HCCAi\u0005G\u0012)Ga\u001a\u0003j!9\u0011Q\u0011\u0012A\u0002\u0005\u001d\u0002b\u0002B\u0013E\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005S\u0011\u0003\u0019\u0001B\u0016\u0011\u001d\tyO\ta\u0001\u0003'\fQ\u0002Z3mKR,g)\u001b7f\u00076$G\u0003\u0002B8\u0005+\u0003\u0002B!\u001d\u0003\u0004\n\u001d%qR\u0007\u0003\u0005gRAA!\u001e\u0003x\u0005AQ.Z:tC\u001e,7O\u0003\u0003\u0003z\tm\u0014a\u00026t_:\u0014\bo\u0019\u0006\u0005\u0005{\u0012y(A\u0003mgB$$NC\u0002\u0003\u0002r\nq!Z2mSB\u001cX-\u0003\u0003\u0003\u0006\nM$AB#ji\",'\u000f\u0005\u0003\u0003\n\n-UB\u0001B>\u0013\u0011\u0011iIa\u001f\u0003!Q+\u0007\u0010\u001e#pGVlWM\u001c;FI&$\b\u0003\u0002BE\u0005#KAAa%\u0003|\t\t\"+Z:pkJ\u001cWm\u00149fe\u0006$\u0018n\u001c8\t\u000f\t]5\u00051\u0001\u0002T\u0006yA-Z:uS:\fG/[8o\r&dW-A\u0007de\u0016\fG/\u001a$jY\u0016\u001cU\u000e\u001a\u000b\u0005\u0005_\u0012i\nC\u0004\u0003\u0018\u0012\u0002\r!a5\u0002\u0017\u0015$\u0017\u000e\u001e$jY\u0016\u001cU\u000e\u001a\u000b\u000b\u0005_\u0012\u0019K!*\u00030\nM\u0006b\u0002BLK\u0001\u0007\u00111\u001b\u0005\b\u0005O+\u0003\u0019\u0001BU\u0003!\u0019H/\u0019:u!>\u001c\b\u0003\u0002BE\u0005WKAA!,\u0003|\tA\u0001k\\:ji&|g\u000eC\u0004\u00032\u0016\u0002\rA!+\u0002\r\u0015tG\rU8t\u0011\u001d\u0011),\na\u0001\u0003#\u000bqA\\3x)\u0016DH/\u0001\u0006baBd\u00170\u00123jiN$BAa/\u0003BB!!\u0011\u0012B_\u0013\u0011\u0011yLa\u001f\u00035\u0005\u0003\b\u000f\\=X_J\\7\u000f]1dK\u0016#\u0017\u000e\u001e*fgB|gn]3\t\u000f\t\rg\u00051\u0001\u0003F\u0006)Q\rZ5ugB)\u0011Ia2\u0003p%\u0019!\u0011\u001a\"\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0006\u0003\u0003<\n5\u0007b\u0002BhO\u0001\u0007!\u0011[\u0001\nK\u0012LGo\u001d'jgR\u0004b!a\u0014\u0002Z\t=\u0014\u0001\u00043p'\u00064XmT;uaV$HCCAi\u0005/\u0014INa7\u0003^\"9\u0011Q\u0011\u0015A\u0002\u0005\u001d\u0002bBA\u007fQ\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003_D\u0003\u0019AAj\u0011\u001d\u0011)\f\u000ba\u0001\u0003#\u000b\u0001b\\;uaV$xJ\u001a\u000b\u0007\u0003'\u0014\u0019O!:\t\u000f\u0005=\u0018\u00061\u0001\u0002T\"9\u0011Q`\u0015A\u0002\u0005E\u0015aB5oaV$xJ\u001a\u000b\u0007\u0003'\u0014YO!<\t\u000f\u0005=(\u00061\u0001\u0002T\"9!q\u001e\u0016A\u0002\u0005E\u0015!C5oaV$h*Y7f\u0003=9W\r\u001e,be&\f'\r\\3QCRDG\u0003BAI\u0005kDqAa>,\u0001\u0004\t\t*\u0001\u0005gS2,g*Y7f\u0003Iqw\u000e^5gs\u0006cGnU2f]\u0006\u0014\u0018n\\:\u0015\u0007]\u0014i\u0010C\u0004\u0003\u00002\u0002\ra!\u0001\u0002\u0005Y4\u0007c\u00010\u0004\u0004%\u00191QA0\u0003\u0017YK'\u000f^;bY\u001aKG.\u001a\u000b\u0004o\u000e%\u0001bBAC[\u0001\u0007\u0011qE\u0001\u001c/\u0016\fg/Z*dK:\f'/[8NC:\fw-\u001a:TKJ4\u0018nY3\u0011\u0005\u001d{3CA\u0018A)\t\u0019i!A\u0007E\u000b\u001a\u000bU\u000b\u0014+`\u0013:\u0003V\u000bV\u000b\u0003\u0007/\u0001Ba!\u0007\u0004 5\u001111\u0004\u0006\u0005\u0007;\t)&\u0001\u0003mC:<\u0017\u0002BAR\u00077\ta\u0002R#G\u0003VcEkX%O!V#\u0006\u0005")
public class WeaveScenarioManagerService
implements ToolingService {
    private final DataWeaveToolingService dataWeaveToolingService;
    private final WorkspaceEditService workspaceEditsService;
    public final DataWeaveProtocolClient org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient;
    private final VirtualFileSystem virtualFileSystem;
    private InternalEventBus eventBus;
    private ProjectKind projectKind;
    private final HashMap<NameIdentifier, Scenario> activeScenarios;

    public static String DEFAULT_INPUT() {
        return WeaveScenarioManagerService$.MODULE$.DEFAULT_INPUT();
    }

    public VirtualFileSystem virtualFileSystem() {
        return this.virtualFileSystem;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private HashMap<NameIdentifier, Scenario> activeScenarios() {
        return this.activeScenarios;
    }

    private List<WeaveScenario> mapScenarios(Option<Scenario> maybeActiveScenario, Scenario[] allScenarios) {
        String defaultScenarioName = (String)maybeActiveScenario.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        WeaveScenario[] scenarios = (WeaveScenario[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allScenarios)).map((Function1 & Serializable & scala.Serializable)scenario -> {
            SampleInput[] inputsList = scenario.inputs();
            String expectedOrNull = (String)scenario.expected().map((Function1 & Serializable & scala.Serializable)file -> URLUtils$.MODULE$.toLSPUrl((File)file)).orNull(Predef$.MODULE$.$conforms());
            return new WeaveScenario(Predef$.MODULE$.boolean2Boolean(scenario.name().equals(defaultScenarioName)), scenario.name(), URLUtils$.MODULE$.toLSPUrl(scenario.file()), inputsList, expectedOrNull);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveScenario.class)));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).toList()).asJava();
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.eventBus_$eq(eventBus);
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this, projectKind){
            private final /* synthetic */ WeaveScenarioManagerService $outer;
            private final ProjectKind projectKind$1;

            public void onDocumentFocused(VirtualFile vf) {
                boolean isPartOfTheTestResources;
                File[] resources = WeaveDirectoryUtils$.MODULE$.wtfResourcesTestFolder(this.projectKind$1.structure());
                boolean bl = isPartOfTheTestResources = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onDocumentFocused$1(vf, f)));
                if (VFUtils$.MODULE$.isSupportedEditableScheme(vf.url()) && isPartOfTheTestResources) {
                    this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$notifyAllScenarios(vf);
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient.showScenarios(null);
            }

            public static final /* synthetic */ boolean $anonfun$onDocumentFocused$1(VirtualFile vf$1, File f) {
                return URLUtils$.MODULE$.isChildOf(vf$1.url(), f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onDocumentFocused$1$adapted(org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(DocumentClosedEvent$.MODULE$.DOCUMENT_CLOSED(), new OnDocumentClosed(this){
            private final /* synthetic */ WeaveScenarioManagerService $outer;

            public void onDocumentClosed(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient.showScenarios(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Scenario[] listScenarios(NameIdentifier nameIdentifier) {
        return this.projectKind().sampleDataManager().listScenarios(nameIdentifier);
    }

    public Option<Scenario> searchScenarioByName(NameIdentifier nameIdentifier, String scenarioName) {
        return this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, scenarioName);
    }

    public Option<Scenario> activeScenario(NameIdentifier nameIdentifier) {
        return this.activeScenarios().get((Object)nameIdentifier).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Scenario[] scenarios = this.listScenarios(nameIdentifier);
            if (scenarios != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).nonEmpty()) {
                Option maybeFirstScenario = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$activeScenario$2(s))).orElse((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).headOption());
                maybeFirstScenario.foreach((Function1 & Serializable & scala.Serializable)scenario -> this.activeScenarios().put((Object)nameIdentifier, scenario));
                return maybeFirstScenario;
            }
            return None$.MODULE$;
        });
    }

    public void copyScenarioTo(NameIdentifier mappingIdentifier, Scenario oldScenario, String scenarioName) {
        SampleInput[] inputs = oldScenario.inputs();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).isEmpty()) {
            this.createScenario(mappingIdentifier, scenarioName, WeaveScenarioManagerService$.MODULE$.DEFAULT_INPUT(), (Option<String>)None$.MODULE$, this.createScenario$default$5());
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).foreach((Function1 & Serializable & scala.Serializable)input -> URLUtils$.MODULE$.toFile(input.uri()).map((Function1 & Serializable & scala.Serializable)oldInputFile -> {
            String inputName = new StringBuilder(1).append(input.name()).append(".").append(FilenameUtils.getExtension((String)oldInputFile.getName())).toString();
            String content = FileUtils.readFileToString((File)oldInputFile, (Charset)Charset.defaultCharset());
            return this.createScenario(mappingIdentifier, scenarioName, inputName, (Option<String>)new Some((Object)content), (Option<String>)None$.MODULE$);
        }));
    }

    public void setActiveScenario(NameIdentifier nameIdentifier, String nameOfTheScenario) {
        Option maybeScenario = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().sampleDataManager().listScenarios(nameIdentifier))).find((Function1 & Serializable & scala.Serializable)scenario -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$setActiveScenario$1(nameOfTheScenario, scenario)));
        maybeScenario.foreach((Function1 & Serializable & scala.Serializable)s -> {
            WeaveScenarioManagerService.$anonfun$setActiveScenario$2(this, nameIdentifier, s);
            return BoxedUnit.UNIT;
        });
        Iterator virtualFiles = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.virtualFileSystem().listFiles()).asScala();
        virtualFiles.find((Function1 & Serializable & scala.Serializable)vf -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$setActiveScenario$3(nameIdentifier, vf))).foreach((Function1 & Serializable & scala.Serializable)vf -> {
            WeaveScenarioManagerService.$anonfun$setActiveScenario$4(this, vf);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteScenario(NameIdentifier nameIdentifier, String nameOfTheScenario) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1 & Serializable & scala.Serializable)s -> {
            WeaveScenarioManagerService.$anonfun$deleteScenario$1(s);
            return BoxedUnit.UNIT;
        });
        this.activeScenarios().get((Object)nameIdentifier).foreach((Function1 & Serializable & scala.Serializable)activeScenario -> {
            String string = activeScenario.name();
            String string2 = nameOfTheScenario;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.activeScenarios().remove((Object)nameIdentifier);
            }
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public Option<File> createOrUpdateMappingTest(NameIdentifier nameIdentifier, String scenarioName, String mimeType) {
        Option<Scenario> maybeScenario = this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, scenarioName);
        Option maybeFile = maybeScenario.flatMap((Function1 & Serializable & scala.Serializable)scenario -> this.doSaveTest(nameIdentifier, (Scenario)scenario, mimeType));
        return maybeFile;
    }

    private Option<File> doSaveTest(NameIdentifier nameIdentifier, Scenario scenario, String mimeType) {
        File testFile = new File(WeaveDirectoryUtils$.MODULE$.wtfUnitDefaultTestSourceFolder(this.projectKind().structure())[0], new StringBuilder(9).append(WeaveDirectoryUtils$.MODULE$.toFolderName((NameIdentifier)nameIdentifier.parent().getOrElse((Function0 & Serializable & scala.Serializable)() -> new NameIdentifier("", NameIdentifier$.MODULE$.apply$default$2())))).append("/").append(nameIdentifier.localName()).append("Test.dwl").toString());
        String scenarioTemplate = StringHelper$.MODULE$.toStringTransformer(new StringBuilder(157).append("\n         |    \"Assert ").append(scenario.name()).append("\" in do {\n         |        evalPath(\"").append(new StringOps(Predef$.MODULE$.augmentString(NameIdentifierHelper$.MODULE$.toWeaveFilePath(nameIdentifier, "/"))).drop(1)).append("\", inputsFrom(\"").append(WeaveDirectoryUtils$.MODULE$.toFolderName(nameIdentifier)).append("/").append(scenario.name()).append("\"),\"").append(mimeType).append("\") must\n         |                  equalTo(outputFrom(\"").append(WeaveDirectoryUtils$.MODULE$.toFolderName(nameIdentifier)).append("/").append(scenario.name()).append("\"))\n         |    }").toString()).stripMarginAndNormalizeEOL();
        String testTemplate = StringHelper$.MODULE$.toStringTransformer(new StringBuilder(155).append("%dw ").append(this.projectKind().getWeaveVersion()).append("\n         |import * from dw::test::Tests\n         |import * from dw::test::Asserts\n         |---\n         |\"Test ").append(nameIdentifier.name()).append("\" describedBy [").append(scenarioTemplate).append("\n         |]\n         |").toString()).stripMarginAndNormalizeEOL();
        if (testFile.exists()) {
            return this.appendScenarioToExistingTest$1(testFile, scenarioTemplate, nameIdentifier);
        }
        return this.createTestWithFirstScenario$1(testFile, testTemplate, nameIdentifier);
    }

    public Option<File> saveOutput(NameIdentifier nameIdentifier, String nameOfTheScenario, String outputName, String newContent) {
        Option<Scenario> maybeScenario = this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario);
        Option maybeFile = maybeScenario.flatMap((Function1 & Serializable & scala.Serializable)scenario -> this.doSaveOutput(nameIdentifier, outputName, scenario.file(), newContent));
        return maybeFile;
    }

    public void deleteOutput(NameIdentifier nameIdentifier, String nameOfTheScenario, String outputUrl) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            WeaveScenarioManagerService.$anonfun$deleteOutput$1(outputUrl, x$4);
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public void deleteInput(NameIdentifier nameIdentifier, String nameOfTheScenario, String inputUrl) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            WeaveScenarioManagerService.$anonfun$deleteInput$1(inputUrl, x$5);
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public Option<File> createScenario(NameIdentifier nameIdentifier, String nameOfTheScenario, String inputFileName, Option<String> maybeInputContent, Option<String> uri) {
        File sampleContainer = this.sampleDataFolder(nameIdentifier, uri);
        File scenario = this.scenarioOf(sampleContainer, nameOfTheScenario);
        Option content = maybeInputContent.orElse((Function0 & Serializable & scala.Serializable)() -> InputScaffoldingFactory$.MODULE$.create(inputFileName).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.template()));
        return this.doCreateInput(nameIdentifier, inputFileName, (Option<String>)content, scenario);
    }

    public Option<String> createScenario$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createScenario$default$5() {
        return None$.MODULE$;
    }

    public File sampleDataFolder(NameIdentifier nameIdentifier, Option<String> uri) {
        SampleDataComponent sampleDataManager = this.projectKind().sampleDataManager();
        File sampleDataFolder = sampleDataManager.createSampleDataFolderFor(nameIdentifier, uri);
        return sampleDataFolder;
    }

    public Option<String> sampleDataFolder$default$2() {
        return None$.MODULE$;
    }

    public File scenarioOf(File sampleContainer, String nameOfTheScenario) {
        return new File(sampleContainer, nameOfTheScenario);
    }

    public Option<File> doCreateInput(NameIdentifier nameIdentifier, String inputFileName, Option<String> maybeInputContent, File scenario) {
        Object object;
        File inputFile = this.inputOf(scenario, inputFileName);
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> edits = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>();
        edits.add(this.createFileCmd(inputFile));
        if (maybeInputContent.isDefined()) {
            String content = (String)maybeInputContent.get();
            Position pos = new Position(0, 0);
            object = BoxesRunTime.boxToBoolean((boolean)edits.add(this.editFileCmd(inputFile, pos, pos, content)));
        } else {
            object = BoxedUnit.UNIT;
        }
        ApplyWorkspaceEditResponse response = this.applyEdits(edits);
        this.notifyAllScenarios(nameIdentifier);
        if (response.isApplied()) {
            return new Some((Object)inputFile);
        }
        return None$.MODULE$;
    }

    private Either<TextDocumentEdit, ResourceOperation> deleteFileCmd(File destinationFile) {
        String destinationFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        Either createFile = Either.forRight((Object)new DeleteFile(destinationFileUrl));
        return createFile;
    }

    private Either<TextDocumentEdit, ResourceOperation> createFileCmd(File destinationFile) {
        String destinationFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        Either createFile = Either.forRight((Object)new CreateFile(destinationFileUrl));
        return createFile;
    }

    private Either<TextDocumentEdit, ResourceOperation> editFileCmd(File destinationFile, Position startPos, Position endPos, String newText) {
        String outputFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        TextEdit textEdit = new TextEdit(new Range(startPos, endPos), newText);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(outputFileUrl, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        Either editFile = Either.forLeft((Object)textDocumentEdit);
        return editFile;
    }

    private ApplyWorkspaceEditResponse applyEdits(Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        List<Object> editsList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        return this.applyEdits(editsList);
    }

    private ApplyWorkspaceEditResponse applyEdits(List<Either<TextDocumentEdit, ResourceOperation>> editsList) {
        return this.workspaceEditsService.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editsList))).get();
    }

    private Option<File> doSaveOutput(NameIdentifier nameIdentifier, String outputName, File scenario, String newText) {
        ApplyWorkspaceEditResponse result;
        File outputFile = this.outputOf(scenario, outputName);
        Position docStart = new Position(0, 0);
        if (outputFile.exists() && !(result = this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.deleteFileCmd(outputFile)}))).isApplied()) {
            return None$.MODULE$;
        }
        ApplyWorkspaceEditResponse response = this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.createFileCmd(outputFile), this.editFileCmd(outputFile, docStart, docStart, newText)}));
        if (response.isApplied()) {
            this.notifyAllScenarios(nameIdentifier);
            return new Some((Object)outputFile);
        }
        return None$.MODULE$;
    }

    private File outputOf(File scenario, String outputName) {
        return new File(scenario, outputName);
    }

    public File inputOf(File scenario, String inputName) {
        File inputs = WeaveDirectoryUtils$.MODULE$.inputsFolder(scenario);
        return new File(inputs, this.getVariablePath(inputName));
    }

    private String getVariablePath(String fileName) {
        String theBaseName = FilenameUtils.getBaseName((String)fileName);
        String extension = FilenameUtils.getExtension((String)fileName);
        String variablePath = new StringBuilder(1).append(theBaseName.replace('.', File.separatorChar)).append(".").append(extension).toString();
        return variablePath;
    }

    public void org$mule$weave$lsp$services$WeaveScenarioManagerService$$notifyAllScenarios(VirtualFile vf) {
        this.notifyAllScenarios(vf.getNameIdentifier());
    }

    private void notifyAllScenarios(NameIdentifier nameIdentifier) {
        Option<Scenario> maybeActiveScenario = this.activeScenario(nameIdentifier);
        Scenario[] allScenarios = this.projectKind().sampleDataManager().listScenarios(nameIdentifier);
        this.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient.showScenarios(new ShowScenariosParams(nameIdentifier.toString(), this.mapScenarios(maybeActiveScenario, allScenarios)));
    }

    public static final /* synthetic */ boolean $anonfun$activeScenario$2(Scenario s) {
        return s.name().equals(Scenario$.MODULE$.PLAYGROUND_SCENARIO());
    }

    public static final /* synthetic */ boolean $anonfun$setActiveScenario$1(String nameOfTheScenario$1, Scenario scenario) {
        return scenario.name().equals(nameOfTheScenario$1);
    }

    public static final /* synthetic */ void $anonfun$setActiveScenario$2(WeaveScenarioManagerService $this, NameIdentifier nameIdentifier$2, Scenario s) {
        $this.activeScenarios().put((Object)nameIdentifier$2, (Object)s);
        $this.notifyAllScenarios(nameIdentifier$2);
    }

    public static final /* synthetic */ boolean $anonfun$setActiveScenario$3(NameIdentifier nameIdentifier$2, VirtualFile vf) {
        return vf.getNameIdentifier().equals((Object)nameIdentifier$2);
    }

    public static final /* synthetic */ void $anonfun$setActiveScenario$4(WeaveScenarioManagerService $this, VirtualFile vf) {
        $this.eventBus().fire(new ActiveScenarioChangedEvent(vf));
    }

    public static final /* synthetic */ void $anonfun$deleteScenario$1(Scenario s) {
        FileUtils.deleteDirectory((File)s.file());
    }

    public static final /* synthetic */ boolean $anonfun$doSaveTest$4(AstNode x0$1) {
        AstNode astNode = x0$1;
        if (astNode instanceof FunctionCallNode) {
            String string;
            VariableReferenceNode variableReferenceNode;
            NameIdentifier nameIdentifier;
            FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
            AstNode astNode2 = functionCallNode.function();
            FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
            if (astNode2 instanceof VariableReferenceNode && (nameIdentifier = (variableReferenceNode = (VariableReferenceNode)astNode2).variable()) != null && "describedBy".equals(string = nameIdentifier.name()) && functionCallParametersNode != null) {
                return true;
            }
        }
        return false;
    }

    private final Option appendScenarioToExistingTest$1(File testFile$1, String scenarioTemplate$1, NameIdentifier nameIdentifier$5) {
        WeaveDocumentToolingService documentToolingService = this.dataWeaveToolingService.openDocument(URLUtils$.MODULE$.toLSPUrl(testFile$1));
        Option maybePosition = documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.astNode()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> AstNodeHelper$.MODULE$.find(x$3, (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$doSaveTest$4(x0$1))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AstNode astNode = x0$2;
            if (astNode instanceof FunctionCallNode) {
                ArrayNode arrayNode;
                AstNode array;
                Seq seq;
                Some some;
                String string;
                VariableReferenceNode variableReferenceNode;
                NameIdentifier nameIdentifier;
                FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
                AstNode astNode2 = functionCallNode.function();
                FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
                if (astNode2 instanceof VariableReferenceNode && (nameIdentifier = (variableReferenceNode = (VariableReferenceNode)astNode2).variable()) != null && "describedBy".equals(string = nameIdentifier.name()) && functionCallParametersNode != null && !(some = Seq$.MODULE$.unapplySeq(seq = functionCallParametersNode.args())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0 && (array = (AstNode)((SeqLike)some.get()).apply(1)) instanceof ArrayNode && (arrayNode = (ArrayNode)array).children().nonEmpty()) {
                    return new Some((Object)LSPConverters$.MODULE$.toPosition(((WeaveLocationCapable)arrayNode.children().last()).location().endPosition()));
                }
            }
            return None$.MODULE$;
        }));
        return maybePosition.flatMap((Function1 & Serializable & scala.Serializable)p -> {
            if (this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.editFileCmd(testFile$1, (Position)p, (Position)p, new StringBuilder(1).append(",").append(scenarioTemplate$1).toString())})).isApplied()) {
                this.notifyAllScenarios(nameIdentifier$5);
                return new Some((Object)testFile$1);
            }
            return None$.MODULE$;
        });
    }

    private final Option createTestWithFirstScenario$1(File testFile$1, String testTemplate$1, NameIdentifier nameIdentifier$5) {
        Position docStart = new Position(0, 0);
        ApplyWorkspaceEditResponse response = this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.createFileCmd(testFile$1), this.editFileCmd(testFile$1, docStart, docStart, testTemplate$1)}));
        if (response.isApplied()) {
            this.notifyAllScenarios(nameIdentifier$5);
            return new Some((Object)testFile$1);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$deleteOutput$1(String outputUrl$1, Scenario x$4) {
        URLUtils$.MODULE$.toFile(outputUrl$1).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public static final /* synthetic */ void $anonfun$deleteInput$1(String inputUrl$1, Scenario x$5) {
        URLUtils$.MODULE$.toFile(inputUrl$1).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public WeaveScenarioManagerService(DataWeaveToolingService dataWeaveToolingService, WorkspaceEditService workspaceEditsService, DataWeaveProtocolClient weaveLanguageClient, VirtualFileSystem virtualFileSystem) {
        this.dataWeaveToolingService = dataWeaveToolingService;
        this.workspaceEditsService = workspaceEditsService;
        this.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient = weaveLanguageClient;
        this.virtualFileSystem = virtualFileSystem;
        ToolingService.$init$(this);
        this.activeScenarios = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

