package org.mule.weave.dsp

import java.io.File

trait LauncherConfig {

  /**
   * The port that the launcher should use to specify the new process to listen for debugging
   *
   * @return The port
   */
  def debuggerPort: Int

  def buildBefore: Boolean = true

  def includeTests: Boolean = true

  /**
   * Indicates the this Launch Configuration is a Test Configuration
   *
   * @return
   */
  def testConfiguration: Boolean = false

}

case class RunMappingConfiguration(mayBeMapping: Option[String], scenario: Option[String], override val buildBefore: Boolean, debuggerPort: Int, runnerEnvVarFile: Option[File])
  extends LauncherConfig

/**
 * A WTF Configuration
 *
 * @param mayBeTests           The test name identifier to run
 * @param testToRun            The tests to run
 * @param buildBefore          If it should build before
 * @param debuggerPort         The debugger port
 * @param dryRun               If this test is a dry run
 * @param testConfiguration    If true it is mark as a test  run configuration and it will notifiy test to UI
 * @param dwTestFolder         The test folder
 * @param testRunnerEnvVarFile A file path with env vars
 */
case class RunWTFConfiguration(mayBeTests: Option[String], testToRun: Option[String], override val buildBefore: Boolean,
                               debuggerPort: Int, dryRun: Boolean = false, override val testConfiguration: Boolean = true,
                               dwTestFolder: Option[String], testRunnerEnvVarFile: Option[File])
  extends LauncherConfig

case class RunIntegrationTestsConfiguration(module: Boolean, mapping: Boolean, updateResult: Boolean, testToRun: Option[String], debuggerPort: Int)
  extends LauncherConfig
