package org.mule.weave.lsp.commands

import org.eclipse.lsp4j
import org.eclipse.lsp4j.Position
import org.eclipse.lsp4j.TextEdit
import org.mule.weave.lsp.utils.LSPConverters.toPosition
import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.editor.WeaveDocumentToolingService
import org.mule.weave.v2.editor.WeaveTextDocument

import java.util
import scala.collection.JavaConverters.seqAsJavaListConverter
import scala.collection.mutable

class LSPWeaveTextDocument(toolingService: WeaveDocumentToolingService) extends WeaveTextDocument {

  private val _edits: mutable.Map[Int, PositionEdit] = mutable.Map()

  override def runTemplate(template: Template, location: Int): Unit = {
    insert(template.toLiteralString, location)
  }

  override def insert(text: String, location: Int): Unit = {
    val position: Position = toPosition(toolingService.positionOf(location))
    val textEdit = new TextEdit(new lsp4j.Range(position, position), text)
    val edit = _edits.getOrElseUpdate(location, PositionEdit())
    edit.inserts = textEdit +: edit.inserts
  }

  override def delete(startLocation: Int, endLocation: Int): Unit = {
    val textEdit = new TextEdit()
    textEdit.setNewText("")
    val endPosition: Position = toPosition(toolingService.positionOf(endLocation))
    val startPosition: Position = toPosition(toolingService.positionOf(startLocation))
    textEdit.setRange(new org.eclipse.lsp4j.Range(startPosition, endPosition))
    val edit = _edits.getOrElseUpdate(startLocation, PositionEdit())
    edit.deletes = Some(textEdit)
  }

  override def text(startLocation: Int, endLocation: Int): String = {
    toolingService.file.read().substring(startLocation, endLocation)
  }


  def edits(): util.List[TextEdit] = _edits.toList.flatMap(entry => entry._2.textEdits()).asJava

  case class PositionEdit(var inserts: List[TextEdit] = List(), var deletes: Option[TextEdit] = None) {

    def textEdits(): List[TextEdit] = inserts ++ deletes.toList
  }
}
