/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.project.commands;

import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.mule.weave.lsp.project.commands.ProjectCreationInfo;
import org.mule.weave.lsp.project.commands.ProjectCreator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0001E!)!\u0007\u0001C\u0005g!)\u0011\t\u0001C\u0005\u0005\n)B)\u001a4bk2$\bK]8kK\u000e$8I]3bi>\u0014(BA\u0004\t\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0005\u000b\u0003\u001d\u0001(o\u001c6fGRT!a\u0003\u0007\u0002\u00071\u001c\bO\u0003\u0002\u000e\u001d\u0005)q/Z1wK*\u0011q\u0002E\u0001\u0005[VdWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\u0004\n\u0005u1!A\u0004)s_*,7\r^\"sK\u0006$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\r\r\u0014X-\u0019;f)\t\u0019S\u0006\u0005\u0002%W5\tQE\u0003\u0002'O\u0005!a-\u001b7f\u0015\tA\u0013&A\u0002oS>T\u0011AK\u0001\u0005U\u00064\u0018-\u0003\u0002-K\t!\u0001+\u0019;i\u0011\u0015q#\u00011\u00010\u0003-\u0001(o\u001c6fGRLeNZ8\u0011\u0005m\u0001\u0014BA\u0019\u0007\u0005M\u0001&o\u001c6fGR\u001c%/Z1uS>t\u0017J\u001c4p\u0003M9W\r\u001e*fg>,(oY3BgN#(/\u001b8h)\t!t\b\u0005\u00026y9\u0011aG\u000f\t\u0003oYi\u0011\u0001\u000f\u0006\u0003sI\ta\u0001\u0010:p_Rt\u0014BA\u001e\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m2\u0002\"\u0002!\u0004\u0001\u0004!\u0014\u0001\u0003:fg>,(oY3\u0002\u0013]\u0014\u0018\u000e^3GS2,GcA\"G\u0011B\u0011Q\u0003R\u0005\u0003\u000bZ\u0011A!\u00168ji\")q\t\u0002a\u0001G\u0005\t\u0001\u000fC\u0003J\t\u0001\u0007A'A\u0004d_:$XM\u001c;")
public class DefaultProjectCreator
implements ProjectCreator {
    @Override
    public Path create(ProjectCreationInfo projectInfo) {
        Path projectPath;
        block1: {
            projectPath = projectInfo.pathToCreate().resolve(projectInfo.projectName());
            if (projectInfo.failIfPresent() && projectPath.toFile().exists()) {
                throw new RuntimeException(new StringBuilder(24).append("Project already exists: ").append(projectPath).toString());
            }
            Files.createDirectories(projectPath, new FileAttribute[0]);
            String replacedPom = this.getResourceAsString("pom-default.xml").replaceAll("@group-id@", projectInfo.groupId()).replaceAll("@artifact-id@", projectInfo.artifactId()).replaceAll("@version@", projectInfo.version()).replaceAll("@project-name@", projectInfo.projectName());
            this.writeFile(projectPath.resolve("pom.xml"), replacedPom);
            Path sourcePath = projectPath.resolve("src");
            Path mainPath = sourcePath.resolve("main");
            Path mainDwPath = mainPath.resolve("dw");
            Path dwModulePath = mainDwPath.resolve("MyModule.dwl");
            Path mainResourcesPath = mainPath.resolve("resources");
            Path testPath = sourcePath.resolve("test");
            Path testDwPath = testPath.resolve("dw");
            Path dwMappingPath = testDwPath.resolve("MyMapping.dwl");
            Path testResourcesPath = testPath.resolve("resources");
            Files.createDirectories(mainDwPath, new FileAttribute[0]);
            Files.createDirectories(mainResourcesPath, new FileAttribute[0]);
            Files.createDirectories(testDwPath, new FileAttribute[0]);
            Files.createDirectories(testResourcesPath, new FileAttribute[0]);
            if (!projectInfo.createExampleFiles()) break block1;
            String exampleDwModule = this.getResourceAsString("dw-template-project-module.dwl");
            String exampleDwMapping = this.getResourceAsString("dw-template-project-mapping.dwl");
            this.writeFile(dwModulePath, exampleDwModule);
            this.writeFile(dwMappingPath, exampleDwMapping);
        }
        return projectPath;
    }

    private String getResourceAsString(String resource) {
        InputStream source = this.getClass().getClassLoader().getResourceAsStream(resource);
        return new String(source.readAllBytes(), StandardCharsets.UTF_8);
    }

    private void writeFile(Path p, String content) {
        try (FileWriter writer = new FileWriter(p.toFile());){
            writer.write(content);
        }
    }
}

