package org.mule.weave.lsp.project

import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.project.WeaveArtifacts.createWeaveArtifactId

trait MavenArtifactIdResolver {
  def artifactName(project: ProjectMetadata): String
}

object RuntimeArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("runtime", project.settings.wlangVersion.value())
  }
}

object CoreModulesArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("core-modules", project.settings.wlangVersion.value())
  }
}

object YamlModuleArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("yaml-module", project.settings.wlangVersion.value())
  }
}

object JavaModuleArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("java-module", project.settings.wlangVersion.value())
  }
}

object NDJsonModuleArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("ndjson-module", project.settings.wlangVersion.value())
  }
}

object FileModuleArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("file-module", project.settings.wlangVersion.value())
  }
}

object HttpModuleArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("http-netty-module", project.settings.wlangVersion.value())
  }
}

object ProcessModuleArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    createWeaveArtifactId("process-module", project.settings.wlangVersion.value())
  }
}

object BATArtifactIdResolver extends MavenArtifactIdResolver {
  override def artifactName(project: ProjectMetadata): String = {
    "com.mulesoft.bat:bdd-core:" + project.settings.batVersion.value()
  }
}

object WeaveArtifacts {


  val BASIC_MODULES: Array[MavenArtifactIdResolver] = Array(RuntimeArtifactIdResolver, CoreModulesArtifactIdResolver, NDJsonModuleArtifactIdResolver, YamlModuleArtifactIdResolver)

  val BASIC_WITH_JAVA_MODULES: Array[MavenArtifactIdResolver] = BASIC_MODULES :+ JavaModuleArtifactIdResolver

  val BAT_MODULES: Array[MavenArtifactIdResolver] = BASIC_MODULES :+ BATArtifactIdResolver

  val NATIVE_MODULES: Array[MavenArtifactIdResolver] = BASIC_MODULES ++ Array(FileModuleArtifactIdResolver, HttpModuleArtifactIdResolver, ProcessModuleArtifactIdResolver)

  def createWeaveArtifactId(module: String, version: String): String = {
    s"org.mule.weave:${module}:${version}"
  }
}

