/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.PreviewService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.v2.editor.VirtualFile;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0003\u0006\u0001+!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u0015\t\u0005\u0001\"\u0011C\u0011\u0015\t\u0006\u0001\"\u00114\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015)\u0006\u0001\"\u0011W\u0005a)e.\u00192mKB\u0013XM^5fo6{G-Z\"p[6\fg\u000e\u001a\u0006\u0003\u00171\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u001b9\t1\u0001\\:q\u0015\ty\u0001#A\u0003xK\u00064XM\u0003\u0002\u0012%\u0005!Q.\u001e7f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011c\u0001\u0001\u0017=A\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0005Y\u0006twMC\u0001\u001c\u0003\u0011Q\u0017M^1\n\u0005uA\"AB(cU\u0016\u001cG\u000f\u0005\u0002 A5\t!\"\u0003\u0002\"\u0015\t!\u0012J\u001c;fe:\fGnV3bm\u0016\u001cu.\\7b]\u0012\fqc^8sWN\u0004\u0018mY3TKJ4\u0018nY3NC:\fw-\u001a:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019b\u0011\u0001C:feZL7-Z:\n\u0005!*#aF,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0003%)\u0018jU3sm&\u001cW\r\u0005\u0002%W%\u0011A&\n\u0002\n+&\u001bVM\u001d<jG\u0016\fa\u0001P5oSRtDcA\u00181cA\u0011q\u0004\u0001\u0005\u0006E\r\u0001\ra\t\u0005\u0006S\r\u0001\rAK\u0001\nG>lW.\u00198e\u0013\u0012$\u0012\u0001\u000e\t\u0003kyr!A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\"\u0012A\u0002\u001fs_>$hHC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f;\u0003\u001d)\u00070Z2vi\u0016$\"aQ$\u0011\u0005\u0011+U\"\u0001\u001e\n\u0005\u0019S$AB!osJ+g\rC\u0003I\u000b\u0001\u0007\u0011*\u0001\u0004qCJ\fWn\u001d\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bQ\u0001\\:qi)T!A\u0014\n\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011\u0001k\u0013\u0002\u0015\u000bb,7-\u001e;f\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u0002\t9\fW.Z\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0006\u00025)\")\u0001j\u0002a\u0001\u0013\u00069QM\\1cY\u0016$GCA,[!\t!\u0005,\u0003\u0002Zu\t9!i\\8mK\u0006t\u0007\"B.\t\u0001\u0004!\u0014aA;sS\u0002")
public class EnablePreviewModeCommand
implements InternalWeaveCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final UIService uIService;

    public String commandId() {
        return Commands$.MODULE$.DW_ENABLE_PREVIEW();
    }

    public Object execute(ExecuteCommandParams params) {
        Object object;
        boolean enabled = Commands$.MODULE$.argAsBoolean(params.getArguments(), 0);
        String uri = Commands$.MODULE$.argAsString(params.getArguments(), 1);
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            ProjectKind projectKind = (ProjectKind)maybeProjectKind.get();
            PreviewService previewService = projectKind.toolingService(PreviewService.class);
            if (enabled) {
                previewService.enable();
                VirtualFile file = projectKind.vfs().file(uri);
                object = file != null ? previewService.scheduleRunPreview(file, previewService.scheduleRunPreview$default$2()) : BoxedUnit.UNIT;
            } else {
                previewService.disable();
                object = BoxedUnit.UNIT;
            }
        } else {
            this.uIService.showMessage(new MessageParams(MessageType.Error, new StringBuilder(50).append("No project is associated to: ").append(uri).append(". ").append(this.commandId()).append(" cannot be executed").toString()));
            object = BoxedUnit.UNIT;
        }
        return null;
    }

    public String name() {
        return "Enables Preview.";
    }

    public String description(ExecuteCommandParams params) {
        return "Enables preview.";
    }

    @Override
    public boolean enabled(String uri) {
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            ProjectKind projectKind = (ProjectKind)maybeProjectKind.get();
            return projectKind.toolingService(PreviewService.class).canRunPreview(projectKind.toolingService(ProjectFileSystemService.class).file(uri));
        }
        return false;
    }

    public EnablePreviewModeCommand(WorkspaceServiceManager workspaceServiceManager, UIService uIService) {
        this.workspaceServiceManager = workspaceServiceManager;
        this.uIService = uIService;
        InternalWeaveCommand.$init$(this);
    }
}

