package org.mule.weave.lsp.services

import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.eclipse.lsp4j.services.LanguageClient

import java.io.PrintWriter
import java.io.StringWriter

/**
 * Handles the logging to the client
 */
class ClientLogger(_client: LanguageClient, component: String = "") {

  def logDebug(message: String): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Log, buildMessage(message)))
    }
  }

  private def buildMessage(message: String) = {
    if (component.isBlank)
      message
    else
      s"[${component}] " + message
  }

  def logDebug(message: String, throwable: Throwable): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Log, buildMessage(message) + " caused by:\n" + toStringStacktrace(throwable)))
    }
  }

  def logInfo(message: String): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Info, buildMessage(message)))
    }
  }

  def logInfo(message: String, throwable: Throwable): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Info, buildMessage(message) + " caused by:\n" + toStringStacktrace(throwable)))
    }
  }

  def logWarning(message: String): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Warning, buildMessage(message)))
    }
  }

  def logWarning(message: String, throwable: Throwable): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Warning, buildMessage(message) + " caused by:\n" + toStringStacktrace(throwable)))
    }
  }

  def logError(message: String): Unit = {
    if (_client != null) {
      _client.logMessage(new MessageParams(MessageType.Error, buildMessage(message)))
    }
  }

  def logError(message: String, throwable: Throwable): Unit = {
    if (_client != null) {
      val stackTrace: String = toStringStacktrace(throwable)
      _client.logMessage(new MessageParams(MessageType.Error, buildMessage(message) + " caused by:\n" + stackTrace))
    }
  }

  private def toStringStacktrace(throwable: Throwable) = {
    val stringWriter = new StringWriter()
    throwable.printStackTrace(new PrintWriter(stringWriter))
    val stackTrace = stringWriter.toString
    stackTrace
  }
}
