package org.mule.weave.lsp.services

import org.mule.weave.extension.api.extension.validation.MessageValidationCollector
import org.mule.weave.v2.api.tooling.location.Location
import org.mule.weave.v2.api.tooling.location.Position
import org.mule.weave.v2.api.tooling.message.ValidationMessage
import org.mule.weave.v2.editor.ValidationMessages
import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageCategory
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.SimpleParserPosition
import org.mule.weave.v2.parser.location.WeaveLocation

import scala.collection.mutable

case class MessageValidationCollectorAdapter(messageCategory: MessageCategory) extends MessageValidationCollector {
  private val errorMessage: mutable.ArrayBuffer[org.mule.weave.v2.editor.ValidationMessage] = mutable.ArrayBuffer()
  private val warningMessage: mutable.ArrayBuffer[org.mule.weave.v2.editor.ValidationMessage] = mutable.ArrayBuffer()

  override def addErrorValidationMessage(message: ValidationMessage): MessageValidationCollector = {
    errorMessage += asWeaveValidationMessage(message)
    this
  }

  override def addWarningValidationMessage(message: ValidationMessage): MessageValidationCollector = {
    warningMessage += asWeaveValidationMessage(message)
    this
  }

  def getValidationMessages: ValidationMessages = ValidationMessages(errorMessage = errorMessage.toArray, warningMessage = warningMessage.toArray)

  private def asWeaveValidationMessage(message: ValidationMessage, quickFix: Array[org.mule.weave.v2.editor.QuickFix] = Array()) = {
    org.mule.weave.v2.editor.ValidationMessage(asWeaveLocation(message.getLocation), Message(message.getMessage.getKind, message.getMessage.getMessage, messageCategory), quickFix)
  }

  private def asWeaveLocation(location: Location): WeaveLocation =
    WeaveLocation(asWeavePosition(location.getStartPosition), asWeavePosition(location.getEndPosition),
      NameIdentifier(location.getResourceIdentifier.getFQNIdentifier))

  private def asWeavePosition(position: Position): org.mule.weave.v2.parser.location.Position =
    SimpleParserPosition(
      position.getIndex,
      position.getLine,
      position.getColumn,
      () => position.getSource)
}
