package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.lsp.vfs.ArtifactVirtualFileSystem
import org.mule.weave.lsp.vfs.events.LibrariesRemovedEvent.LIBRARIES_REMOVED

class LibrariesRemovedEvent(libraries: Array[ArtifactVirtualFileSystem]) extends InternalEvent {
  override type T = OnLibrariesRemoved

  override def getType: InternalEventType[OnLibrariesRemoved] = {
    LIBRARIES_REMOVED
  }

  override def dispatch(handler: OnLibrariesRemoved): Unit = {
    handler.onLibrariesRemoved(libraries)
  }
}

object LibrariesRemovedEvent {
  val LIBRARIES_REMOVED: InternalEventType[OnLibrariesRemoved] = InternalEventType[OnLibrariesRemoved]("LIBRARY_REMOVED")
}

trait OnLibrariesRemoved extends InternalEventHandler {
  def onLibrariesRemoved(libraries: Array[ArtifactVirtualFileSystem])
}
