package org.mule.weave.lsp.utils

import org.mule.weave.lsp.utils.URLUtils.toURI
import org.mule.weave.lsp.vfs.FileVirtualFile
import org.mule.weave.v2.editor.VirtualFile
import org.mule.weave.v2.editor.VirtualFileSystem
import org.mule.weave.v2.utils.WeaveFile

import java.io.File
import java.nio.file.Files
import java.util.stream
import scala.collection.JavaConverters.asScalaIteratorConverter

/**
 * Helper class to work with Virtual File System
 */
object VFUtils {
  private val JAR_SCHEMA = "jar"
  private val PREVIEW_SCHEMA = "preview"

  val DWL_EXTENSION: String = WeaveFile.fileExtension

  def listFiles(folder: File, virtualFileSystem: VirtualFileSystem): Iterator[VirtualFile] = {
    if (!folder.exists()) {
      Iterator.empty
    } else {
      val value: stream.Stream[VirtualFile] = Files.walk(folder.toPath)
        .filter((f) => f.toFile.isFile && f.toFile.canRead && !f.toFile.isHidden)
        .map((f) => new FileVirtualFile(f.toFile, virtualFileSystem, folder))
      value
        .iterator().asScala
    }
  }

  def isDWFile(uri: String): Boolean = {
    uri.endsWith(DWL_EXTENSION)
  }

  def isSupportedEditableScheme(uri: String): Boolean = {
    toURI(uri)
      .exists(uri => {
        val scheme: String = uri.getScheme
        scheme != JAR_SCHEMA && scheme != PREVIEW_SCHEMA
      })
  }

}
