package org.mule.weave.lsp.extension.protocol

import org.eclipse.lsp4j.jsonrpc.services.JsonRequest

import java.util
import java.util.concurrent.CompletableFuture


trait DataWeaveProtocolService {

  def getClient(): DataWeaveProtocolClient

  @JsonRequest("weave/agent/executeTool")
  def executeTool(params: ExecuteToolRequest): CompletableFuture[ExecuteToolResult]

  @JsonRequest("weave/agent/listTools")
  def listTools(): CompletableFuture[ListToolResult]
}

case class ExecuteToolRequest(toolName: String, toolArgs: util.Map[String, AnyRef])

case class ExecuteToolResult(messages: Array[String], success: Boolean)

case class ListToolResult(tools: Array[ToolMetadata])

case class ToolMetadata(name: String, description: ToolDescription)

case class ToolConfirmation(title: String, message: String)

case class ToolDescription(actionMessage: String, confirmation: ToolConfirmation)