package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent.VIRTUAL_FILE_CHANGED
import org.mule.weave.v2.editor.VirtualFile

class ProjectVirtualFileChangedEvent(vf: VirtualFile) extends InternalEvent {

  override type T = OnProjectVirtualFileChangedEvent
  
  override def getType: InternalEventType[OnProjectVirtualFileChangedEvent] = VIRTUAL_FILE_CHANGED

  override def dispatch(handler: OnProjectVirtualFileChangedEvent): Unit = {
    handler.onVirtualFileChanged(vf)
  }
}


object ProjectVirtualFileChangedEvent {
  val VIRTUAL_FILE_CHANGED: InternalEventType[OnProjectVirtualFileChangedEvent] = InternalEventType[OnProjectVirtualFileChangedEvent]("VIRTUAL_FILE_CHANGED")
}

trait OnProjectVirtualFileChangedEvent extends InternalEventHandler {
  def onVirtualFileChanged(vf: VirtualFile)
}