package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.AgentStoppedEvent.AGENT_STOPPED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class AgentStoppedEvent extends InternalEvent {
  override type T = OnAgentStopped

  override def getType: InternalEventType[OnAgentStopped] = AGENT_STOPPED

  override def dispatch(handler: OnAgentStopped): Unit = {
    handler.onAgentStopped()
  }
}

trait OnAgentStopped extends InternalEventHandler {
  def onAgentStopped(): Unit
}

object AgentStoppedEvent {
  val AGENT_STOPPED = InternalEventType[OnAgentStopped]("AGENT_STOPPED")
}