package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.DocumentClosedEvent.DOCUMENT_CLOSED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.v2.editor.VirtualFile

class DocumentClosedEvent(vf: VirtualFile) extends InternalEvent {
  override type T = OnDocumentClosed

  override def getType: InternalEventType[OnDocumentClosed] = DOCUMENT_CLOSED

  override def dispatch(handler: OnDocumentClosed): Unit = {
    handler.onDocumentClosed(vf)
  }
}

trait OnDocumentClosed extends InternalEventHandler {
  def onDocumentClosed(vf: VirtualFile): Unit
}

object DocumentClosedEvent {
  val DOCUMENT_CLOSED = InternalEventType[OnDocumentClosed]("DOCUMENT_CLOSED")
}