/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.SettingsChangedEvent;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor$;
import org.mule.weave.lsp.services.WorkspaceServiceContributor;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.indexing.IdentifierType$;
import org.mule.weave.v2.editor.indexing.LocatedResult;
import org.mule.weave.v2.editor.indexing.WeaveIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\t\u0013\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u00020\u0001\t\u0003y\u0006b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00025\t\u000b=\u0004A\u0011\u00029\t\u000by\u0004A\u0011I@\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\u000b\u0001\u0005B\u0005]s!CA1%\u0005\u0005\t\u0012AA2\r!\t\"#!A\t\u0002\u0005\u0015\u0004B\u00020\u000f\t\u0003\t9\u0007C\u0005\u0002j9\t\n\u0011\"\u0001\u0002l\t1C)\u001a4bk2$()Y:f/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\u001cuN\u001c;sS\n,Ho\u001c:\u000b\u0005M!\u0012\u0001C:feZL7-Z:\u000b\u0005U1\u0012a\u00017ta*\u0011q\u0003G\u0001\u0006o\u0016\fg/\u001a\u0006\u00033i\tA!\\;mK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005\u0011\u0012BA\u0014\u0013\u0005m9vN]6ta\u0006\u001cWmU3sm&\u001cWmQ8oiJL'-\u001e;pe\u0006Y\u0001O]8kK\u000e$8*\u001b8e!\tQS&D\u0001,\u0015\taC#A\u0004qe>TWm\u0019;\n\u00059Z#a\u0003)s_*,7\r^&j]\u0012\fq\u0002\u001d:pU\u0016\u001cG/T3uC\u0012\fG/\u0019\t\u0003UEJ!AM\u0016\u0003-\u0011+g-Y;miB\u0013xN[3di6+G/\u00193bi\u0006\f1c^3bm\u0016\u0004&o\u001c;pG>d7\t\\5f]R\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0011A\u0014x\u000e^8d_2T!!\u000f\u000b\u0002\u0013\u0015DH/\u001a8tS>t\u0017BA\u001e7\u0005]!\u0015\r^1XK\u00064X\r\u0015:pi>\u001cw\u000e\\\"mS\u0016tG/\u0001\bd_6l\u0017M\u001c3NC:\fw-\u001a:\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0012\u0001C2p[6\fg\u000eZ:\n\u0005\t{$!F\"p[6\fg\u000eZ'b]\u0006<WM]*feZL7-Z\u0001\u001c[\u0006L(-\u001a+fqR$unY;nK:$HK]1og2\fGo\u001c:\u0011\u0007})u)\u0003\u0002GA\t1q\n\u001d;j_:\u0004\"\u0001S.\u000f\u0005%CfB\u0001&V\u001d\tYEK\u0004\u0002M':\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!r\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\tId#\u0003\u0002W/\u0006\u0019\u0011\r]5\u000b\u0005e2\u0012BA-[\u0003i9V-\u0019<f\u0019\u0006tw-^1hKN+'O^3s\u0005VLG\u000eZ3s\u0015\t1v+\u0003\u0002];\n1B+\u001a=u\t>\u001cW/\\3oiR\u0013\u0018M\\:mCR|'O\u0003\u0002Z5\u00061A(\u001b8jiz\"b\u0001Y1cG\u0012,\u0007CA\u0013\u0001\u0011\u0015Ac\u00011\u0001*\u0011\u0015yc\u00011\u00011\u0011\u0015\u0019d\u00011\u00015\u0011\u0015ad\u00011\u0001>\u0011\u001d\u0019e\u0001%AA\u0002\u0011\u000ba\u0001\\8hO\u0016\u0014X#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-T\u0012!B:mMRR\u0017BA7k\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001\u00068pi&4\u0017pQ8oi\u0016DHo\u00115b]\u001e,G\r\u0006\u0002riB\u0011qD]\u0005\u0003g\u0002\u0012A!\u00168ji\")Q/\u0003a\u0001m\u0006\u0011aO\u001a\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fa!\u001a3ji>\u0014(BA>\u0017\u0003\t1('\u0003\u0002~q\nYa+\u001b:uk\u0006dg)\u001b7f\u0003\u0019\u0019\u00180\u001c2pYR!\u0011\u0011AA !\u0019\t\u0019!!\u0005\u0002\u00165\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u0003\u0002\u000e\u0005!Q\u000f^5m\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u000b\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:fa\u0011\t9\"a\t\u0011\r\u0005e\u00111DA\u0010\u001b\t\tI!\u0003\u0003\u0002\u001e\u0005%!\u0001\u0002'jgR\u0004B!!\t\u0002$1\u0001AaCA\u0013\u0015\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00133#\u0011\tI#a\f\u0011\u0007}\tY#C\u0002\u0002.\u0001\u0012qAT8uQ&tw\r\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0007\u0005e\"$A\u0004fG2L\u0007o]3\n\t\u0005u\u00121\u0007\u0002\u0012'fl'm\u001c7J]\u001a|'/\\1uS>t\u0007bBA!\u0015\u0001\u0007\u00111I\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005E\u0012QI\u0005\u0005\u0003\u000f\n\u0019DA\u000bX_J\\7\u000f]1dKNKXNY8m!\u0006\u0014\u0018-\\:\u0002-\u0011LGm\u00115b]\u001e,7i\u001c8gS\u001e,(/\u0019;j_:$2!]A'\u0011\u001d\t\te\u0003a\u0001\u0003\u001f\u0002B!!\r\u0002R%!\u00111KA\u001a\u0005q!\u0015\u000eZ\"iC:<WmQ8oM&<WO]1uS>t\u0007+\u0019:b[N\fQ\u0003Z5e\u0007\"\fgnZ3XCR\u001c\u0007.\u001a3GS2,7\u000fF\u0002r\u00033Bq!!\u0011\r\u0001\u0004\tY\u0006\u0005\u0003\u00022\u0005u\u0013\u0002BA0\u0003g\u00111\u0004R5e\u0007\"\fgnZ3XCR\u001c\u0007.\u001a3GS2,7\u000fU1sC6\u001c\u0018A\n#fM\u0006,H\u000e\u001e\"bg\u0016<vN]6ta\u0006\u001cWmU3sm&\u001cWmQ8oiJL'-\u001e;peB\u0011QED\n\u0003\u001dy!\"!a\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiGK\u0002E\u0003_Z#!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w\u0002\u0013AC1o]>$\u0018\r^5p]&!\u0011qPA;\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DefaultBaseWorkspaceServiceContributor
implements WorkspaceServiceContributor {
    private final ProjectKind projectKind;
    private final DefaultProjectMetadata projectMetadata;
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final CommandManagerService commandManager;
    private final Option<WeaveLanguageServerBuilder.TextDocumentTranslator> maybeTextDocumentTranslator;
    private final Logger logger;

    public static Option<WeaveLanguageServerBuilder.TextDocumentTranslator> $lessinit$greater$default$5() {
        return DefaultBaseWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger logger() {
        return this.logger;
    }

    public void org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(VirtualFile vf) {
        String uri = (String)this.maybeTextDocumentTranslator.map((Function1 & Serializable & scala.Serializable)translator -> translator.translate(vf.url())).getOrElse((Function0 & Serializable & scala.Serializable)() -> vf.url());
        SetContextValue[] values = (SetContextValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.commandManager.commands())).map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(uri);
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SetContextValue.class)));
        SetContextParams params = new SetContextParams(Arrays.asList((Object[])values));
        this.weaveProtocolClient.setContext(params);
    }

    @Override
    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveResourceResolver resourceResolver = $this.projectKind.vfs().asResourceResolver();
            Iterable<LocatedResult<WeaveIdentifier>> iterable = $this.projectKind.toolingService(LSPWeaveIndexService.class).searchSymbol(params.getQuery());
            ArrayList result = new ArrayList();
            iterable.foreach((Function1 & Serializable & scala.Serializable)lr -> {
                Option moduleResource;
                SymbolInformation information = new SymbolInformation();
                information.setName(((WeaveIdentifier)lr.value()).value());
                int n = ((WeaveIdentifier)lr.value()).idType();
                SymbolKind kind = IdentifierType$.MODULE$.FUNCTION() == n ? SymbolKind.Function : (IdentifierType$.MODULE$.VARIABLE() == n ? SymbolKind.Variable : (IdentifierType$.MODULE$.NAMESPACE() == n ? SymbolKind.Namespace : (IdentifierType$.MODULE$.ANNOTATION() == n ? SymbolKind.Interface : SymbolKind.Field)));
                information.setKind(kind);
                NameIdentifier name = lr.moduleName();
                Option option = moduleResource = resourceResolver.resolve(name);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WeaveResource weaveResource = (WeaveResource)some.value();
                    Range range = new Range();
                    Position startPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).startLocation());
                    Position endPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).endLocation());
                    range.setStart(LSPConverters$.MODULE$.toPosition(startPosition));
                    range.setEnd(LSPConverters$.MODULE$.toPosition(endPosition));
                    Location location = new Location(weaveResource.url(), range);
                    information.setLocation(location);
                    return BoxesRunTime.boxToBoolean((boolean)result.add(information));
                }
                return BoxedUnit.UNIT;
            });
            return result;
        });
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        String[] modified = this.projectMetadata.settings().update(params.getSettings());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modified)).nonEmpty()) {
            this.projectKind.eventBus().fire(new SettingsChangedEvent(modified));
            return;
        }
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.getChanges().forEach(fe -> {
            if ($this.projectKind.isProjectFile(fe.getUri())) {
                this.logger().debug(new StringBuilder(26).append("Changed Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
                $this.projectKind.eventBus().fire(new FileChangedEvent(fe.getUri(), fe.getType()));
                return;
            }
            this.logger().debug(new StringBuilder(26).append("Ignored Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
        });
    }

    public DefaultBaseWorkspaceServiceContributor(ProjectKind projectKind, DefaultProjectMetadata projectMetadata, DataWeaveProtocolClient weaveProtocolClient, CommandManagerService commandManager, Option<WeaveLanguageServerBuilder.TextDocumentTranslator> maybeTextDocumentTranslator) {
        this.projectKind = projectKind;
        this.projectMetadata = projectMetadata;
        this.weaveProtocolClient = weaveProtocolClient;
        this.commandManager = commandManager;
        this.maybeTextDocumentTranslator = maybeTextDocumentTranslator;
        this.logger = LoggerFactory.getLogger(this.getClass());
        projectKind.eventBus().register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ DefaultBaseWorkspaceServiceContributor $outer;

            public void onDocumentChanged(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        projectKind.eventBus().register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), new OnDocumentOpened(this){
            private final /* synthetic */ DefaultBaseWorkspaceServiceContributor $outer;

            public void onDocumentOpened(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        projectKind.eventBus().register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ DefaultBaseWorkspaceServiceContributor $outer;

            public void onDocumentFocused(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

