package org.mule.weave.lsp.utils

import java.io.BufferedReader
import java.io.IOException
import java.io.InputStream
import java.io.InputStreamReader
import java.nio.charset.StandardCharsets
import java.util.concurrent.Executor

object IOUtils {

  def forwardProcessStream(process: Process, executor: Executor, lineConsumer: ProcessStreamLineConsumer): Unit = {
    executor.execute(forwardProcessStream(process, process.getInputStream, (line) => lineConsumer.onStdOutLineRead(line), (ioe) => lineConsumer.onIOException(ioe)))
    executor.execute(forwardProcessStream(process, process.getErrorStream, (line) => lineConsumer.onStdErrorLineRead(line), (ioe) => lineConsumer.onIOException(ioe)))
  }

  private def forwardProcessStream(process: Process, is: InputStream, onLineRead: String => Unit, onExceptionRead: IOException => Unit): Runnable = {
    () => {
      try {
        val theProcess: Process = process
        val reader: BufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8))
        while (theProcess.isAlive) {
          val line = reader.readLine()
          if (line != null) {
            onLineRead.apply(line)
          }
        }
      } catch {
        case io: IOException => {
          onExceptionRead.apply(io)
        }
      }
    }
  }
}

trait ProcessStreamLineConsumer {

  def onStdOutLineRead(line: String)

  def onStdErrorLineRead(line: String)

  def onIOException(ioException: IOException)

}
