/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.extension.api.metadata.ContextMetadata;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.LSPWeaveTextDocument;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.v2.editor.QuickFix;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveTextDocument;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3A\u0001C\u0005\u0001)!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015A\u0006\u0001\"\u0011;\u0011\u0015I\u0006\u0001\"\u0011[\u0005=\tV/[2l\r&D8i\\7nC:$'B\u0001\u0006\f\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u0007\u000e\u0003\ra7\u000f\u001d\u0006\u0003\u001d=\tQa^3bm\u0016T!\u0001E\t\u0002\t5,H.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!F\u000f\u0011\u0005YYR\"A\f\u000b\u0005aI\u0012\u0001\u00027b]\u001eT\u0011AG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001d/\t1qJ\u00196fGR\u0004\"A\b\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u000f\r|W.\\1oI*\u0011!eI\u0001\nKb$XM\\:j_:T!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#\u001b%\u0011qe\b\u0002\r/\u0016\fg/Z\"p[6\fg\u000eZ\u0001\u0018o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u0006\u0002\u0011M,'O^5dKNL!AL\u0016\u0003/]{'o[:qC\u000e,7+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\u0018!C;J'\u0016\u0014h/[2f!\tQ\u0013'\u0003\u00023W\tIQ+S*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U:\u0004\b\u0005\u00027\u00015\t\u0011\u0002C\u0003)\u0007\u0001\u0007\u0011\u0006C\u00030\u0007\u0001\u0007\u0001'A\u0005d_6l\u0017M\u001c3JIR\t1\b\u0005\u0002=\u000b:\u0011Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001N\ta\u0001\u0010:p_Rt$\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001R!\u0002\u000f\u0015DXmY;uKR\u0011!J\u0014\t\u0003\u00172k\u0011!Q\u0005\u0003\u001b\u0006\u0013a!\u00118z%\u00164\u0007\"B(\u0006\u0001\u0004\u0001\u0016A\u00029be\u0006l7\u000f\u0005\u0002R-6\t!K\u0003\u0002T)\u0006)An\u001d95U*\u0011Q+E\u0001\bK\u000ed\u0017\u000e]:f\u0013\t9&K\u0001\u000bFq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3QCJ\fWn]\u0001\u0005]\u0006lW-A\u0006eKN\u001c'/\u001b9uS>tGCA\u001e\\\u0011\u0015yu\u00011\u0001Q\u0001")
public class QuickFixCommand
implements WeaveCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final UIService uIService;

    public String commandId() {
        return Commands$.MODULE$.DW_QUICK_FIX();
    }

    public Object execute(ExecuteCommandParams params) {
        List arguments = params.getArguments();
        Predef$.MODULE$.assert(arguments.size() == 6);
        String uri = Commands$.MODULE$.argAsString(arguments, 0);
        int startOffset = Commands$.MODULE$.argAsInt(arguments, 1);
        int endOffset = Commands$.MODULE$.argAsInt(arguments, 2);
        String kind = Commands$.MODULE$.argAsString(arguments, 3);
        String severity = Commands$.MODULE$.argAsString(arguments, 4);
        String qfName = Commands$.MODULE$.argAsString(arguments, 5);
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            ProjectKind projectKind = (ProjectKind)maybeProjectKind.get();
            DataWeaveToolingService toolingService = projectKind.toolingService(DataWeaveToolingService.class);
            Optional<ContextMetadata> maybeContext = toolingService.contextMetadataFor(uri);
            QuickFix[] quickFixes = toolingService.quickFixesFor(uri, startOffset, endOffset, kind, severity, maybeContext);
            WeaveDocumentToolingService documentToolingService = toolingService.openDocument(uri, maybeContext);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])quickFixes)).find((Function1 & Serializable & scala.Serializable)qf -> BoxesRunTime.boxToBoolean((boolean)QuickFixCommand.$anonfun$execute$1(qfName, qf))).foreach((Function1 & Serializable & scala.Serializable)qf -> {
                LSPWeaveTextDocument document = new LSPWeaveTextDocument(documentToolingService);
                qf.quickFix().run((WeaveTextDocument)document);
                WorkspaceEdit edit = new WorkspaceEdit();
                HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
                changes.put(uri, document.edits());
                edit.setChanges(changes);
                return $this.workspaceServiceManager.workspaceEditService().applyEdit(new ApplyWorkspaceEditParams(edit, qf.description()));
            });
        } else {
            this.uIService.showMessage(new MessageParams(MessageType.Error, new StringBuilder(50).append("No project is associated to: ").append(uri).append(". ").append(this.commandId()).append(" cannot be executed").toString()));
        }
        return null;
    }

    public String name() {
        return "Executes Quick Fix.";
    }

    public String description(ExecuteCommandParams params) {
        return new StringBuilder(24).append("Executing Quick Fix: `").append(Commands$.MODULE$.argAsString(params.getArguments(), 5)).append("`.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(String qfName$1, QuickFix qf) {
        String string = qf.name();
        String string2 = qfName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public QuickFixCommand(WorkspaceServiceManager workspaceServiceManager, UIService uIService) {
        this.workspaceServiceManager = workspaceServiceManager;
        this.uIService = uIService;
    }
}

