package org.mule.weave.lsp.utils

import org.mule.weave.lsp.extension.protocol.WeaveTestItem
import org.mule.weave.v2.editor.VirtualFile
import org.mule.weave.v2.parser.phase.{ParsingContext, PhaseResult}

trait WeaveTestIndexer {
  /**
   * Parses the file to be indexed and returns the test declared in the specified Weave Document.
   * @param vf The file to index
   * @param context The context
   * @return the result with test item  if any specified in the Weave Document
   */
  def index(vf: VirtualFile, context: ParsingContext): PhaseResult[Option[WeaveTestItem]]

}
