package org.mule.weave.lsp.project.components

import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.utils.WeaveDirectoryUtils

import java.io.File

/**
  * This component creates specific folder kinds
  */
trait ProjectFolderFactory {


  /**
    * Creates the test source folder
    *
    * @return The new folder already created
    */
  def createTestSourceFolder(project: ProjectMetadata): File
}

object DefaultProjectFolderFactory extends ProjectFolderFactory {
  override def createTestSourceFolder(project: ProjectMetadata): File = {
    val mainDir = new File(project.home(), "src" + File.separator + "test")
    val mainSourceFolder = new File(mainDir, WeaveDirectoryUtils.DWTest_FOLDER)
    mainSourceFolder.mkdirs()
    mainSourceFolder
  }
}
