package org.mule.weave.lsp.services

import org.eclipse.lsp4j.PublishDiagnosticsParams
import org.eclipse.lsp4j.services.LanguageClient

class DiagnosticsPublisher(languageClient: LanguageClient, scheme: Option[String]) {
  def handles(diagnostics: PublishDiagnosticsParams): Boolean = {
    scheme.isDefined && diagnostics.getUri.startsWith(scheme.get)
  }

  def publishDiagnostics(diagnostics: PublishDiagnosticsParams): Unit = {
    languageClient.publishDiagnostics(diagnostics)
  }
}
