/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.Serializable;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.mule.weave.lsp.commands.AbstractCreateFileCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4Aa\u0004\t\u00017!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003#\u0011!I\u0003A!b\u0001\n\u0003Q\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000fQ\u0002!\u0019!C\u0001k!11\t\u0001Q\u0001\nYBQ\u0001\u0012\u0001\u0005BUBQ!\u0012\u0001\u0005B\u0019CQ!\u0017\u0001\u0005\niCQA\u0018\u0001\u0005B}CQa\u0019\u0001\u0005B\u0011DQ!\u001a\u0001\u0005B\u0011DQA\u001a\u0001\u0005B\u001d\u00141e\u0011:fCR,\u0017J\u001c;fOJ\fG/[8o\u001b\u0006\u0004\b/\u001b8h\r&dWmQ8n[\u0006tGM\u0003\u0002\u0012%\u0005A1m\\7nC:$7O\u0003\u0002\u0014)\u0005\u0019An\u001d9\u000b\u0005U1\u0012!B<fCZ,'BA\f\u0019\u0003\u0011iW\u000f\\3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\t\n\u0005}\u0001\"!G!cgR\u0014\u0018m\u0019;De\u0016\fG/\u001a$jY\u0016\u001cu.\\7b]\u0012\fqc^8sWN\u0004\u0018mY3TKJ4\u0018nY3NC:\fw-\u001a:\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\n\u0002\u0011M,'O^5dKNL!a\n\u0013\u0003/]{'o[:qC\u000e,7+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\u0018\u0001G<pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3sA\u0005IQ/S*feZL7-Z\u000b\u0002WA\u00111\u0005L\u0005\u0003[\u0011\u0012\u0011\"V%TKJ4\u0018nY3\u0002\u0015UL5+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004cI\u001a\u0004CA\u000f\u0001\u0011\u0015\u0001S\u00011\u0001#\u0011\u0015IS\u00011\u0001,\u0003Ai\u0015\t\u0015)J\u001d\u001e{F+R'Q\u0019\u0006#V)F\u00017!\t9\u0004I\u0004\u00029}A\u0011\u0011\bP\u0007\u0002u)\u00111HG\u0001\u0007yI|w\u000e\u001e \u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fq\n\u0011#T!Q!&sui\u0018+F\u001bBc\u0015\tV#!\u000359W\r^%oaV$H*\u00192fY\u0006qq-\u001a;EK\u001a\fW\u000f\u001c;OC6,Gc\u0001\u001cH#\")\u0001*\u0003a\u0001\u0013\u00061\u0001/\u0019:b[N\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u00059C\u0012aB3dY&\u00048/Z\u0005\u0003!.\u0013A#\u0012=fGV$XmQ8n[\u0006tG\rU1sC6\u001c\b\"\u0002*\n\u0001\u0004\u0019\u0016a\u00039s_*,7\r^&j]\u0012\u0004\"\u0001V,\u000e\u0003US!A\u0016\n\u0002\u000fA\u0014xN[3di&\u0011\u0001,\u0016\u0002\f!J|'.Z2u\u0017&tG-\u0001\u0012sKBd\u0017mY3J[B|'\u000f^:B]\u00124UO\\2uS>t7\u000fV3na2\fG/\u001a\u000b\u0004mmk\u0006\"\u0002/\u000b\u0001\u00041\u0014aA;sS\")!K\u0003a\u0001'\u0006Yq-\u001a;UK6\u0004H.\u0019;f)\r1\u0004M\u0019\u0005\u0006C.\u0001\r!S\u0001\u0015Kb,7-\u001e;f\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\t\u000bI[\u0001\u0019A*\u0002\u0013\r|W.\\1oI&#G#\u0001\u001c\u0002\t9\fW.Z\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0006\u00027Q\")\u0001J\u0004a\u0001\u0013\u0002")
public class CreateIntegrationMappingFileCommand
extends AbstractCreateFileCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final UIService uIService;
    private final String MAPPING_TEMPLATE;

    @Override
    public WorkspaceServiceManager workspaceServiceManager() {
        return this.workspaceServiceManager;
    }

    @Override
    public UIService uIService() {
        return this.uIService;
    }

    public String MAPPING_TEMPLATE() {
        return this.MAPPING_TEMPLATE;
    }

    @Override
    public String getInputLabel() {
        return "Name of the Integration Mapping";
    }

    @Override
    public String getDefaultName(ExecuteCommandParams params, ProjectKind projectKind) {
        if (params.getArguments() != null && params.getArguments().size() >= 2) {
            String moduleFileUri = Commands$.MODULE$.argAsString(params.getArguments(), 1);
            VirtualFile file = projectKind.vfs().file(moduleFileUri);
            return new StringBuilder(22).append(file.getNameIdentifier().localName().name()).append("IntegrationMapping.dwl").toString();
        }
        return "MyIntegrationMapping.dwl";
    }

    private String replaceImportsAndFunctionsTemplate(String uri, ProjectKind projectKind) {
        VirtualFile file = projectKind.vfs().file(uri);
        WeaveDocumentToolingService service = projectKind.toolingService(DataWeaveToolingService.class).openDocument(uri);
        FunctionDefinition[] functionDefinitions = service.availableFunctions();
        String functionsString = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])functionDefinitions)).map((Function1 & Serializable & scala.Serializable)definition -> {
            String functionName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definition.nameIdentifier().nameElements())).last();
            String params = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definition.params())).map((Function1 & Serializable & scala.Serializable)param -> (String)param.defaultValue().getOrElse((Function0 & Serializable & scala.Serializable)() -> "???"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
            return new StringBuilder(10).append("|    ").append(functionName).append(" : ").append(functionName).append("(").append(params).append(")").toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(new StringBuilder(1).append(",").append(System.lineSeparator()).toString());
        return new StringBuilder(109).append("|%dw ").append(projectKind.getWeaveVersion()).append("\n       |import * from ").append(file.getNameIdentifier().name()).append("\n       |\n       |output application/json\n       |---\n       |{\n       ").append(functionsString).append("\n       |}").toString();
    }

    @Override
    public String getTemplate(ExecuteCommandParams executeCommandParams, ProjectKind projectKind) {
        String string;
        if (executeCommandParams.getArguments() != null && executeCommandParams.getArguments().size() >= 2) {
            String moduleUri = Commands$.MODULE$.argAsString(executeCommandParams.getArguments(), 1);
            string = this.replaceImportsAndFunctionsTemplate(moduleUri, projectKind);
        } else {
            string = this.MAPPING_TEMPLATE().replace("${syntaxVersion}", projectKind.getWeaveVersion());
        }
        String template = string;
        return StringHelper$.MODULE$.toStringTransformer(new StringBuilder(5).append(this.INTEGRATION_MAPPING_CONTENT()).append("\n    ").append(template).toString()).stripMarginAndNormalizeEOL();
    }

    public String commandId() {
        return Commands$.MODULE$.DW_CREATE_TEST_MAPPING();
    }

    public String name() {
        return "Create Integration Mapping";
    }

    public String description(ExecuteCommandParams params) {
        return "Creating Integration Mapping File.";
    }

    public CreateIntegrationMappingFileCommand(WorkspaceServiceManager workspaceServiceManager, UIService uIService) {
        String string;
        this.workspaceServiceManager = workspaceServiceManager;
        this.uIService = uIService;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(this.getClass().getClassLoader().getResourceAsStream("dw-template-mapping.dwl"), "UTF-8");){
            string = source.mkString();
        }
        this.MAPPING_TEMPLATE = string;
    }
}

