package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.project.commands.ProjectProvider
import org.mule.weave.lsp.services.UIService

class CreateProjectCommand(uIService: UIService) extends WeaveCommand {

  override def commandId(): String = Commands.DW_CREATE_PROJECT

  override def name(): String = "Creates a DataWeave Project"

  override def description(params: ExecuteCommandParams): String = "Create a new DW Project"

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val projectProvider = new ProjectProvider(uIService)
    projectProvider.newProject();
    null
  }
}
