package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WeaveScenarioManagerService
import org.mule.weave.lsp.services.WorkspaceServiceManager
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class SetActiveScenarioCommand(workspaceServiceManager: WorkspaceServiceManager, uIService: UIService) extends InternalWeaveCommand {

  override def commandId(): String = Commands.DW_ACTIVE_SCENARIO

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val nameIdentifier: String = Commands.argAsString(params.getArguments, 0)
    val uri: String = Commands.argAsString(params.getArguments, 1)
    val nameOfScenario: String = Commands.argAsString(params.getArguments, 2)

    val maybeProjectKind = workspaceServiceManager.projectKind(uri)
    if (maybeProjectKind.isDefined) {
      val scenariosManager: WeaveScenarioManagerService = maybeProjectKind.get.toolingService(classOf[WeaveScenarioManagerService])
      scenariosManager.setActiveScenario(NameIdentifier(nameIdentifier), nameOfScenario)
    } else {
      uIService.showMessage(new MessageParams(MessageType.Error, s"No project is associated to: ${uri}. ${commandId} cannot be executed"))
    }

    null
  }

  override def name(): String = "Marks Active Command."

  override def description(params: ExecuteCommandParams): String = "Marking Active Command."
}
