package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent.ACTIVE_SCENARIO_CHANGED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.v2.editor.VirtualFile

class ActiveScenarioChangedEvent(vf: VirtualFile) extends InternalEvent {
  override type T = OnActiveScenarioChanged

  override def getType: InternalEventType[OnActiveScenarioChanged] = ACTIVE_SCENARIO_CHANGED

  override def dispatch(handler: OnActiveScenarioChanged): Unit = {
    handler.onActiveScenarioChanged(vf)
  }
}

trait OnActiveScenarioChanged extends InternalEventHandler {
  def onActiveScenarioChanged(vf: VirtualFile): Unit
}

object ActiveScenarioChangedEvent {
  val ACTIVE_SCENARIO_CHANGED = InternalEventType[OnActiveScenarioChanged]("ACTIVE_SCENARIO_CHANGED")
}
