package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.services.ClientLoggerFactory
import org.mule.weave.lsp.services.WorkspaceServiceManager

class InstallBatCommand(cl: ClientLoggerFactory, workspaceServiceManager: WorkspaceServiceManager) extends BatCommand(workspaceServiceManager) {
  override def commandId(): String = Commands.BAT_INSTALL_BAT_CLI

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val batProjectManager = new BatProjectHelper(cl.createLogger(classOf[InstallBatCommand]))
    batProjectManager.setupBat()
    null
  }

  override def name(): String = "Installs Bat."

  override def description(params: ExecuteCommandParams): String = "Installing Bat Tool."

}
