package org.mule.weave.lsp.extension.protocol

import java.util.concurrent.CompletableFuture

case object NoopDataWeaveProtocolClientDelegate extends DataWeaveProtocolClient {

  /**
   * Opens an input box to ask the user for input.
   *
   * @return the user provided input. The future can be cancelled, meaning
   *         the input box should be dismissed in the editor.
   */
  override def weaveInputBox(params: WeaveInputBoxParams): CompletableFuture[WeaveInputBoxResult] = {
    new CompletableFuture[WeaveInputBoxResult]()
  }

  /**
   * Opens an menu to ask the user to pick one of the suggested options.
   *
   * @return the user provided pick. The future can be cancelled, meaning
   *         the input box should be dismissed in the editor.
   */
  override def weaveQuickPick(params: WeaveQuickPickParams): CompletableFuture[WeaveQuickPickResult] = {
    new CompletableFuture[WeaveQuickPickResult]()
  }

  override def weaveFileBrowser(params: WeaveOpenDialogParams): CompletableFuture[String] = {
    new CompletableFuture[String]()
  }

  override def setEditorDecorations(params: EditorDecorationsParams): Unit = {
  }

  override def clearEditorDecorations(): Unit = {
  }

  /**
   * Opens a folder in a new window
   *
   * @param params
   */
  override def openWindow(params: OpenWindowsParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to execute the specified configuration on client side.
   *
   */
  override def runConfiguration(config: LaunchConfiguration): Unit = {
  }

  /**
   * This notification is sent from the server to the client to open an editor with the specified document uri
   *
   * @param params The document to be opened
   */
  override def openTextDocument(params: OpenTextDocumentParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to set context variable on visual studio code
   * used for enabling/disabling commands
   * at the editor with the specified document uri
   *
   * @param params The document to be opened
   */
  override def setContext(params: SetContextParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to show the live data of a script
   *
   * @param result The result of executing a script
   */
  override def showPreviewResult(result: PreviewResult): Unit = {
  }

  /**
   * This notification is sent from the server to the client to publish all the resolved dependencies of this workspace
   *
   * @param resolvedDependency The list of all the resolved dependencies
   */
  override def publishDependencies(resolvedDependency: DependenciesParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to publish current transformation scenarios.
   *
   * @param scenariosParam Scenarios Parameter
   */
  override def showScenarios(scenariosParam: ShowScenariosParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to inform the user that a background job has started.
   *
   * @param job The job information that has started
   */
  override def notifyJobStarted(job: JobStartedParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to inform the user that a background job has finish.
   *
   * @param job The job information that has ended
   */
  override def notifyJobEnded(job: JobEndedParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to push all the possible tests to run on the project.
   *
   * @param job The job information that has ended
   */
  override def publishTestItems(job: PublishTestItemsParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to push tests results.
   *
   * @param job The job information that has ended
   */
  override def publishTestResults(testResults: PublishTestResultsParams): Unit = {
  }

  /**
   * This notification is sent from the server to the client to push activity metrics.
   *
   * @param event The metric event information
   */
  override def trackMetricEvent(event: MetricEvent): Unit = {
  }
}
