/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.actions;

import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.mule.weave.extension.api.extension.action.WeaveCodeActionProvider;
import org.mule.weave.extension.api.metadata.ContextMetadata;
import org.mule.weave.lsp.commands.ExtractConstantCommand$;
import org.mule.weave.lsp.commands.ExtractFunctionCommand$;
import org.mule.weave.lsp.commands.ExtractVariableCommand$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4AAB\u0004\u0001%!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00033\u0001\u0011\u00053\u0007C\u0003M\u0001\u0011%Q\nC\u0003\t\u0001\u0011\u0005\u0003M\u0001\fSK\u001a\f7\r^8s\u0003\u000e$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0015\tA\u0011\"A\u0004bGRLwN\\:\u000b\u0005)Y\u0011a\u00017ta*\u0011A\"D\u0001\u0006o\u0016\fg/\u001a\u0006\u0003\u001d=\tA!\\;mK*\t\u0001#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001'm\u0001\"\u0001F\r\u000e\u0003UQ!AF\f\u0002\t1\fgn\u001a\u0006\u00021\u0005!!.\u0019<b\u0013\tQRC\u0001\u0004PE*,7\r\u001e\t\u00039\u0011j\u0011!\b\u0006\u0003=}\ta!Y2uS>t'B\u0001\u0011\"\u0003%)\u0007\u0010^3og&|gN\u0003\u0002#G\u0005\u0019\u0011\r]5\u000b\u0005\u0001Z\u0011BA\u0013\u001e\u0005]9V-\u0019<f\u0007>$W-Q2uS>t\u0007K]8wS\u0012,'/\u0001\bu_>d\u0017N\\4TKJ4\u0018nY3\u0011\u0005!ZS\"A\u0015\u000b\u0005)J\u0011\u0001C:feZL7-Z:\n\u00051J#a\u0006#bi\u0006<V-\u0019<f)>|G.\u001b8h'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0011q&\r\t\u0003a\u0001i\u0011a\u0002\u0005\u0006M\t\u0001\raJ\u0001\bQ\u0006tG\r\\3t)\r!$\b\u0012\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\b\u0005>|G.Z1o\u0011\u0015Y4\u00011\u0001=\u0003\u0019\u0001\u0018M]1ngB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0006YN\u0004HG\u001b\u0006\u0003\u0003>\tq!Z2mSB\u001cX-\u0003\u0002D}\t\u00012i\u001c3f\u0003\u000e$\u0018n\u001c8QCJ\fWn\u001d\u0005\u0006\u000b\u000e\u0001\rAR\u0001\bG>tG/\u001a=u!\t9%*D\u0001I\u0015\tI\u0015%\u0001\u0005nKR\fG-\u0019;b\u0013\tY\u0005JA\bD_:$X\r\u001f;NKR\fG-\u0019;b\u0003!!xn\u00144gg\u0016$Hc\u0001(R7B\u0011QgT\u0005\u0003!Z\u00121!\u00138u\u0011\u0015\u0011F\u00011\u0001T\u0003Y!wnY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0019)G-\u001b;pe*\u0011\u0001lC\u0001\u0003mJJ!AW+\u00037]+\u0017M^3E_\u000e,X.\u001a8u)>|G.\u001b8h'\u0016\u0014h/[2f\u0011\u0015aF\u00011\u0001^\u00035\u0019H/\u0019:u!>\u001c\u0018\u000e^5p]B\u0011QHX\u0005\u0003?z\u0012\u0001\u0002U8tSRLwN\u001c\u000b\u0004C\u001eD\u0007cA\u001bcI&\u00111M\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003{\u0015L!A\u001a \u0003\u0015\r{G-Z!di&|g\u000eC\u0003<\u000b\u0001\u0007A\bC\u0003F\u000b\u0001\u0007a\t")
public class RefactorActionProvider
implements WeaveCodeActionProvider {
    private final DataWeaveToolingService toolingService;

    public boolean handles(CodeActionParams params, ContextMetadata context) {
        int endOffset;
        WeaveDocumentToolingService documentToolingService = this.toolingService.openDocument(params.getTextDocument().getUri(), Optional.ofNullable(context));
        Range range = params.getRange();
        Position startPosition = range.getStart();
        Position endPosition = range.getEnd();
        int startOffset = this.toOffset(documentToolingService, startPosition);
        Option maybeNode = documentToolingService.nodeAt(startOffset, endOffset = this.toOffset(documentToolingService, endPosition)).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.astNode());
        Option option = maybeNode;
        if (option instanceof Some) {
            Some some = (Some)option;
            AstNode nodeToExtract = (AstNode)some.value();
            return AstNodeHelper$.MODULE$.isExpressionNode(nodeToExtract) || AstNodeHelper$.MODULE$.isWeaveTypeNode(nodeToExtract);
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    private int toOffset(WeaveDocumentToolingService documentToolingService, Position startPosition) {
        return documentToolingService.offsetOf(startPosition.getLine(), startPosition.getCharacter());
    }

    public CodeAction[] actions(CodeActionParams params, ContextMetadata context) {
        WeaveDocumentToolingService documentToolingService = this.toolingService.openDocument(params.getTextDocument().getUri(), Optional.ofNullable(context));
        Range range = params.getRange();
        Position startPosition = range.getStart();
        Position endPosition = range.getEnd();
        int startOffset = this.toOffset(documentToolingService, startPosition);
        int endOffset = this.toOffset(documentToolingService, endPosition);
        CodeAction extractVariable = new CodeAction("Extract Variable (Local Scope)");
        extractVariable.setCommand(ExtractVariableCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri()));
        extractVariable.setKind("refactor.extract.variable");
        CodeAction extractConstant = new CodeAction("Extract Variable (Global Scope)");
        extractConstant.setCommand(ExtractConstantCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri()));
        extractConstant.setKind("refactor.extract.constant");
        CodeAction extractFunction = new CodeAction("Extract Function");
        extractFunction.setCommand(ExtractFunctionCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri()));
        extractFunction.setKind("refactor.extract.function");
        return (CodeAction[])((Object[])new CodeAction[]{extractVariable, extractConstant, extractFunction});
    }

    public RefactorActionProvider(DataWeaveToolingService toolingService) {
        this.toolingService = toolingService;
    }
}

