/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.mule.weave.extension.api.extension.validation.DocumentNode;
import org.mule.weave.extension.api.extension.validation.MessageBuilderFactory;
import org.mule.weave.extension.api.extension.validation.MessageValidationCollector;
import org.mule.weave.extension.api.extension.validation.ValidationTypeLevel;
import org.mule.weave.extension.api.extension.validation.WeaveValidator;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.extension.api.metadata.ContextMetadata;
import org.mule.weave.extension.api.metadata.InputMetadata;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.indexer.events.IndexingFinishedEvent$;
import org.mule.weave.lsp.indexer.events.IndexingType$;
import org.mule.weave.lsp.indexer.events.OnIndexingFinished;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.Settings$;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.SampleDataComponent;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.OnSettingsChanged;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.project.events.SettingsChangedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService$;
import org.mule.weave.lsp.services.DiagnosticsPublisherService;
import org.mule.weave.lsp.services.MessageValidationCollectorAdapter;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveToolingServiceFactory;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.utils.WeaveTypeUtils$;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent$;
import org.mule.weave.v2.api.tooling.ast.DWAstNode;
import org.mule.weave.v2.api.tooling.impl.message.DefaultMessageBuilder;
import org.mule.weave.v2.api.tooling.message.MessageBuilder;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.editor.ImplicitInput$;
import org.mule.weave.v2.editor.MappingInput;
import org.mule.weave.v2.editor.QuickFix;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessages;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveToolingService;
import org.mule.weave.v2.parser.MessageCategory;
import org.mule.weave.v2.parser.ScopePhaseCategory$;
import org.mule.weave.v2.parser.TypePhaseCategory$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.versioncheck.SVersion$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r5b\u0001B\u00193\u0001uB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0015\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003W\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011\u001d\u0004!\u0011!Q\u0001\n!DQA\u001d\u0001\u0005\u0002MDqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013E\u0011\u0011\u0002\u0005\f\u0003+\u0001\u0001\u0019!a\u0001\n#\t9\u0002C\u0006\u0002$\u0001\u0001\r\u0011!Q!\n\u0005-\u0001BCA\u0013\u0001!\u0015\r\u0011\"\u0003\u0002(!Y\u0011q\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0019\u0011-\t9\u0005\u0001a\u0001\u0002\u0004%I!!\u0013\t\u0017\u00055\u0003\u00011A\u0001B\u0003&\u00111\u0007\u0005\n\u0003\u001f\u0002\u0001\u0019!C\t\u0003#B\u0011\"!\u0017\u0001\u0001\u0004%\t\"a\u0017\t\u0011\u0005}\u0003\u0001)Q\u0005\u0003'Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\t)\u000e\u0001C\u0001\u0003/Dq!!;\u0001\t\u0003\tY\u000fC\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012!9!1\u0001\u0001\u0005\u0002\tU\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\n\u0005O\u0001\u0011\u0013!C\u0005\u0005SAqAa\u0001\u0001\t\u0013\u0011y\u0004C\u0005\u0003v\u0001\t\n\u0011\"\u0003\u0003*!9!q\u000f\u0001\u0005\u0002\te\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fC\u0011B!)\u0001#\u0003%\tAa)\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\"9!1\u001a\u0001\u0005\u0002\t5\u0007\"\u0003By\u0001E\u0005I\u0011\u0001Bz\u0011\u001d\u00119\u0010\u0001C\u0005\u0005sDqaa\u0003\u0001\t\u0003\u0019i\u0001C\u0005\u0004\u0014\u0001\t\n\u0011\"\u0001\u0003t\"91Q\u0003\u0001\u0005\n\r]\u0001bBB\u0015\u0001\u0011\u000511\u0006\u0002\u0018\t\u0006$\u0018mV3bm\u0016$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016T!a\r\u001b\u0002\u0011M,'O^5dKNT!!\u000e\u001c\u0002\u00071\u001c\bO\u0003\u00028q\u0005)q/Z1wK*\u0011\u0011HO\u0001\u0005[VdWMC\u0001<\u0003\ry'oZ\u0002\u0001'\r\u0001a\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00153U\"\u0001\u001a\n\u0005\u001d\u0013$A\u0004+p_2LgnZ*feZL7-Z\u0001\baJ|'.Z2u+\u0005Q\u0005CA&R\u001b\u0005a%B\u0001%N\u0015\tqu*A\u0002ba&T!\u0001\u0015\u001c\u0002\u0013\u0015DH/\u001a8tS>t\u0017B\u0001*M\u0005=\u0001&o\u001c6fGRlU\r^1eCR\f\u0017\u0001\u00039s_*,7\r\u001e\u0011\u0002\u0007Y47/F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0004fI&$xN\u001d\u0006\u00037Z\n!A\u001e\u001a\n\u0005uC&!\u0005,jeR,\u0018\r\u001c$jY\u0016\u001c\u0016p\u001d;f[\u0006!aOZ:!\u0003A\u0001XO\u00197jg\",'oU3sm&\u001cW\r\u0005\u0002FC&\u0011!M\r\u0002\u001c\t&\fwM\\8ti&\u001c7\u000fU;cY&\u001c\b.\u001a:TKJ4\u0018nY3\u0002-\u0011|7-^7f]R\u001cVM\u001d<jG\u00164\u0015m\u0019;pef\u0004\"!R3\n\u0005\u0019\u0014$AG,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,g)Y2u_JL\u0018\u0001C3yK\u000e,Ho\u001c:\u0011\u0005%\u0004X\"\u00016\u000b\u0005-d\u0017AC2p]\u000e,(O]3oi*\u0011QN\\\u0001\u0005kRLGNC\u0001p\u0003\u0011Q\u0017M^1\n\u0005ET'\u0001C#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)\u0019!XO^<ysB\u0011Q\t\u0001\u0005\u0006\u0011\"\u0001\rA\u0013\u0005\u0006)\"\u0001\rA\u0016\u0005\u0006?\"\u0001\r\u0001\u0019\u0005\u0006G\"\u0001\r\u0001\u001a\u0005\u0006O\"\u0001\r\u0001[\u0001\u0007Y><w-\u001a:\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@;\u0003\u0015\u0019HN\u001a\u001bk\u0013\r\t\u0019A \u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005EQBAA\b\u0015\tAE'\u0003\u0003\u0002\u0014\u0005=!a\u0003)s_*,7\r^&j]\u0012\fq\u0002\u001d:pU\u0016\u001cGoS5oI~#S-\u001d\u000b\u0005\u00033\ty\u0002E\u0002@\u00037I1!!\bA\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005B\"!AA\u0002\u0005-\u0011a\u0001=%c\u0005a\u0001O]8kK\u000e$8*\u001b8eA\u0005\u0001r\fZ8dk6,g\u000e^*feZL7-Z\u000b\u0003\u0003S\u00012aVA\u0016\u0013\r\ti\u0003\u0017\u0002\u0014/\u0016\fg/\u001a+p_2LgnZ*feZL7-Z\u0001\u0011GV\u001cHo\\7WC2LG-\u0019;peN,\"!a\r\u0011\u000b}\n)$!\u000f\n\u0007\u0005]\u0002IA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002<\u0005\rSBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002Q\u001b&!\u0011QIA\u001f\u000599V-\u0019<f-\u0006d\u0017\u000eZ1u_J\fAcY;ti>lg+\u00197jI\u0006$xN]:`I\u0015\fH\u0003BA\r\u0003\u0017B\u0011\"!\t\u0011\u0003\u0003\u0005\r!a\r\u0002#\r,8\u000f^8n-\u0006d\u0017\u000eZ1u_J\u001c\b%A\u0004j]\u0012,\u00070\u001a3\u0016\u0005\u0005M\u0003cA \u0002V%\u0019\u0011q\u000b!\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0011N\u001c3fq\u0016$w\fJ3r)\u0011\tI\"!\u0018\t\u0013\u0005\u00052#!AA\u0002\u0005M\u0013\u0001C5oI\u0016DX\r\u001a\u0011)\u0007Q\t\u0019\u0007E\u0002@\u0003KJ1!a\u001aA\u0005!1x\u000e\\1uS2,\u0017AC5oSRL\u0017\r\\5{KR1\u0011\u0011DA7\u0003_Bq!a\u0002\u0016\u0001\u0004\tY\u0001C\u0004\u0002rU\u0001\r!a\u001d\u0002\u0011\u00154XM\u001c;CkN\u0004B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003s\"\u0014!B;uS2\u001c\u0018\u0002BA?\u0003o\u0012\u0001#\u00138uKJt\u0017\r\\#wK:$()^:\u0002/\u0019Lg\u000eZ\"peJ,7\u000f]8oI&tw\rR<GS2,G\u0003BAB\u0003\u001f\u0003RaPAC\u0003\u0013K1!a\"A\u0005\u0019y\u0005\u000f^5p]B\u0019q+a#\n\u0007\u00055\u0005LA\u0006WSJ$X/\u00197GS2,\u0007bBAI-\u0001\u0007\u00111S\u0001\u0004gR\u0014\b\u0003BAK\u0003GsA!a&\u0002 B\u0019\u0011\u0011\u0014!\u000e\u0005\u0005m%bAAOy\u00051AH]8pizJ1!!)A\u0003\u0019\u0001&/\u001a3fM&!\u0011QUAT\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0015!\u0002%Y\fG.\u001b3bi\u0016\fE\u000e\\#eSR|'o\u001d\u000b\u0005\u00033\ti\u000bC\u0004\u00020^\u0001\r!a%\u0002\rI,\u0017m]8o\u0003Q1\u0018\r\\5eCR,G)\u001a9f]\u0012,gnY5fgR1\u0011\u0011DA[\u0003sCq!a.\u0019\u0001\u0004\tI)\u0001\u0002wM\"9\u0011q\u0016\rA\u0002\u0005M\u0015\u0001\u00037pC\u0012$\u0016\u0010]3\u0015\t\u0005}\u0016Q\u001a\t\u0006\u007f\u0005\u0015\u0015\u0011\u0019\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011q\u0019.\u0002\u0005Q\u001c\u0018\u0002BAf\u0003\u000b\u0014\u0011bV3bm\u0016$\u0016\u0010]3\t\u000f\u0005=\u0017\u00041\u0001\u0002\u0014\u0006QA/\u001f9f'R\u0014\u0018N\\4\u0002\u001f\u0011|7-^7f]R\u001cVM\u001d<jG\u0016$\"!!\u000b\u0002\u000f%t\u0007/\u001e;PMR1\u0011\u0011\\Aq\u0003K\u0004RaPAC\u00037\u00042aVAo\u0013\r\ty\u000e\u0017\u0002\r\u001b\u0006\u0004\b/\u001b8h\u0013:\u0004X\u000f\u001e\u0005\b\u0003G\\\u0002\u0019AAJ\u0003\r)(/\u001b\u0005\b\u0003O\\\u0002\u0019AAJ\u0003%Ig\u000e];u\u001d\u0006lW-\u0001\nd_:$X\r\u001f;NKR\fG-\u0019;b\r>\u0014H\u0003BAw\u0005\u0003\u0001b!a<\u0002r\u0006UX\"\u00017\n\u0007\u0005MHN\u0001\u0005PaRLwN\\1m!\u0011\t90!@\u000e\u0005\u0005e(bAA~\u001b\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002\u0000\u0006e(aD\"p]R,\u0007\u0010^'fi\u0006$\u0017\r^1\t\u000f\u0005\rH\u00041\u0001\u0002\u0014\u0006aq\u000e]3o\t>\u001cW/\\3oiR!!q\u0001B\u0007!\r9&\u0011B\u0005\u0004\u0005\u0017A&aG,fCZ,Gi\\2v[\u0016tG\u000fV8pY&twmU3sm&\u001cW\rC\u0004\u0002dv\u0001\r!a%\u0002)=\u0004XM\\%o\u001b\u0016lwN]=E_\u000e,X.\u001a8u)\u0011\u00119Aa\u0005\t\u000f\u0005\rh\u00041\u0001\u0002\u0014R1!q\u0001B\f\u00053Aq!a9 \u0001\u0004\t\u0019\nC\u0004\u0003\u001c}\u0001\r!!<\u0002\u00195\f\u0017PY3D_:$X\r\u001f;\u00025=\u0004XM\u001c#pGVlWM\u001c;XSRDw.\u001e;D_:$X\r\u001f;\u0015\r\t\u001d!\u0011\u0005B\u0012\u0011\u001d\t\u0019\u000f\ta\u0001\u0003'C\u0011B!\n!!\u0003\u0005\r!a\u0015\u0002\u0011%tW*Z7pef\fAe\u001c9f]\u0012{7-^7f]R<\u0016\u000e\u001e5pkR\u001cuN\u001c;fqR$C-\u001a4bk2$HEM\u000b\u0003\u0005WQC!a\u0015\u0003.-\u0012!q\u0006\t\u0005\u0005c\u0011Y$\u0004\u0002\u00034)!!Q\u0007B\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0003:\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iDa\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\u0006\u0003\b\t\u0005#1\tB/\u0005gBq!a9#\u0001\u0004\t\u0019\nC\u0004\u0003F\t\u0002\rAa\u0012\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005](\u0011J\u0005\u0005\u0005\u0017\nIPA\u0007J]B,H/T3uC\u0012\fG/\u0019\u0015\u0005\u0005\u0007\u0012y\u0005\u0005\u0003\u0003R\teSB\u0001B*\u0015\u0011\u0011ID!\u0016\u000b\u0005\t]\u0013!\u00026bm\u0006D\u0018\u0002\u0002B.\u0005'\u0012\u0001BT;mY\u0006\u0014G.\u001a\u0005\b\u0005?\u0012\u0003\u0019\u0001B1\u00039)\u0007\u0010]3di\u0016$w*\u001e;qkR\u0004BAa\u0019\u0003n5\u0011!Q\r\u0006\u0005\u0003\u000f\u00149G\u0003\u0003\u0003j\t-\u0014a\u0002;p_2Lgn\u001a\u0006\u0003\u001djKAAa\u001c\u0003f\t1Ai\u0016+za\u0016DCA!\u0018\u0003P!I!Q\u0005\u0012\u0011\u0002\u0003\u0007\u00111K\u0001\u0017_B,g\u000eR8dk6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005i1\r\\8tK\u0012{7-^7f]R$B!!\u0007\u0003|!9\u00111\u001d\u0013A\u0002\u0005M\u0015!E<ji\"d\u0015M\\4vC\u001e,G*\u001a<fYR!\u0011\u0011\u0006BA\u0011\u001d\u0011\u0019)\na\u0001\u0003'\u000bq\u0002Z<MC:<W/Y4f\u0019\u00164X\r\\\u0001\rm\u0006d\u0017\u000eZ1uK\u001aKG.\u001a\u000b\u0007\u00033\u0011IIa#\t\u000f\u0005]f\u00051\u0001\u0002\n\"9\u0011q\u0016\u0014A\u0002\u0005M\u0015!\u0005;sS\u001e<WM\u001d,bY&$\u0017\r^5p]RA\u0011\u0011\u0004BI\u0005+\u00139\nC\u0004\u0003\u0014\u001e\u0002\r!a%\u0002\u0017\u0011|7-^7f]R,&/\u001b\u0005\b\u0003_;\u0003\u0019AAJ\u0011%\u0011Ij\nI\u0001\u0002\u0004\u0011Y*\u0001\np]Z\u000bG.\u001b3bi&|gNR5oSND\u0007#B \u0003\u001e\u0006e\u0011b\u0001BP\u0001\nIa)\u001e8di&|g\u000eM\u0001\u001ciJLwmZ3s-\u0006d\u0017\u000eZ1uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0015&\u0006\u0002BN\u0005[\tQ\u0002^8ES\u0006<gn\\:uS\u000e\u001cH\u0003\u0002BV\u0005\u0003\u0004b!a<\u0003.\nE\u0016b\u0001BXY\n!A*[:u!\u0011\u0011\u0019L!0\u000e\u0005\tU&\u0002\u0002B\\\u0005s\u000bQ\u0001\\:qi)T1Aa/;\u0003\u001d)7\r\\5qg\u0016LAAa0\u00036\nQA)[1h]>\u001cH/[2\t\u000f\t\r\u0017\u00061\u0001\u0003F\u0006AQ.Z:tC\u001e,7\u000fE\u0002X\u0005\u000fL1A!3Y\u0005I1\u0016\r\\5eCRLwN\\'fgN\fw-Z:\u0002\u001bE,\u0018nY6GSb,7OR8s)9\u0011yMa6\u0003Z\n\r(q\u001dBv\u0005_\u0004RaPA\u001b\u0005#\u00042a\u0016Bj\u0013\r\u0011)\u000e\u0017\u0002\t#VL7m\u001b$jq\"9!1\u0013\u0016A\u0002\u0005M\u0005b\u0002BnU\u0001\u0007!Q\\\u0001\fgR\f'\u000f^(gMN,G\u000fE\u0002@\u0005?L1A!9A\u0005\rIe\u000e\u001e\u0005\b\u0005KT\u0003\u0019\u0001Bo\u0003%)g\u000eZ(gMN,G\u000fC\u0004\u0003j*\u0002\r!a%\u0002\t-Lg\u000e\u001a\u0005\b\u0005[T\u0003\u0019AAJ\u0003!\u0019XM^3sSRL\b\"\u0003B\u000eUA\u0005\t\u0019AAw\u0003]\tX/[2l\r&DXm\u001d$pe\u0012\"WMZ1vYR$c'\u0006\u0002\u0003v*\"\u0011Q\u001eB\u0017\u00039i\u0017\r^2iKNlUm]:bO\u0016$\"\"a\u0015\u0003|\u000e\u00151qAB\u0005\u0011\u001d\u0011i\u0010\fa\u0001\u0005\u007f\f\u0011!\u001c\t\u0004/\u000e\u0005\u0011bAB\u00021\n\tb+\u00197jI\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\t\u000f\t%H\u00061\u0001\u0002\u0014\"9!1\u001c\u0017A\u0002\tu\u0007b\u0002BsY\u0001\u0007!Q\\\u0001\tm\u0006d\u0017\u000eZ1uKR1!QYB\b\u0007#AqAa%.\u0001\u0004\t\u0019\nC\u0005\u0003\u001c5\u0002\n\u00111\u0001\u0002n\u0006\u0011b/\u00197jI\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00133\u0003Y\t\u0007\u000f\u001d7z\u0007V\u001cHo\\7WC2LG-\u0019;j_:\u001cH\u0003\u0003Bc\u00073\u0019Yba\b\t\u000f\tMu\u00061\u0001\u0002\u0014\"91QD\u0018A\u0002\t\u001d\u0011A\u00063pGVlWM\u001c;U_>d\u0017N\\4TKJ4\u0018nY3\t\u000f\r\u0005r\u00061\u0001\u0004$\u0005IA/\u001f9f\u0019\u00164X\r\u001c\t\u0005\u0003w\u0019)#\u0003\u0003\u0004(\u0005u\"a\u0005,bY&$\u0017\r^5p]RK\b/\u001a'fm\u0016d\u0017!C4fi2{wmZ3s)\u0005a\b")
public class DataWeaveToolingService
implements ToolingService {
    private WeaveToolingService _documentService;
    private final ProjectMetadata project;
    private final VirtualFileSystem vfs;
    public final DiagnosticsPublisherService org$mule$weave$lsp$services$DataWeaveToolingService$$publisherService;
    private WeaveToolingServiceFactory documentServiceFactory;
    private final Executor executor;
    private final Logger logger;
    private ProjectKind projectKind;
    private WeaveValidator[] customValidators;
    private volatile boolean indexed;
    private volatile boolean bitmap$0;

    public ProjectMetadata project() {
        return this.project;
    }

    public VirtualFileSystem vfs() {
        return this.vfs;
    }

    private Logger logger() {
        return this.logger;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private WeaveToolingService _documentService$lzycompute() {
        DataWeaveToolingService dataWeaveToolingService = this;
        synchronized (dataWeaveToolingService) {
            if (!this.bitmap$0) {
                this._documentService = this.documentServiceFactory.create();
                this.bitmap$0 = true;
            }
        }
        this.documentServiceFactory = null;
        return this._documentService;
    }

    private WeaveToolingService _documentService() {
        if (!this.bitmap$0) {
            return this._documentService$lzycompute();
        }
        return this._documentService;
    }

    private WeaveValidator[] customValidators() {
        return this.customValidators;
    }

    private void customValidators_$eq(WeaveValidator[] x$1) {
        this.customValidators = x$1;
    }

    public boolean indexed() {
        return this.indexed;
    }

    public void indexed_$eq(boolean x$1) {
        this.indexed = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.customValidators_$eq(projectKind.customValidators());
        eventBus.register(SettingsChangedEvent$.MODULE$.SETTINGS_CHANGED(), new OnSettingsChanged(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onSettingsChanged(String[] modifiedSettingsName) {
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modifiedSettingsName)).contains((Object)Settings$.MODULE$.LANGUAGE_LEVEL_PROP_NAME())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("settingsChanged");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(IndexingFinishedEvent$.MODULE$.INDEXING_FINISHED(), new OnIndexingFinished(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onIndexingFinished(Enumeration.Value indexingType) {
                if (IndexingType$.MODULE$.Dependencies().equals((Object)indexingType)) {
                    this.$outer.indexed_$eq(true);
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("indexingFinishes");
                    return;
                }
                if (IndexingType$.MODULE$.Project().equals((Object)indexingType)) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("indexingFinishes");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onProjectStarted(ProjectMetadata projectMetadata) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("projectStarted");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectVirtualFileCreatedEvent$.MODULE$.VIRTUAL_FILE_CREATED(), new OnProjectVirtualFileCreatedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileCreated(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateFile(vf, "onCreated");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$4.$anonfun$onVirtualFileCreated$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileCreated$1($anon$4 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileCreated$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$4 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileChangedEvent$.MODULE$.VIRTUAL_FILE_CHANGED(), new OnProjectVirtualFileChangedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileChanged(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateFile(vf, "onChanged");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$5.$anonfun$onVirtualFileChanged$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileChanged$1($anon$5 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileChanged$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$5 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileDeletedEvent$.MODULE$.VIRTUAL_FILE_DELETED(), new OnProjectVirtualFileDeletedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileDeleted(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, "onDeleted");
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$publisherService.publishDiagnostics(new PublishDiagnosticsParams(vf.url(), new ArrayList<E>()));
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$6.$anonfun$onVirtualFileDeleted$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileDeleted$1($anon$6 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileDeleted$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$6 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
    }

    public Option<org.mule.weave.v2.editor.VirtualFile> org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(String str) {
        SampleDataComponent sampleDataManager = this.projectKind().sampleDataManager();
        return this.documentService().openEditors().find((Function1 & Serializable & scala.Serializable)oe -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.MODULE$.isChildOfAny(str, (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleDataManager.listScenarios(oe.file().getNameIdentifier()))).map((Function1 & Serializable & scala.Serializable)scenario -> scenario.file(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))))).map((Function1 & Serializable & scala.Serializable)weaveDocToolingService -> weaveDocToolingService.file());
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors(String reason) {
        Seq services = (Seq)this.documentService().openEditors().map((Function1 & Serializable & scala.Serializable)openEditor -> openEditor.file().url(), Seq$.MODULE$.canBuildFrom());
        this.documentService().invalidateAll();
        services.foreach((Function1 & Serializable & scala.Serializable)url -> {
            DataWeaveToolingService.$anonfun$validateAllEditors$2(this, reason, url);
            return BoxedUnit.UNIT;
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(org.mule.weave.v2.editor.VirtualFile vf, String reason) {
        NameIdentifier fileLogicalName = vf.getNameIdentifier();
        Seq dependants = this.documentService().dependantsOf(fileLogicalName);
        this.logger().debug(new StringBuilder(25).append("Validate dependants of ").append(fileLogicalName).append(": ").append(dependants.mkString("[", ",", "]")).toString());
        dependants.foreach((Function1 & Serializable & scala.Serializable)ni -> {
            DataWeaveToolingService.$anonfun$validateDependencies$1(this, vf, reason, ni);
            return BoxedUnit.UNIT;
        });
    }

    public Option<WeaveType> loadType(String typeString) {
        return this.documentService().loadType(typeString);
    }

    private WeaveToolingService documentService() {
        return this._documentService();
    }

    public Option<MappingInput> inputOf(String uri, String inputName) {
        WeaveDocumentToolingService documentToolingService = this.openDocument(uri);
        return documentToolingService.inputOf(inputName);
    }

    public Optional<ContextMetadata> contextMetadataFor(String uri) {
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf != null) {
            return this.projectKind().metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        }
        return Optional.empty();
    }

    public WeaveDocumentToolingService openDocument(String uri) {
        Optional<ContextMetadata> maybeContext = this.contextMetadataFor(uri);
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput(), this.openDocument$default$4());
        }
        return this.openDocumentWithoutContext(uri, this.openDocumentWithoutContext$default$2());
    }

    public WeaveDocumentToolingService openInMemoryDocument(String uri) {
        Optional<ContextMetadata> maybeContext = this.contextMetadataFor(uri);
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput(), true);
        }
        return this.openDocumentWithoutContext(uri, true);
    }

    public WeaveDocumentToolingService openDocument(String uri, Optional<ContextMetadata> maybeContext) {
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput(), this.openDocument$default$4());
        }
        return this.openDocument(uri);
    }

    private WeaveDocumentToolingService openDocumentWithoutContext(String uri, boolean inMemory) {
        if (inMemory) {
            return this._documentService().openInMemory(this.vfs().file(uri), ImplicitInput$.MODULE$.apply(), Option$.MODULE$.empty());
        }
        return this._documentService().open(uri, ImplicitInput$.MODULE$.apply(), Option$.MODULE$.empty());
    }

    private WeaveDocumentToolingService openDocument(String uri, @Nullable InputMetadata input, @Nullable DWType expectedOutput, boolean inMemory) {
        None$ output;
        None$ none$;
        if (expectedOutput != null) {
            if (!(expectedOutput instanceof WeaveType)) {
                throw new IllegalArgumentException(new StringBuilder(83).append("Unexpected `expectedOutput` instance, please, contact the extension owner. Actual: ").append(expectedOutput.getClass().getName()).toString());
            }
            none$ = new Some((Object)((WeaveType)expectedOutput));
        } else {
            none$ = output = None$.MODULE$;
        }
        if (inMemory) {
            return this._documentService().openInMemory(this.vfs().file(uri), WeaveTypeUtils$.MODULE$.toImplicitInput(input), (Option)output);
        }
        return this._documentService().open(uri, WeaveTypeUtils$.MODULE$.toImplicitInput(input), (Option)output);
    }

    private boolean openDocumentWithoutContext$default$2() {
        return false;
    }

    private boolean openDocument$default$4() {
        return false;
    }

    public void closeDocument(String uri) {
        this.documentService().close(uri);
    }

    private WeaveToolingService withLanguageLevel(String dwLanguageLevel) {
        return this._documentService().updateLanguageLevel(SVersion$.MODULE$.fromString(dwLanguageLevel));
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateFile(org.mule.weave.v2.editor.VirtualFile vf, String reason) {
        this.triggerValidation(vf.url(), reason, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, reason));
    }

    public void triggerValidation(String documentUri, String reason, Function0<BoxedUnit> onValidationFinish) {
        this.logger().debug(new StringBuilder(30).append("TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
        CompletableFuture.runAsync(() -> {
            this.logger().debug(new StringBuilder(40).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] Init TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
            this.withLanguageLevel(this.projectKind().dependencyManager().dwVersion());
            ValidationMessages messages = this.validate(documentUri, this.validate$default$2());
            List<Diagnostic> diagnostics = this.toDiagnostics(messages);
            this.logger().debug(new StringBuilder(58).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] TriggerValidation finished: ").append(documentUri).append(" reason ").append(reason).append(". Diagnostics: [").append(diagnostics).append("]").toString());
            $this.org$mule$weave$lsp$services$DataWeaveToolingService$$publisherService.publishDiagnostics(new PublishDiagnosticsParams(documentUri, diagnostics));
            onValidationFinish.apply$mcV$sp();
        }, this.executor);
    }

    public Function0<BoxedUnit> triggerValidation$default$3() {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
    }

    public List<Diagnostic> toDiagnostics(ValidationMessages messages) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Error))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Warning))));
        return diagnostics;
    }

    public QuickFix[] quickFixesFor(String documentUri, int startOffset, int endOffset, String kind, String severity, Optional<ContextMetadata> maybeContext) {
        ValidationMessages messages = this.validate(documentUri, maybeContext);
        String string = severity;
        String string2 = DiagnosticSeverity.Error.name();
        Option messageFound = !(string != null ? !string.equals(string2) : string2 != null) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset))) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset)));
        return (QuickFix[])messageFound.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.quickFix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (QuickFix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QuickFix.class)));
    }

    public Optional<ContextMetadata> quickFixesFor$default$6() {
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesMessage(ValidationMessage m, String kind, int startOffset, int endOffset) {
        if (m.location().startPosition().index() != startOffset) return false;
        if (m.location().endPosition().index() != endOffset) return false;
        String string = LSPConverters$.MODULE$.toDiagnosticKind(m);
        String string2 = kind;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public ValidationMessages validate(String documentUri, Optional<ContextMetadata> maybeContext) {
        WeaveDocumentToolingService documentToolingService;
        WeaveDocumentToolingService weaveDocumentToolingService;
        if (this.projectKind().vfs().file(documentUri).readOnly()) {
            return new ValidationMessages((ValidationMessage[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ValidationMessage.class)), (ValidationMessage[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ValidationMessage.class)));
        }
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            weaveDocumentToolingService = this.openDocument(documentUri, context.getInputMetadata(), context.getOutput(), this.openDocument$default$4());
        } else {
            Optional<ContextMetadata> maybeContext2 = this.contextMetadataFor(documentUri);
            if (maybeContext2.isPresent()) {
                ContextMetadata context = maybeContext2.get();
                weaveDocumentToolingService = this.openDocument(documentUri, context.getInputMetadata(), null, this.openDocument$default$4());
            } else {
                weaveDocumentToolingService = documentToolingService = this.openDocumentWithoutContext(documentUri, this.openDocumentWithoutContext$default$2());
            }
        }
        ValidationMessages messages = this.indexed() && Settings$.MODULE$.isTypeLevel(this.project().settings()) ? documentToolingService.typeCheck().concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.SCOPE)).concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.TYPE)) : (this.indexed() && Settings$.MODULE$.isScopeLevel(this.project().settings()) ? documentToolingService.scopeCheck().concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.SCOPE)) : documentToolingService.parseCheck());
        return messages;
    }

    public Optional<ContextMetadata> validate$default$2() {
        return Optional.empty();
    }

    private ValidationMessages applyCustomValidations(String documentUri, WeaveDocumentToolingService documentToolingService, ValidationTypeLevel typeLevel) {
        return (ValidationMessages)documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dwAstNode()).map((Function1 & Serializable & scala.Serializable)rootDwAstNode -> {
            TypePhaseCategory$ category = TypePhaseCategory$.MODULE$;
            ValidationTypeLevel validationTypeLevel = typeLevel;
            ValidationTypeLevel validationTypeLevel2 = ValidationTypeLevel.SCOPE;
            if (!(validationTypeLevel != null ? !validationTypeLevel.equals(validationTypeLevel2) : validationTypeLevel2 != null)) {
                category = ScopePhaseCategory$.MODULE$;
            }
            MessageValidationCollectorAdapter messageCollector = new MessageValidationCollectorAdapter((MessageCategory)category);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.customValidators())).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.appliesTo(documentUri))))).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DataWeaveToolingService.$anonfun$applyCustomValidations$4(typeLevel, v))))).foreach((Function1 & Serializable & scala.Serializable)v -> {
                DataWeaveToolingService.$anonfun$applyCustomValidations$5(this, documentUri, rootDwAstNode, messageCollector, v);
                return BoxedUnit.UNIT;
            });
            return messageCollector.getValidationMessages();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ValidationMessages((ValidationMessage[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ValidationMessage.class)), (ValidationMessage[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ValidationMessage.class))));
    }

    public Logger getLogger() {
        return this.logger();
    }

    public static final /* synthetic */ void $anonfun$validateAllEditors$2(DataWeaveToolingService $this, String reason$1, String url) {
        if (VFUtils$.MODULE$.isDWFile(url) && ProjectStructureHelper$.MODULE$.isAProjectFile(url, $this.projectKind().structure())) {
            $this.triggerValidation(url, reason$1, $this.triggerValidation$default$3());
            return;
        }
        $this.org$mule$weave$lsp$services$DataWeaveToolingService$$publisherService.publishDiagnostics(new PublishDiagnosticsParams(url, Collections.emptyList()));
    }

    public static final /* synthetic */ void $anonfun$validateDependencies$1(DataWeaveToolingService $this, org.mule.weave.v2.editor.VirtualFile vf$1, String reason$2, NameIdentifier ni) {
        Option option = vf$1.fs().asResourceResolver().resolve(ni);
        if (option instanceof Some) {
            Some some = (Some)option;
            WeaveResource resource = (WeaveResource)some.value();
            $this.triggerValidation(resource.url(), new StringBuilder(20).append("dependantChanged ->").append(reason$2).append(" ").append(vf$1.url()).toString(), $this.triggerValidation$default$3());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.logger().warn(new StringBuilder(27).append("No resource found for file ").append(vf$1.url()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$applyCustomValidations$4(ValidationTypeLevel typeLevel$1, WeaveValidator v) {
        ValidationTypeLevel validationTypeLevel = v.validationLevel();
        ValidationTypeLevel validationTypeLevel2 = typeLevel$1;
        return !(validationTypeLevel != null ? !validationTypeLevel.equals(validationTypeLevel2) : validationTypeLevel2 != null);
    }

    public static final /* synthetic */ void $anonfun$applyCustomValidations$5(DataWeaveToolingService $this, String documentUri$2, DWAstNode rootDwAstNode$1, MessageValidationCollectorAdapter messageCollector$1, WeaveValidator v) {
        try {
            v.validate(new DocumentNode(documentUri$2, rootDwAstNode$1), (MessageValidationCollector)messageCollector$1, new MessageBuilderFactory(null){

                public MessageBuilder createMessageBuilder() {
                    return new DefaultMessageBuilder();
                }
            });
        }
        catch (Exception e) {
            $this.getLogger().error(new StringBuilder(53).append("There was an error while executing custom validator: ").append(v.getClass()).toString(), (Throwable)e);
        }
    }

    public DataWeaveToolingService(ProjectMetadata project, VirtualFileSystem vfs, DiagnosticsPublisherService publisherService, WeaveToolingServiceFactory documentServiceFactory, Executor executor) {
        this.project = project;
        this.vfs = vfs;
        this.org$mule$weave$lsp$services$DataWeaveToolingService$$publisherService = publisherService;
        this.documentServiceFactory = documentServiceFactory;
        this.executor = executor;
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.indexed = false;
    }
}

