/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.Debouncer;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnActiveScenarioChanged;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.services.exception.RunPreviewException;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\u0013&\u0001AB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001di\u0006A1A\u0005\nyCa!\u001a\u0001!\u0002\u0013y\u0006\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0011%q\u0007\u00011AA\u0002\u0013%q\u000eC\u0005v\u0001\u0001\u0007\t\u0011)Q\u0005Q\"Ia\u000f\u0001a\u0001\u0002\u0004%Ia\u001e\u0005\n}\u0002\u0001\r\u00111A\u0005\n}D!\"a\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003y\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0002\u0012!A\u0011Q\u0003\u0001!B\u0013\tI\u0001C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"!I\u0011\u0011\b\u0001A\u0002\u0013%\u00111\b\u0005\t\u0003\u007f\u0001\u0001\u0015)\u0003\u0002$!I\u0011\u0011\t\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0005\u0003\u000bB\u0001\"!\u0013\u0001A\u0003&\u00111\u0005\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001bB\u0001\"!\u001b\u0001A\u0003%\u0011q\n\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a\u001d\u0001\t\u0003\t\t\tC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002,\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBA^\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011%\t9\u000eAI\u0001\n\u0003\tI\u000eC\u0004\u0002p\u0002!\t!!=\t\u000f\u0005M\b\u0001\"\u0001\u0002r\nq\u0001K]3wS\u0016<8+\u001a:wS\u000e,'B\u0001\u0014(\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\u0015*\u0003\ra7\u000f\u001d\u0006\u0003U-\nQa^3bm\u0016T!\u0001L\u0017\u0002\t5,H.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA\u0014(D\u0001&\u0013\tQTE\u0001\bU_>d\u0017N\\4TKJ4\u0018nY3\u0002\u0019\u0005<WM\u001c;TKJ4\u0018nY3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}:\u0013!B1hK:$\u0018BA!?\u0005E9V-\u0019<f\u0003\u001e,g\u000e^*feZL7-Z\u0001\u0014o\u0016\fg/\u001a'b]\u001e,\u0018mZ3DY&,g\u000e\u001e\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003\u0011\u001e\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005)+%a\u0006#bi\u0006<V-\u0019<f!J|Go\\2pY\u000ec\u0017.\u001a8u\u0003=!xn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\u001c\bC\u0001\u001dN\u0013\tqUEA\fECR\fw+Z1wKR{w\u000e\\5oON+'O^5dK\u0006Q!n\u001c2NC:\fw-\u001a:\u0011\u0005E#V\"\u0001*\u000b\u0005M;\u0013\u0001\u00026pENL!!\u0016*\u0003#){'-T1oC\u001e,'oU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u00061fS6\f\u0018\t\u0003q\u0001AQaO\u0003A\u0002qBQAQ\u0003A\u0002\rCQaS\u0003A\u00021CQaT\u0003A\u0002A\u000ba\u0001\\8hO\u0016\u0014X#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tl\u0013!B:mMRR\u0017B\u00013b\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001C3wK:$()^:\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a[\u0014\u0002\u000bU$\u0018\u000e\\:\n\u00055T'\u0001E%oi\u0016\u0014h.\u00197Fm\u0016tGOQ;t\u00031)g/\u001a8u\u0005V\u001cx\fJ3r)\t\u00018\u000f\u0005\u00023c&\u0011!o\r\u0002\u0005+:LG\u000fC\u0004u\u0013\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0013'A\u0005fm\u0016tGOQ;tA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\u0005A\bCA=}\u001b\u0005Q(BA>(\u0003\u001d\u0001(o\u001c6fGRL!! >\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\u0010aJ|'.Z2u\u0017&tGm\u0018\u0013fcR\u0019\u0001/!\u0001\t\u000fQd\u0011\u0011!a\u0001q\u0006a\u0001O]8kK\u000e$8*\u001b8eA\u0005YQM\\1cY\u00164\u0016\r\\;f+\t\tI\u0001E\u00023\u0003\u0017I1!!\u00044\u0005\u001d\u0011un\u001c7fC:\fq\"\u001a8bE2,g+\u00197vK~#S-\u001d\u000b\u0004a\u0006M\u0001\u0002\u0003;\u0010\u0003\u0003\u0005\r!!\u0003\u0002\u0019\u0015t\u0017M\u00197f-\u0006dW/\u001a\u0011)\u0007A\tI\u0002E\u00023\u00037I1!!\b4\u0005!1x\u000e\\1uS2,\u0017a\u00059f]\u0012Lgn\u001a)s_*,7\r^*uCJ$XCAA\u0012!\u0015\u0011\u0014QEA\u0015\u0013\r\t9c\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u00051Q\rZ5u_JT1!a\r*\u0003\t1('\u0003\u0003\u00028\u00055\"a\u0003,jeR,\u0018\r\u001c$jY\u0016\fq\u0003]3oI&tw\r\u0015:pU\u0016\u001cGo\u0015;beR|F%Z9\u0015\u0007A\fi\u0004\u0003\u0005u%\u0005\u0005\t\u0019AA\u0012\u0003Q\u0001XM\u001c3j]\u001e\u0004&o\u001c6fGR\u001cF/\u0019:uA\u0005\u00012-\u001e:sK:$hK\u001a)sKZLWm^\u0001\u0015GV\u0014(/\u001a8u-\u001a\u0004&/\u001a<jK^|F%Z9\u0015\u0007A\f9\u0005\u0003\u0005u+\u0005\u0005\t\u0019AA\u0012\u0003E\u0019WO\u001d:f]R4f\r\u0015:fm&,w\u000fI\u0001\u0011aJ,g/[3x\t\u0016\u0014w.\u001e8dKJ,\"!a\u0014\u0011\u000ba\n\t&!\u0016\n\u0007\u0005MSEA\u0005EK\n|WO\\2feB!\u0011qKA3\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!\u0003<be&\f'\r\\3t\u0015\u0011\ty&!\u0019\u0002\u0007\u0005\u001cHO\u0003\u0003\u0002d\u0005E\u0012A\u00029beN,'/\u0003\u0003\u0002h\u0005e#A\u0004(b[\u0016LE-\u001a8uS\u001aLWM]\u0001\u0012aJ,g/[3x\t\u0016\u0014w.\u001e8dKJ\u0004\u0013AC5oSRL\u0017\r\\5{KR)\u0001/a\u001c\u0002r!)a/\u0007a\u0001q\")a-\u0007a\u0001Q\u0006Q!/\u001e8Qe\u00164\u0018.Z<\u0015\t\u0005]\u0014Q\u0010\t\u0004\t\u0006e\u0014bAA>\u000b\ni\u0001K]3wS\u0016<(+Z:vYRDq!a \u001b\u0001\u0004\tI#\u0001\u0002wMRA\u0011qOAB\u0003;\u000b\t\u000bC\u0004\u0002\u0006n\u0001\r!a\"\u0002\u000f\u0019LG.Z+sYB!\u0011\u0011RAL\u001d\u0011\tY)a%\u0011\u0007\u000555'\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S\u0018\u0002\rq\u0012xn\u001c;?\u0013\r\t)jM\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00151\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U5\u0007C\u0004\u0002 n\u0001\r!!\u0016\u0002\u0015%$WM\u001c;jM&,'\u000fC\u0004\u0002$n\u0001\r!a\"\u0002\u000f\r|g\u000e^3oi\u0006i1-\u00198Sk:\u0004&/\u001a<jK^$B!!\u0003\u0002*\"9\u0011q\u0010\u000fA\u0002\u0005%BCBA\u0005\u0003[\u000by\u000bC\u0004\u0002\u0000u\u0001\r!!\u000b\t\u000f\u0005EV\u00041\u0001\u00024\u0006\u0001b-\u001b7f\u0017&tGMU3t_24XM\u001d\t\u0006e\u0005U\u0016\u0011X\u0005\u0004\u0003o\u001b$!\u0003$v]\u000e$\u0018n\u001c81!\u0015\u0011\u0014QEAD\u0003!1\u0017\u000e\\3LS:$G\u0003BA]\u0003\u007fCq!!\"\u001f\u0001\u0004\t9\t\u0006\u0003\u0002:\u0006\r\u0007bBAc?\u0001\u0007\u0011qY\u0001\u0017I>\u001cW/\\3oiR{w\u000e\\5oON+'O^5dKB!\u00111FAe\u0013\u0011\tY-!\f\u00037]+\u0017M^3E_\u000e,X.\u001a8u)>|G.\u001b8h'\u0016\u0014h/[2f\u0003I\u00198\r[3ek2,'+\u001e8Qe\u00164\u0018.Z<\u0015\r\u0005]\u0014\u0011[Aj\u0011\u001d\ty\b\ta\u0001\u0003SA\u0011\"!6!!\u0003\u0005\r!!\u0003\u0002\tMLhnY\u0001\u001dg\u000eDW\rZ;mKJ+h\u000e\u0015:fm&,w\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYN\u000b\u0003\u0002\n\u0005u7FAAp!\u0011\t\t/a;\u000e\u0005\u0005\r(\u0002BAs\u0003O\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%8'\u0001\u0006b]:|G/\u0019;j_:LA!!<\u0002d\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\r\u0015t\u0017M\u00197f)\u0005\u0001\u0018a\u00023jg\u0006\u0014G.\u001a")
public class PreviewService
implements ToolingService {
    private final WeaveAgentService agentService;
    private final DataWeaveProtocolClient weaveLanguageClient;
    private final DataWeaveToolingService toolingServices;
    private final JobManagerService jobManager;
    private final Logger logger;
    private InternalEventBus eventBus;
    private ProjectKind projectKind;
    private volatile boolean org$mule$weave$lsp$services$PreviewService$$enableValue;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    private final Debouncer<NameIdentifier> previewDebouncer;

    private Logger logger() {
        return this.logger;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public boolean org$mule$weave$lsp$services$PreviewService$$enableValue() {
        return this.org$mule$weave$lsp$services$PreviewService$$enableValue;
    }

    private void org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(boolean x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart() {
        return this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    }

    public void org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview() {
        return this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    }

    private void org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = x$1;
    }

    private Debouncer<NameIdentifier> previewDebouncer() {
        return this.previewDebouncer;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this, projectKind){
            private final /* synthetic */ PreviewService $outer;
            private final ProjectKind projectKind$1;

            public void onFileChanged(String uri, FileChangeType changeType) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue()) {
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().map((Function1 & Serializable & scala.Serializable)currentVFPreview -> $this.projectKind$1.sampleDataManager().searchSampleDataFolderFor(currentVFPreview.getNameIdentifier()).map((Function1 & Serializable & scala.Serializable)scenarioFolder -> {
                        if (URLUtils$.MODULE$.isChildOf(uri, (File)scenarioFolder) || URLUtils$.MODULE$.isChildOf(URLUtils$.MODULE$.toLSPUrl(scenarioFolder.getPath()), uri)) {
                            return $this.$outer.scheduleRunPreview((VirtualFile)currentVFPreview, $this.$outer.scheduleRunPreview$default$2());
                        }
                        return BoxedUnit.UNIT;
                    }));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile ), $anonfun$onFileChanged$2(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ PreviewService $outer;

            public void onProjectStarted(ProjectMetadata metadata) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().isDefined()) {
                    this.$outer.scheduleRunPreview((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().get(), this.$outer.scheduleRunPreview$default$2());
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)None$.MODULE$);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ActiveScenarioChangedEvent$.MODULE$.ACTIVE_SCENARIO_CHANGED(), new OnActiveScenarioChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onActiveScenarioChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().isDefined() && ((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().get()).url().equals(vf.url()) && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public PreviewResult runPreview(VirtualFile vf) {
        String fileUrl = vf.url();
        if (!this.projectKind().isStarted()) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = "Project is not yet initialized.\nPreview is going to be executed once project initializes.";
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            return new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
        }
        NameIdentifier identifier = vf.getNameIdentifier();
        String content = vf.read();
        this.logger().debug(new StringBuilder(27).append("Trigger run preview for `").append(identifier).append("`.").toString());
        return this.runPreview(fileUrl, identifier, content);
    }

    public PreviewResult runPreview(String fileUrl, NameIdentifier identifier, String content) {
        return this.agentService.run(identifier, content, fileUrl);
    }

    public boolean canRunPreview(VirtualFile vf) {
        return URLUtils$.MODULE$.isDWFile(vf.url()) && this.canRunPreview(vf, (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(vf.url()));
    }

    private boolean canRunPreview(VirtualFile vf, Function0<Option<String>> fileKindResolver) {
        if (vf == null) {
            return false;
        }
        Option<URI> fileUrl = URLUtils$.MODULE$.toURI(vf.url());
        if (fileUrl.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$canRunPreview$2(p)))) {
            return false;
        }
        Option mayBeKind = (Option)fileKindResolver.apply();
        boolean isMapping = mayBeKind.forall((Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)kind.equals(WeaveASTQueryUtils$.MODULE$.MAPPING())));
        return !vf.readOnly() && isMapping;
    }

    private Option<String> fileKind(String fileUrl) {
        return this.fileKind(this.toolingServices.openDocument(fileUrl));
    }

    private Option<String> fileKind(WeaveDocumentToolingService documentToolingService) {
        Option maybeAstNode = documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.astNode());
        Option<String> mayBeKind = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
        return mayBeKind;
    }

    public PreviewResult scheduleRunPreview(VirtualFile vf, boolean sync) {
        String fileUrl = vf.url();
        if (!this.canRunPreview(vf)) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = new StringBuilder(42).append("File `").append(vf.getNameIdentifier().name()).append("` is not an executable mapping file.").toString();
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            PreviewResult previewResult = new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
            if (sync) {
                return previewResult;
            }
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else if (!this.projectKind().isStarted()) {
            if (sync) {
                throw new RunPreviewException("Project is not yet initialized, preview cannot be executed at this time.");
            }
            this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)new Some((Object)vf));
            PreviewResult previewResult = this.runPreview(vf);
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else {
            if (sync) {
                return this.runPreview(vf);
            }
            NameIdentifier identifier = vf.getNameIdentifier();
            this.previewDebouncer().debounce(identifier, () -> $this.jobManager.execute(x$2 -> $this.weaveLanguageClient.showPreviewResult(this.runPreview(vf)), "Running preview", new StringBuilder(19).append("Running preview of ").append(identifier).toString()), 300L, TimeUnit.MILLISECONDS);
        }
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)new Some((Object)vf));
        return null;
    }

    public boolean scheduleRunPreview$default$2() {
        return false;
    }

    public void enable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(true);
    }

    public void disable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(false);
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$canRunPreview$2(URI p) {
        String string = p.getScheme();
        String string2 = "preview";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PreviewService(WeaveAgentService agentService, DataWeaveProtocolClient weaveLanguageClient, DataWeaveToolingService toolingServices, JobManagerService jobManager) {
        this.agentService = agentService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.toolingServices = toolingServices;
        this.jobManager = jobManager;
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = false;
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = None$.MODULE$;
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = None$.MODULE$;
        this.previewDebouncer = new Debouncer();
    }
}

