package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.mule.weave.lsp.commands.Commands.argAsBoolean
import org.mule.weave.lsp.commands.Commands.argAsString
import org.mule.weave.lsp.services.PreviewService
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WorkspaceServiceManager
import org.mule.weave.lsp.vfs.ProjectFileSystemService
import org.mule.weave.v2.editor.VirtualFile

class EnablePreviewModeCommand(workspaceServiceManager: WorkspaceServiceManager, uIService: UIService) extends InternalWeaveCommand {
  override def commandId(): String = Commands.DW_ENABLE_PREVIEW

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val enabled = argAsBoolean(params.getArguments, 0)
    val uri = argAsString(params.getArguments, 1)

    val maybeProjectKind = workspaceServiceManager.projectKind(uri)
    if (maybeProjectKind.isDefined) {
      val projectKind = maybeProjectKind.get
      val previewService: PreviewService = projectKind.toolingService(classOf[PreviewService])
      if (enabled) {
        previewService.enable()
        val file: VirtualFile = projectKind.vfs().file(uri)
        if (file != null) {
          previewService.scheduleRunPreview(file)
        }
      } else {
        previewService.disable()
      }
    } else {
      uIService.showMessage(new MessageParams(MessageType.Error, s"No project is associated to: ${uri}. ${commandId} cannot be executed"))
    }
    null
  }

  override def name(): String = "Enables Preview."

  override def description(params: ExecuteCommandParams): String = "Enables preview."

  override def enabled(uri: String): Boolean = {
    val maybeProjectKind = workspaceServiceManager.projectKind(uri)
    if (maybeProjectKind.isDefined) {
      val projectKind = maybeProjectKind.get
      projectKind.toolingService(classOf[PreviewService]).canRunPreview(projectKind.toolingService(classOf[ProjectFileSystemService]).file(uri))
    } else {
      false
    }
  }
}
