/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.agent;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.weave.extension.api.component.dependency.DependencyArtifact;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.AgentClasspathResolver;
import org.mule.weave.lsp.agent.FutureValue;
import org.mule.weave.lsp.agent.FutureValue$;
import org.mule.weave.lsp.agent.WeaveTypeBind;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ClassPathConfig;
import org.mule.weave.lsp.project.components.ClassPathConfig$;
import org.mule.weave.lsp.project.components.JavaWeaveLauncher$;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.events.DependencyArtifactResolvedEvent$;
import org.mule.weave.lsp.project.events.OnDependencyArtifactResolved;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.AgentStartedEvent;
import org.mule.weave.lsp.services.events.AgentStoppedEvent;
import org.mule.weave.lsp.utils.IOUtils$;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.utils.ProcessStreamLineConsumer;
import org.mule.weave.v2.agent.api.event.DataFormatsDefinitionsEvent;
import org.mule.weave.v2.agent.api.event.ImplicitInputTypesEvent;
import org.mule.weave.v2.agent.api.event.InferWeaveTypeEvent;
import org.mule.weave.v2.agent.api.event.ModuleResolvedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedFailedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedSuccessfulEvent;
import org.mule.weave.v2.agent.api.event.UnexpectedServerErrorEvent;
import org.mule.weave.v2.agent.api.event.WeaveDataFormatDescriptor;
import org.mule.weave.v2.agent.api.event.WeaveDataFormatProperty;
import org.mule.weave.v2.agent.client.ClientProtocol;
import org.mule.weave.v2.agent.client.ConnectionRetriesListener;
import org.mule.weave.v2.agent.client.DataFormatDefinitionListener;
import org.mule.weave.v2.agent.client.ImplicitWeaveTypesListener;
import org.mule.weave.v2.agent.client.ModuleLoadedListener;
import org.mule.weave.v2.agent.client.PreviewExecutedListener;
import org.mule.weave.v2.agent.client.WeaveAgentClient;
import org.mule.weave.v2.agent.client.WeaveTypeInferListener;
import org.mule.weave.v2.agent.client.tcp.TcpClientProtocol;
import org.mule.weave.v2.completion.DataFormatDescriptor;
import org.mule.weave.v2.completion.DataFormatDescriptor$;
import org.mule.weave.v2.completion.DataFormatProperty;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.ts.WeaveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r%b\u0001B\u001c9\u0001\rC\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u000bY\u0004A\u0011A<\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003;\u0001!\u0019!C\u0001\u0003?A\u0001\"!\f\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003_\u0001!\u0019!C\u0001\u0003?A\u0001\"!\r\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003g\u0001!\u0019!C\u0001\u0003?A\u0001\"!\u000e\u0001A\u0003%\u0011\u0011\u0005\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA(\u0001\u0001\u0007\t\u0011)Q\u0005\u0003wA1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002T!Y\u0011q\r\u0001A\u0002\u0003\u0007I\u0011BA5\u0011-\ti\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0016\t\u0017\u0005=\u0004\u00011AA\u0002\u0013%\u0011\u0011\u000f\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0004\u0002\u0001\r\u0011!Q!\n\u0005M\u0004bCAC\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fC1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\"Y\u00111\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BAE\u0011%\ti\n\u0001b\u0001\n\u0013\ty\n\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAQ\u0011-\ty\u000b\u0001a\u0001\u0002\u0004%I!!-\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0019\u0005\f\u0003\u000b\u0004\u0001\u0019!A!B\u0013\t\u0019\fC\u0004\u0002H\u0002!\t%!3\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u00111\u001b\u0001\u0005\u0002\u0005E\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\tI\u000f\u0001C!\u0003#Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u0003\u0018\u0001!\tA!\u0007\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003J!9!1\n\u0001\u0005\n\u0005\u0005\bb\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u0005G\u0002A\u0011\u0001B3\u0011\u001d\u00119\b\u0001C\u0001\u0005sBqAa\u001e\u0001\t\u0003\u0011I\u000bC\u0004\u0003X\u0002!IA!7\t\u0013\t\u0005\b!%A\u0005\n\t\r\bb\u0002B}\u0001\u0011\u0005!1 \u0005\b\u0007\u001b\u0001A\u0011BB\b\u0011\u001d\u0019)\u0003\u0001C!\u0003#Dqaa\n\u0001\t\u0013\t\tNA\tXK\u00064X-Q4f]R\u001cVM\u001d<jG\u0016T!!\u000f\u001e\u0002\u000b\u0005<WM\u001c;\u000b\u0005mb\u0014a\u00017ta*\u0011QHP\u0001\u0006o\u0016\fg/\u001a\u0006\u0003\u007f\u0001\u000bA!\\;mK*\t\u0011)A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\t*\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0007CA&O\u001b\u0005a%BA';\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018BA(M\u00059!vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\f\u0011C^1mS\u0012\fG/[8o'\u0016\u0014h/[2f!\tY%+\u0003\u0002T\u0019\n9B)\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-Z\u0001\tKb,7-\u001e;peB\u0011a+X\u0007\u0002/*\u0011\u0001,W\u0001\u000bG>t7-\u001e:sK:$(B\u0001.\\\u0003\u0011)H/\u001b7\u000b\u0003q\u000bAA[1wC&\u0011al\u0016\u0002\t\u000bb,7-\u001e;pe\u0006iAn\\4hKJ4\u0015m\u0019;pef\u0004\"aS1\n\u0005\td%aE\"mS\u0016tG\u000fT8hO\u0016\u0014h)Y2u_JL\u0018a\u00029s_*,7\r\u001e\t\u0003K.l\u0011A\u001a\u0006\u0003G\u001eT!\u0001[5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ky\u0005IQ\r\u001f;f]NLwN\\\u0005\u0003Y\u001a\u0014q\u0002\u0015:pU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\u0017g\u000e,g.\u0019:j_6\u000bg.Y4feN+'O^5dKB\u00111j\\\u0005\u0003a2\u00131dV3bm\u0016\u001c6-\u001a8be&|W*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0017!E2mCN\u001c\b/\u0019;i%\u0016\u001cx\u000e\u001c<feB\u00111\u000f^\u0007\u0002q%\u0011Q\u000f\u000f\u0002\u0017\u0003\u001e,g\u000e^\"mCN\u001c\b/\u0019;i%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"r\u0001_={wrlh\u0010\u0005\u0002t\u0001!)\u0001k\u0002a\u0001#\")Ak\u0002a\u0001+\")ql\u0002a\u0001A\")1m\u0002a\u0001I\")Qn\u0002a\u0001]\")\u0011o\u0002a\u0001e\u00061An\\4hKJ,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003A\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\ti!a\u0002\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nAb\u00197jK:$Hj\\4hKJ,\"!!\u0006\u0011\u0007-\u000b9\"C\u0002\u0002\u001a1\u0013Ab\u00117jK:$Hj\\4hKJ\fQb\u00197jK:$Hj\\4hKJ\u0004\u0013\u0001I!H\u000b:#vlU#S-\u0016\u0013v\fT!V\u001d\u000eCUIU0N\u0003&sul\u0011'B'N+\"!!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n\\\u0003\u0011a\u0017M\\4\n\t\u0005-\u0012Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u0002C\u0005;UI\u0014+`'\u0016\u0013f+\u0012*`\u0019\u0006+fj\u0011%F%~k\u0015)\u0013(`\u00072\u000b5k\u0015\u0011\u0002\u00151Ku\t\u0013+`\u000fJ+\u0015,A\u0006M\u0013\u001eCEkX$S\u000bf\u0003\u0013a\u0001*F\t\u0006!!+\u0012#!\u00031\tw-\u001a8u!J|7-Z:t+\t\tY\u0004\u0005\u0003\u0002$\u0005u\u0012\u0002BA \u0003K\u0011q\u0001\u0015:pG\u0016\u001c8/\u0001\tbO\u0016tG\u000f\u0015:pG\u0016\u001c8o\u0018\u0013fcR!\u0011QIA&!\r)\u0015qI\u0005\u0004\u0003\u00132%\u0001B+oSRD\u0011\"!\u0014\u0014\u0003\u0003\u0005\r!a\u000f\u0002\u0007a$\u0013'A\u0007bO\u0016tG\u000f\u0015:pG\u0016\u001c8\u000fI\u0001\u0011o\u0016\fg/Z!hK:$8\t\\5f]R,\"!!\u0016\u0011\t\u0005]\u00131M\u0007\u0003\u00033RA!a\u0017\u0002^\u000511\r\\5f]RT1!OA0\u0015\r\t\t\u0007P\u0001\u0003mJJA!!\u001a\u0002Z\t\u0001r+Z1wK\u0006;WM\u001c;DY&,g\u000e^\u0001\u0015o\u0016\fg/Z!hK:$8\t\\5f]R|F%Z9\u0015\t\u0005\u0015\u00131\u000e\u0005\n\u0003\u001b2\u0012\u0011!a\u0001\u0003+\n\u0011c^3bm\u0016\fu-\u001a8u\u00072LWM\u001c;!\u0003-\u0001(o\u001c6fGR\\\u0015N\u001c3\u0016\u0005\u0005M\u0004\u0003BA;\u0003sj!!a\u001e\u000b\u0005\rT\u0014\u0002BA>\u0003o\u00121\u0002\u0015:pU\u0016\u001cGoS5oI\u0006y\u0001O]8kK\u000e$8*\u001b8e?\u0012*\u0017\u000f\u0006\u0003\u0002F\u0005\u0005\u0005\"CA'3\u0005\u0005\t\u0019AA:\u00031\u0001(o\u001c6fGR\\\u0015N\u001c3!\u0003E\u0019G.Y:ta\u0006$\b.\u0011:hg\u001aKG.Z\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f[\u0016AA5p\u0013\u0011\t\u0019*!$\u0003\t\u0019KG.Z\u0001\u0016G2\f7o\u001d9bi\"\f%oZ:GS2,w\fJ3r)\u0011\t)%!'\t\u0013\u00055C$!AA\u0002\u0005%\u0015AE2mCN\u001c\b/\u0019;i\u0003J<7OR5mK\u0002\nab\u001d;beR\fu-\u001a8u\u0019>\u001c7.\u0006\u0002\u0002\"B!\u00111UAU\u001b\t\t)KC\u0002\u0002(^\u000bQ\u0001\\8dWNLA!a+\u0002&\n!Aj\\2l\u0003=\u0019H/\u0019:u\u0003\u001e,g\u000e\u001e'pG.\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e&(A\u0003vi&d7/\u0003\u0003\u0002>\u0006]&\u0001E%oi\u0016\u0014h.\u00197Fm\u0016tGOQ;t\u00031)g/\u001a8u\u0005V\u001cx\fJ3r)\u0011\t)%a1\t\u0013\u00055\u0013%!AA\u0002\u0005M\u0016!C3wK:$()^:!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0007\u0003\u000b\nY-!4\t\u000f\u0005=4\u00051\u0001\u0002t!9\u0011qV\u0012A\u0002\u0005M\u0016a\u0002:fgR\f'\u000f\u001e\u000b\u0003\u0003\u000b\n!b\u001d;beR\fu-\u001a8u\u00035\tw-\u001a8u\u000bbLGoQ8eKV\u0011\u0011\u0011\u001c\t\u0004\u000b\u0006m\u0017bAAo\r\n\u0019\u0011J\u001c;\u0002\u001d%\u001c\bK]8dKN\u001c\u0018\t\\5wKV\u0011\u00111\u001d\t\u0004\u000b\u0006\u0015\u0018bAAt\r\n9!i\\8mK\u0006t\u0017aC5oSRL\u0017\r\\5{K\u0012\fQ$\u001b8gKJLe\u000e];u\u001b\u0016$\u0018\rZ1uC\u001a{'oU2f]\u0006\u0014\u0018n\u001c\u000b\u0005\u0003_\u00149\u0001E\u0003W\u0003c\f)0C\u0002\u0002t^\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0015)\u0015q_A~\u0013\r\tIP\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0015\u000biP!\u0001\n\u0007\u0005}hIA\u0003BeJ\f\u0017\u0010E\u0002t\u0005\u0007I1A!\u00029\u000559V-\u0019<f)f\u0004XMQ5oI\"9!\u0011B\u0015A\u0002\t-\u0011\u0001C:dK:\f'/[8\u0011\t\t5!1C\u0007\u0003\u0005\u001fQAA!\u0005\u0002x\u0005Q1m\\7q_:,g\u000e^:\n\t\tU!q\u0002\u0002\t'\u000e,g.\u0019:j_\u0006i!/Z:pYZ,Wj\u001c3vY\u0016$bAa\u0007\u0003,\t\r\u0003#\u0002,\u0002r\nu\u0001#B#\u0002x\n}\u0001\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\t\t\u0015\u0012qL\u0001\u0004g\u0012\\\u0017\u0002\u0002B\u0015\u0005G\u0011QbV3bm\u0016\u0014Vm]8ve\u000e,\u0007b\u0002B\u0017U\u0001\u0007!qF\u0001\u000bS\u0012,g\u000e^5gS\u0016\u0014\b\u0003\u0002B\u0019\u0005\u007fqAAa\r\u0003<A\u0019!Q\u0007$\u000e\u0005\t]\"b\u0001B\u001d\u0005\u00061AH]8pizJ1A!\u0010G\u0003\u0019\u0001&/\u001a3fM&!\u00111\u0006B!\u0015\r\u0011iD\u0012\u0005\b\u0005\u000bR\u0003\u0019\u0001B\u0018\u0003\u0019aw.\u00193fe\u0006q1\r[3dW\u000e{gN\\3di\u0016$GCAAr\u00039I7\u000fR5tG>tg.Z2uK\u0012\fa$\u001b8gKJ|U\u000f\u001e9vi6+G/\u00193bi\u00064uN]*dK:\f'/[8\u0015\t\tE#\u0011\r\t\u0006-\u0006E(1\u000b\t\u0006\u000b\u0006](Q\u000b\t\u0005\u0005/\u0012i&\u0004\u0002\u0003Z)!!1LA0\u0003\t!8/\u0003\u0003\u0003`\te#!C,fCZ,G+\u001f9f\u0011\u001d\u0011I!\fa\u0001\u0005\u0017\t1\u0002Z1uC\u001a{'/\\1ugR\u0011!q\r\t\u0006\u000b\u0006u(\u0011\u000e\t\u0005\u0005W\u0012\u0019(\u0004\u0002\u0003n)!!q\u000eB9\u0003\u0015)g/\u001a8u\u0015\rA\u0017QL\u0005\u0005\u0005k\u0012iGA\rXK\u00064X\rR1uC\u001a{'/\\1u\t\u0016\u001c8M]5qi>\u0014\u0018a\u0001:v]RA!1\u0010BE\u0005C\u0013)\u000b\u0005\u0003\u0003~\t\u0015UB\u0001B@\u0015\u0011\u0011\tIa!\u0002\u0011A\u0014x\u000e^8d_2T!A\u001b\u001e\n\t\t\u001d%q\u0010\u0002\u000e!J,g/[3x%\u0016\u001cX\u000f\u001c;\t\u000f\t-u\u00061\u0001\u0003\u000e\u0006qa.Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0003\u0002BH\u0005;k!A!%\u000b\t\tM%QS\u0001\nm\u0006\u0014\u0018.\u00192mKNTAAa&\u0003\u001a\u0006\u0019\u0011m\u001d;\u000b\t\tm\u0015qL\u0001\u0007a\u0006\u00148/\u001a:\n\t\t}%\u0011\u0013\u0002\u000f\u001d\u0006lW-\u00133f]RLg-[3s\u0011\u001d\u0011\u0019k\fa\u0001\u0005_\tqaY8oi\u0016tG\u000fC\u0004\u0003(>\u0002\rAa\f\u0002\u0007U\u0014H\u000e\u0006\n\u0003|\t-&Q\u0016BX\u0005c\u00139L!1\u0003H\nM\u0007b\u0002BFa\u0001\u0007!Q\u0012\u0005\b\u0005G\u0003\u0004\u0019\u0001B\u0018\u0011\u001d\u00119\u000b\ra\u0001\u0005_AqAa-1\u0001\u0004\u0011),A\bqe\u00164\u0018.Z<TG\u0016t\u0017M]5p!\u0015)\u0015q\u001fB\u0006\u0011\u001d\u0011I\f\ra\u0001\u0005w\u000b\u0011C];oi&lW\r\u0015:pa\u0016\u0014H/[3t!!\u0011\tD!0\u00030\t=\u0012\u0002\u0002B`\u0005\u0003\u00121!T1q\u0011\u001d\u0011\u0019\r\ra\u0001\u0005\u000b\fab\\;uaV$X*[7f)f\u0004X\rE\u0003F\u0003o\u0014y\u0003C\u0004\u0003JB\u0002\rAa3\u0002\u00195\f\u0017PY3US6,w.\u001e;\u0011\u000b\u0015\u000b9P!4\u0011\u0007\u0015\u0013y-C\u0002\u0003R\u001a\u0013A\u0001T8oO\"9!Q\u001b\u0019A\u0002\u0005\r\u0018AE<ji\"$Vm\u001d;t\u00072\f7o\u001d9bi\"\fqcY1mGVd\u0017\r^3M_\u000e\fGn\u00117bgN\u0004\u0018\r\u001e5\u0015\t\tm'Q\u001c\t\u0006\u000b\u0006u(q\u0006\u0005\n\u0005?\f\u0004\u0013!a\u0001\u0003G\f\u0011b^5uQR+7\u000f^:\u0002C\r\fGnY;mCR,Gj\\2bY\u000ec\u0017m]:qCRDG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0015(\u0006BAr\u0005O\\#A!;\u0011\t\t-(Q_\u0007\u0003\u0005[TAAa<\u0003r\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005g4\u0015AC1o]>$\u0018\r^5p]&!!q\u001fBw\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013I\u00164\u0017N\\3e\t\u0006$\u0018MR8s[\u0006$8\u000f\u0006\u0002\u0003~B)a+!=\u0003\u0000B)Q)!@\u0004\u0002A!11AB\u0005\u001b\t\u0019)A\u0003\u0003\u0004\b\u0005}\u0013AC2p[BdW\r^5p]&!11BB\u0003\u0005Q!\u0015\r^1G_Jl\u0017\r\u001e#fg\u000e\u0014\u0018\u000e\u001d;pe\u0006\u0001Bo\u001c#bi\u00064uN]7biB\u0013x\u000e\u001d\u000b\u0005\u0007#\u0019I\u0002E\u0003F\u0003{\u001c\u0019\u0002\u0005\u0003\u0004\u0004\rU\u0011\u0002BB\f\u0007\u000b\u0011!\u0003R1uC\u001a{'/\\1u!J|\u0007/\u001a:us\"911\u0004\u001bA\u0002\ru\u0011AG<fCZ,G)\u0019;b\r>\u0014X.\u0019;Qe>\u0004XM\u001d;z'\u0016\f\b#B#\u0002~\u000e}\u0001\u0003\u0002B6\u0007CIAaa\t\u0003n\t9r+Z1wK\u0012\u000bG/\u0019$pe6\fG\u000f\u0015:pa\u0016\u0014H/_\u0001\u0005gR|\u0007/A\u0005ti>\u0004\u0018iZ3oi\u0002")
public class WeaveAgentService
implements ToolingService {
    public final DataWeaveToolingService org$mule$weave$lsp$agent$WeaveAgentService$$validationService;
    private final Executor executor;
    private final ProjectMetadata project;
    private final WeaveScenarioManagerService scenarioManagerService;
    private final AgentClasspathResolver classpathResolver;
    private final Logger logger;
    private final ClientLogger org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger;
    private final String AGENT_SERVER_LAUNCHER_MAIN_CLASS;
    private final String LIGHT_GREY;
    private final String RED;
    private Process agentProcess;
    private WeaveAgentClient weaveAgentClient;
    private ProjectKind projectKind;
    private File classpathArgsFile;
    private final Lock startAgentLock;
    private InternalEventBus eventBus;

    private Logger logger() {
        return this.logger;
    }

    public ClientLogger org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger() {
        return this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger;
    }

    public String AGENT_SERVER_LAUNCHER_MAIN_CLASS() {
        return this.AGENT_SERVER_LAUNCHER_MAIN_CLASS;
    }

    public String LIGHT_GREY() {
        return this.LIGHT_GREY;
    }

    public String RED() {
        return this.RED;
    }

    private Process agentProcess() {
        return this.agentProcess;
    }

    private void agentProcess_$eq(Process x$1) {
        this.agentProcess = x$1;
    }

    private WeaveAgentClient weaveAgentClient() {
        return this.weaveAgentClient;
    }

    private void weaveAgentClient_$eq(WeaveAgentClient x$1) {
        this.weaveAgentClient = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private File classpathArgsFile() {
        return this.classpathArgsFile;
    }

    private void classpathArgsFile_$eq(File x$1) {
        this.classpathArgsFile = x$1;
    }

    private Lock startAgentLock() {
        return this.startAgentLock;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DependencyArtifactResolvedEvent$.MODULE$.ARTIFACT_RESOLVED(), new OnDependencyArtifactResolved(this){
            private final /* synthetic */ WeaveAgentService $outer;

            public void onArtifactsResolved(DependencyArtifact[] artifacts) {
                this.$outer.restart();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ WeaveAgentService $outer;

            public void onProjectStarted(ProjectMetadata projectMetadata) {
                this.$outer.startAgent();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void restart() {
        this.stopAgent();
        this.startAgent();
    }

    public void startAgent() {
        if (this.startAgentLock().tryLock()) {
            block11: {
                this.logger().debug("Locked startAgent");
                try {
                    if (this.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive()) break block11;
                    Seq<String> jars = this.classpathResolver.resolveClasspathJars();
                    if (jars.isEmpty()) {
                        this.logger().error("Could not resolve agent jars");
                    }
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().dependencyManager().dependencies())).isEmpty()) {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo("Project dependencies is empty, Agent won't be started");
                        break block11;
                    }
                    this.classpathArgsFile_$eq(File.createTempFile(new StringBuilder(17).append("dw-agent-argFile-").append(this.projectKind().project().getName()).toString(), ".args"));
                    boolean x$1 = false;
                    Seq<String> x$2 = jars;
                    Some x$3 = new Some((Object)this.classpathArgsFile());
                    boolean x$4 = ClassPathConfig$.MODULE$.apply$default$2();
                    ClassPathConfig classpathCfg = new ClassPathConfig(x$1, x$4, x$2, (Option<File>)x$3);
                    int port = NetUtils$.MODULE$.freePort();
                    ArrayList<String> commandArgs = JavaWeaveLauncher$.MODULE$.buildJavaProcessBaseArgs(this.projectKind(), classpathCfg, this.AGENT_SERVER_LAUNCHER_MAIN_CLASS(), JavaWeaveLauncher$.MODULE$.buildJavaProcessBaseArgs$default$4());
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    ArrayList<String> args = new ArrayList<String>();
                    args.addAll(commandArgs);
                    args.add("-p");
                    args.add(Integer.toString(port));
                    builder.command(args);
                    this.agentProcess_$eq(builder.start());
                    this.logger().debug(new StringBuilder(16).append("Starting Agent: ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(args).asScala()).mkString(" ")).toString());
                    try (BufferedSource source = Source$.MODULE$.fromFile(this.classpathArgsFile(), Codec$.MODULE$.fallbackSystemCodec());){
                        this.logger().debug(new StringBuilder(29).append("Classpath (argFile) content: ").append(source.mkString()).toString());
                    }
                    this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo("Starting DataWeave Agent");
                    ProcessStreamLineConsumer processStreamLineConsumer = new ProcessStreamLineConsumer(this){
                        private final /* synthetic */ WeaveAgentService $outer;

                        public void onStdErrorLineRead(String line) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(String.valueOf(line));
                        }

                        public void onStdOutLineRead(String line) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(String.valueOf(line));
                        }

                        public void onIOException(IOException ioException) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Error on Agent", ioException);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    IOUtils$.MODULE$.forwardProcessStream(this.agentProcess(), this.executor, processStreamLineConsumer);
                    TcpClientProtocol clientProtocol = new TcpClientProtocol("localhost", port);
                    this.weaveAgentClient_$eq(new WeaveAgentClient((ClientProtocol)clientProtocol));
                    this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(45).append("DataWeave Agent Client trying to connect at: ").append(port).toString());
                    this.weaveAgentClient().connect(50, 500L, new ConnectionRetriesListener(this, port){
                        private final /* synthetic */ WeaveAgentService $outer;
                        private final int port$1;

                        public void startConnecting() {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(37).append("DataWeave Agent start connecting at: ").append(this.port$1).toString());
                        }

                        public void connectedSuccessfully() {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(30).append("DataWeave Agent connected at: ").append(this.port$1).toString());
                        }

                        public void failToConnect(String reason) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(36).append("Fail to connect to DataWeave Agent: ").append(reason).toString());
                        }

                        public boolean onRetry(int count, int total) {
                            if (!this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive()) {
                                this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(67).append("Will not retry as process is no longer alive and exit code was: `").append(this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$agentExitCode()).append("`.").toString());
                                return false;
                            }
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(23).append("Retrying to connect: ").append(count).append("/").append(total).append(".").toString());
                            return true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.port$1 = port$1;
                        }
                    });
                    if (!this.weaveAgentClient().isConnected()) {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Unable to connect to Weave Agent");
                    } else {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(32).append("Weave Agent Started at port: `").append(port).append("`.").toString());
                        this.eventBus().fire(new AgentStartedEvent());
                    }
                }
                finally {
                    this.startAgentLock().unlock();
                }
            }
            return;
        }
    }

    public int org$mule$weave$lsp$agent$WeaveAgentService$$agentExitCode() {
        if (this.agentProcess() == null) {
            return -1;
        }
        return this.agentProcess().exitValue();
    }

    public boolean org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive() {
        return this.agentProcess() != null && this.agentProcess().isAlive();
    }

    @Override
    public void initialized() {
    }

    public CompletableFuture<Option<WeaveTypeBind[]>> inferInputMetadataForScenario(Scenario scenario) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().inferInputsWeaveType(scenario.inputsDirectory().getAbsolutePath(), new ImplicitWeaveTypesListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$1;

                    public void onImplicitWeaveTypesCalculated(ImplicitInputTypesEvent event) {
                        WeaveTypeBind[] binds = (WeaveTypeBind[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])event.types())).flatMap((Function1 & Serializable & scala.Serializable)m -> Option$.MODULE$.option2Iterable($this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$validationService.loadType(m.wtypeString()).map((Function1 & Serializable & scala.Serializable)wt -> new WeaveTypeBind(m.name(), (WeaveType)wt))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveTypeBind.class)));
                        this.result$1.set(new Some((Object)binds));
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(54).append("Unexpected error at 'inferInputsWeaveType' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$1.set(None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$1 = result$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onImplicitWeaveTypesCalculated$1(org.mule.weave.lsp.agent.WeaveAgentService$$anon$5 org.mule.weave.v2.agent.api.event.WeaveTypeEntry ), $anonfun$onImplicitWeaveTypesCalculated$2(org.mule.weave.v2.agent.api.event.WeaveTypeEntry org.mule.weave.v2.ts.WeaveType )}, serializedLambda);
                    }
                });
                return result.get().flatten(Predef$.MODULE$.$conforms());
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public CompletableFuture<Option<WeaveResource>> resolveModule(String identifier, String loader) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().resolveModule(identifier, loader, this.calculateLocalClasspath(this.calculateLocalClasspath$default$1()), new ModuleLoadedListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$2;

                    public void onModuleLoaded(ModuleResolvedEvent resultEvent) {
                        None$ maybeUrl;
                        Object object = maybeUrl = resultEvent.url() == null ? None$.MODULE$ : resultEvent.url();
                        if (resultEvent.content().isDefined()) {
                            String content = (String)resultEvent.content().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            String url = (String)maybeUrl.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            this.result$2.set(new Some((Object)WeaveResource$.MODULE$.apply(url, content)));
                            return;
                        }
                        this.result$2.set(None$.MODULE$);
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(47).append("Unexpected error at 'resolveModule' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$2.set(None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$2 = result$2;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onModuleLoaded$1(), $anonfun$onModuleLoaded$2()}, serializedLambda);
                    }
                });
                return result.get().flatten(Predef$.MODULE$.$conforms());
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public boolean checkConnected() {
        if (this.isDisconnected()) {
            this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo("Restarting Agent as is not initialized.");
            this.restart();
        }
        return this.weaveAgentClient() != null && this.weaveAgentClient().isConnected();
    }

    private boolean isDisconnected() {
        return this.weaveAgentClient() == null || !this.weaveAgentClient().isConnected() || !this.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive();
    }

    public CompletableFuture<Option<WeaveType>> inferOutputMetadataForScenario(Scenario scenario) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                Option<File> maybeExpected = scenario.expected();
                if (maybeExpected.isDefined()) {
                    this.weaveAgentClient().inferWeaveType(((File)maybeExpected.get()).getAbsolutePath(), new WeaveTypeInferListener(this, result){
                        private final /* synthetic */ WeaveAgentService $outer;
                        private final FutureValue result$3;

                        public void onWeaveTypeInfer(InferWeaveTypeEvent event) {
                            this.result$3.set(this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$validationService.loadType(event.typeString()));
                        }

                        public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(64).append("Unexpected error at 'inferOutputMetadataForScenario' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                            this.result$3.set(None$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.result$3 = result$3;
                        }
                    });
                    return result.get().flatten(Predef$.MODULE$.$conforms());
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public WeaveDataFormatDescriptor[] dataFormats() {
        if (this.checkConnected()) {
            FutureValue runResult = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
            this.weaveAgentClient().definedDataFormats(new DataFormatDefinitionListener(this, runResult){
                private final /* synthetic */ WeaveAgentService $outer;
                private final FutureValue runResult$1;

                public void onDataFormatDefinitionCalculated(DataFormatsDefinitionsEvent dfde) {
                    this.runResult$1.set(dfde.formats());
                }

                public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                    this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(52).append("Unexpected error at 'definedDataFormats' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                    this.runResult$1.set(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.runResult$1 = runResult$1;
                }
            });
            return (WeaveDataFormatDescriptor[])runResult.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> (WeaveDataFormatDescriptor[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class)));
        }
        return (WeaveDataFormatDescriptor[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class));
    }

    public PreviewResult run(NameIdentifier nameIdentifier, String content, String url) {
        Option<Scenario> maybeScenario = this.scenarioManagerService.activeScenario(nameIdentifier);
        return this.run(nameIdentifier, content, url, maybeScenario, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
    }

    public PreviewResult run(NameIdentifier nameIdentifier, String content, String url, Option<Scenario> previewScenario, Map<String, String> runtimeProperties, Option<String> outputMimeType, Option<Object> maybeTimeout, boolean withTestsClasspath) {
        if (this.checkConnected()) {
            long timeout = BoxesRunTime.unboxToLong((Object)maybeTimeout.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.project.settings().previewTimeout().value())).toLong()));
            FutureValue runResult = new FutureValue(timeout * 2L);
            String[] classpath = this.calculateLocalClasspath(withTestsClasspath);
            String inputsPath = (String)previewScenario.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.inputsDirectory().getAbsolutePath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            long startTime = System.currentTimeMillis();
            PreviewExecutedListener weaveAgentClientListener = new PreviewExecutedListener(this, runResult, url, startTime){
                private final /* synthetic */ WeaveAgentService $outer;
                private final FutureValue runResult$2;
                private final String url$1;
                private final long startTime$1;

                public void onPreviewExecuted(PreviewExecutedEvent result) {
                    long endTime = System.currentTimeMillis();
                    PreviewExecutedEvent previewExecutedEvent = result;
                    if (previewExecutedEvent instanceof PreviewExecutedFailedEvent) {
                        PreviewExecutedFailedEvent previewExecutedFailedEvent = (PreviewExecutedFailedEvent)previewExecutedEvent;
                        String message = previewExecutedFailedEvent.message();
                        Seq messages = previewExecutedFailedEvent.messages();
                        String[] logsArray = (String[])((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(3).append(m.timestamp()).append(" : ").append(m.message()).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String x$1 = message;
                        boolean x$2 = false;
                        List<Object> x$3 = Arrays.asList((Object[])logsArray);
                        String x$4 = this.url$1;
                        long x$5 = endTime - this.startTime$1;
                        String x$6 = PreviewResult$.MODULE$.apply$default$4();
                        String x$7 = PreviewResult$.MODULE$.apply$default$5();
                        String x$8 = PreviewResult$.MODULE$.apply$default$7();
                        String x$9 = PreviewResult$.MODULE$.apply$default$8();
                        this.runResult$2.set(new PreviewResult(x$4, x$2, x$3, x$6, x$7, x$1, x$8, x$9, x$5));
                        return;
                    }
                    if (previewExecutedEvent instanceof PreviewExecutedSuccessfulEvent) {
                        PreviewExecutedSuccessfulEvent previewExecutedSuccessfulEvent = (PreviewExecutedSuccessfulEvent)previewExecutedEvent;
                        byte[] result2 = previewExecutedSuccessfulEvent.result();
                        String mimeType = previewExecutedSuccessfulEvent.mimeType();
                        String extension = previewExecutedSuccessfulEvent.extension();
                        String encoding = previewExecutedSuccessfulEvent.encoding();
                        Seq messages = previewExecutedSuccessfulEvent.messages();
                        String[] logsArray = (String[])((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(3).append(m.timestamp()).append(" : ").append(m.message()).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String x$10 = new String(result2, encoding);
                        String x$11 = mimeType;
                        boolean x$12 = true;
                        List<Object> x$13 = Arrays.asList((Object[])logsArray);
                        String x$14 = this.url$1;
                        long x$15 = endTime - this.startTime$1;
                        String x$16 = extension;
                        String x$17 = PreviewResult$.MODULE$.apply$default$6();
                        String x$18 = PreviewResult$.MODULE$.apply$default$7();
                        this.runResult$2.set(new PreviewResult(x$14, x$12, x$13, x$10, x$11, x$17, x$18, x$16, x$15));
                        return;
                    }
                    throw new MatchError((Object)previewExecutedEvent);
                }

                public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                    long endTime = System.currentTimeMillis();
                    this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(44).append("Unexpected error at 'runPreview' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                    String x$1 = "Unexpected error at 'runPreview'";
                    boolean x$2 = false;
                    List<Object> x$3 = Arrays.asList((Object[])new String[]{unexpectedServerErrorEvent.stacktrace()});
                    String x$4 = this.url$1;
                    long x$5 = endTime - this.startTime$1;
                    String x$6 = PreviewResult$.MODULE$.apply$default$4();
                    String x$7 = PreviewResult$.MODULE$.apply$default$5();
                    String x$8 = PreviewResult$.MODULE$.apply$default$7();
                    String x$9 = PreviewResult$.MODULE$.apply$default$8();
                    PreviewResult result = new PreviewResult(x$4, x$2, x$3, x$6, x$7, x$1, x$8, x$9, x$5);
                    this.runResult$2.set(result);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.runResult$2 = runResult$2;
                    this.url$1 = url$1;
                    this.startTime$1 = startTime$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPreviewExecuted$1(org.mule.weave.v2.agent.api.event.WeaveLogMessage ), $anonfun$onPreviewExecuted$2(org.mule.weave.v2.agent.api.event.WeaveLogMessage )}, serializedLambda);
                }
            };
            this.weaveAgentClient().runPreview(inputsPath, content, nameIdentifier.toString(), url, timeout, classpath, runtimeProperties, outputMimeType, weaveAgentClientListener);
            return (PreviewResult)runResult.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String x$1 = "Unable to Start DataWeave Agent to Run Preview.";
                boolean x$2 = false;
                List<String> x$3 = Collections.emptyList();
                String x$4 = url;
                String x$5 = PreviewResult$.MODULE$.apply$default$4();
                String x$6 = PreviewResult$.MODULE$.apply$default$5();
                String x$7 = PreviewResult$.MODULE$.apply$default$7();
                String x$8 = PreviewResult$.MODULE$.apply$default$8();
                long x$9 = PreviewResult$.MODULE$.apply$default$9();
                return new PreviewResult(x$4, x$2, x$3, x$5, x$6, x$1, x$7, x$8, x$9);
            });
        }
        String x$10 = "Unable to Start DataWeave Agent to Run Preview.";
        boolean x$11 = false;
        List<String> x$12 = Collections.emptyList();
        String x$13 = url;
        String x$14 = PreviewResult$.MODULE$.apply$default$4();
        String x$15 = PreviewResult$.MODULE$.apply$default$5();
        String x$16 = PreviewResult$.MODULE$.apply$default$7();
        String x$17 = PreviewResult$.MODULE$.apply$default$8();
        long x$18 = PreviewResult$.MODULE$.apply$default$9();
        return new PreviewResult(x$13, x$11, x$12, x$14, x$15, x$10, x$16, x$17, x$18);
    }

    private String[] calculateLocalClasspath(boolean withTests) {
        String[] sources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainSourceFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] resources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainResourcesFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] targets = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainTargetFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] tests = withTests ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.testsSourceFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targets)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tests)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private boolean calculateLocalClasspath$default$1() {
        return false;
    }

    public CompletableFuture<DataFormatDescriptor[]> definedDataFormats() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().definedDataFormats(new DataFormatDefinitionListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$4;

                    public void onDataFormatDefinitionCalculated(DataFormatsDefinitionsEvent event) {
                        WeaveDataFormatDescriptor[] formats = event.formats();
                        DataFormatDescriptor[] descriptor = (DataFormatDescriptor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formats)).map((Function1 & Serializable & scala.Serializable)weaveDataFormatDescriptor -> {
                            String mimeType = weaveDataFormatDescriptor.mimeType();
                            return DataFormatDescriptor$.MODULE$.apply(mimeType, weaveDataFormatDescriptor.id(), $this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(weaveDataFormatDescriptor.writerProperties()), $this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(weaveDataFormatDescriptor.readerProperties()));
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
                        this.result$4.set(descriptor);
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(52).append("Unexpected error at 'definedDataFormats' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$4.set(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$4 = result$4;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onDataFormatDefinitionCalculated$1(org.mule.weave.lsp.agent.WeaveAgentService$$anon$10 org.mule.weave.v2.agent.api.event.WeaveDataFormatDescriptor )}, serializedLambda);
                    }
                });
                return (DataFormatDescriptor[])result.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> (DataFormatDescriptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
            }
            return (DataFormatDescriptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class));
        }, this.executor);
    }

    public DataFormatProperty[] org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(WeaveDataFormatProperty[] weaveDataFormatPropertySeq) {
        return (DataFormatProperty[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])weaveDataFormatPropertySeq)).map((Function1 & Serializable & scala.Serializable)property -> new DataFormatProperty(property.name(), property.description(), property.wtype(), property.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFormatProperty.class)));
    }

    @Override
    public void stop() {
        this.logger().debug("stop() hit");
        this.stopAgent();
    }

    private void stopAgent() {
        this.logger().debug("stopAgent() hit");
        if (this.weaveAgentClient() != null) {
            this.weaveAgentClient().disconnect();
        }
        if (this.agentProcess() != null) {
            this.agentProcess().destroyForcibly();
            this.agentProcess_$eq(null);
        }
        if (this.classpathArgsFile() != null && this.classpathArgsFile() != null && this.classpathArgsFile().exists()) {
            this.classpathArgsFile().delete();
            this.classpathArgsFile_$eq(null);
        }
        this.eventBus().fire(new AgentStoppedEvent());
    }

    public WeaveAgentService(DataWeaveToolingService validationService, Executor executor, ClientLoggerFactory loggerFactory, ProjectMetadata project, WeaveScenarioManagerService scenarioManagerService, AgentClasspathResolver classpathResolver) {
        this.org$mule$weave$lsp$agent$WeaveAgentService$$validationService = validationService;
        this.executor = executor;
        this.project = project;
        this.scenarioManagerService = scenarioManagerService;
        this.classpathResolver = classpathResolver;
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(WeaveAgentService.class);
        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger = loggerFactory.createLogger(WeaveAgentService.class);
        this.AGENT_SERVER_LAUNCHER_MAIN_CLASS = "org.mule.weave.v2.agent.server.AgentServerLauncher";
        this.LIGHT_GREY = "rgb(113, 113, 113)";
        this.RED = "rgb(139, 0, 0)";
        this.startAgentLock = new ReentrantLock();
    }
}

