package org.mule.weave.lsp.services

import org.eclipse.lsp4j
import org.eclipse.lsp4j.Location
import org.mule.weave.extension.api.WeaveLanguageServerBuilder

import scala.collection.concurrent.TrieMap

class TextDocumentTranslatorService extends ToolingService with WeaveLanguageServerBuilder.TextDocumentTranslator {

  val translators: TrieMap[String, WeaveLanguageServerBuilder.TextDocumentTranslator] = new TrieMap()

  def addTranslator(fileScheme: String, translator: WeaveLanguageServerBuilder.TextDocumentTranslator) = {
    if (translators.put(fileScheme, translator).isDefined) {
      throw new IllegalStateException(s"There is a TextDocumentTranslator defined for fileScheme: ${fileScheme}, " +
        s"there cannot be more than one TextDocumentTranslator per fileScheme provided by the WeaveLanguageServerBuilder")
    }
  }

  def removeTranslator(fileScheme: String) = {
    translators.remove(fileScheme)
  }

  override def translate(embeddedUri: String): String = {
    translators.filter(p => embeddedUri.startsWith(p._1)).headOption.map(p => p._2.translate(embeddedUri)).getOrElse(embeddedUri)
  }

  override def translate(embeddedUri: String, range: lsp4j.Range): Location =
    translators.filter(p => embeddedUri.startsWith(p._1)).headOption.map(p => p._2.translate(embeddedUri, range)).getOrElse(new lsp4j.Location(embeddedUri, range))

}
