/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.vfs.ArtifactVirtualFileSystem;
import org.mule.weave.lsp.vfs.JarFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.JarVirtualFSResourceProvider;
import org.mule.weave.lsp.vfs.JarVirtualFile;
import org.mule.weave.lsp.vfs.ReadOnlyVirtualFileSystem;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\n\u0014\u0001yA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005m!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011!Y\u0005A!A!\u0002\u0013a\u0005\"B(\u0001\t\u0003\u0001\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007;\u0002\u0001\u000b\u0011B,\t\u0011y\u0003\u0001R1A\u0005\u0002}CQ\u0001\u001b\u0001\u0005B%DQ\u0001\u001e\u0001\u0005\nUDQA \u0001\u0005\n}Dq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0002\u0015\u0015\u0006\u0014h+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u000b\u0005Q)\u0012a\u0001<gg*\u0011acF\u0001\u0004YN\u0004(B\u0001\r\u001a\u0003\u00159X-\u0019<f\u0015\tQ2$\u0001\u0003nk2,'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001yR%\u000b\u0017\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0014\u0013\tA3CA\rSK\u0006$wJ\u001c7z-&\u0014H/^1m\r&dWmU=ti\u0016l\u0007C\u0001\u0014+\u0013\tY3CA\rBeRLg-Y2u-&\u0014H/^1m\r&dWmU=ti\u0016l\u0007CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\u0015\u0005\u0014H/\u001b4bGRLE-F\u00017!\t9dH\u0004\u00029yA\u0011\u0011(I\u0007\u0002u)\u00111(H\u0001\u0007yI|w\u000e\u001e \n\u0005u\n\u0013A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!P\u0011\u0002\u0017\u0005\u0014H/\u001b4bGRLE\rI\u0001\bU\u0006\u0014h)\u001b7f+\u0005!\u0005CA#I\u001b\u00051%BA$1\u0003\tIw.\u0003\u0002J\r\n!a)\u001b7f\u0003!Q\u0017M\u001d$jY\u0016\u0004\u0013!\b6be\u001aKG.\u001a(b[\u0016LE-\u001a8uS\u001aLWM\u001d*fg>dg/\u001a:\u0011\u0005\u0019j\u0015B\u0001(\u0014\u0005uQ\u0015M\u001d$jY\u0016t\u0015-\\3JI\u0016tG/\u001b4jKJ\u0014Vm]8mm\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003R%N#\u0006C\u0001\u0014\u0001\u0011\u0015!d\u00011\u00017\u0011\u0015\u0011e\u00011\u0001E\u0011\u0015Ye\u00011\u0001M\u0003\u0019awnZ4feV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[7\u0005)1\u000f\u001c45U&\u0011A,\u0017\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u00059!0\u001b9GS2,W#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017a\u0001>ja*\u0011Q\rM\u0001\u0005kRLG.\u0003\u0002hE\n9!,\u001b9GS2,\u0017\u0001\u00024jY\u0016$\"A\u001b:\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017AB3eSR|'O\u0003\u0002p/\u0005\u0011aOM\u0005\u0003c2\u00141BV5siV\fGNR5mK\")1O\u0003a\u0001m\u0005!\u0001/\u0019;i\u0003\u001dQ\u0017M\u001d)bi\"$\"A\u000e<\t\u000b]\\\u0001\u0019\u0001=\u0002\u0007U\u0014\u0018\u000e\u0005\u0002zy6\t!P\u0003\u0002|a\u0005\u0019a.\u001a;\n\u0005uT(aA+S\u0013\u0006A!.\u0019:F]R\u0014\u0018\u0010F\u00027\u0003\u0003AQa\u001e\u0007A\u0002a\f1B[1s+JL\u0007+\u0019:ugR!\u0011qAA\t!\u0015\u0001\u0013\u0011BA\u0007\u0013\r\tY!\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004[\u0005=\u0011BA /\u0011\u00159X\u00021\u0001y\u0003A\u0011Xm]8mm\u0016dunY1m!\u0006$\b\u000e\u0006\u0003\u0002\u0018\u0005u\u0001c\u0001\u0014\u0002\u001a%\u0019\u00111D\n\u0003\u001d)\u000b'OV5siV\fGNR5mK\")1O\u0004a\u0001m\u0005IA.[:u\r&dWm\u001d\u000b\u0003\u0003G\u0001R!!\n\u0002()l\u0011\u0001Z\u0005\u0004\u0003S!'\u0001C%uKJ\fGo\u001c:\u0002%\u0005\u001c(+Z:pkJ\u001cWMU3t_24XM]\u000b\u0003\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kq\u0017aA:eW&!\u0011\u0011HA\u001a\u0005U9V-\u0019<f%\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ\fQa\u00197pg\u0016$\"!a\u0010\u0011\u0007\u0001\n\t%C\u0002\u0002D\u0005\u0012A!\u00168ji\u0002")
public class JarVirtualFileSystem
implements ReadOnlyVirtualFileSystem,
ArtifactVirtualFileSystem,
AutoCloseable {
    private ZipFile zipFile;
    private final String artifactId;
    private final File jarFile;
    private final JarFileNameIdentifierResolver jarFileNameIdentifierResolver;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public String artifactId() {
        return this.artifactId;
    }

    public File jarFile() {
        return this.jarFile;
    }

    private Logger logger() {
        return this.logger;
    }

    private ZipFile zipFile$lzycompute() {
        JarVirtualFileSystem jarVirtualFileSystem = this;
        synchronized (jarVirtualFileSystem) {
            if (!this.bitmap$0) {
                this.zipFile = new ZipFile(this.jarFile());
                this.bitmap$0 = true;
            }
        }
        return this.zipFile;
    }

    public ZipFile zipFile() {
        if (!this.bitmap$0) {
            return this.zipFile$lzycompute();
        }
        return this.zipFile;
    }

    public VirtualFile file(String path) {
        this.logger().debug(new StringBuilder(31).append("Before creating uri, entry ").append(path).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
        Option<URI> option = URLUtils$.MODULE$.toURI(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            URI uri = (URI)some.value();
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = URLUtils$.MODULE$.uriPath(this.jarFile().getCanonicalPath().replace(File.separatorChar, '/'));
                String string4 = this.jarPath(uri);
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String str = this.jarEntry(uri);
                    this.logger().debug(new StringBuilder(20).append("Jar entry entry ").append(str).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
                    return this.resolveLocalPath(str);
                }
            }
        }
        this.logger().debug(new StringBuilder(23).append("No jar entry entry ").append(path).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
        return this.resolveLocalPath(path);
    }

    private String jarPath(URI uri) {
        String[] parts = this.jarUriParts(uri);
        return parts[0];
    }

    private String jarEntry(URI uri) {
        String[] parts = this.jarUriParts(uri);
        return parts[1];
    }

    private String[] jarUriParts(URI uri) {
        return uri.getPath().split("!");
    }

    private JarVirtualFile resolveLocalPath(String path) {
        this.logger().debug(new StringBuilder(9).append("file ").append(path).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
        String zipEntryPath = path.startsWith("/") ? path.substring(1) : path;
        ZipEntry zipEntry = this.zipFile().getEntry(zipEntryPath);
        Option option = Option$.MODULE$.apply((Object)zipEntry);
        if (option instanceof Some) {
            Some some = (Some)option;
            ZipEntry entry = (ZipEntry)some.value();
            this.logger().debug(new StringBuilder(14).append("zip entry ").append(entry.getName()).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
            return new JarVirtualFile(zipEntry.getName(), entry, this.zipFile(), this, this.jarFileNameIdentifierResolver);
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    public java.util.Iterator<VirtualFile> listFiles() {
        Iterator entries = (Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.zipFile().entries()).asScala();
        Iterator list = entries.flatMap((Function1 & Serializable & scala.Serializable)zipEntry -> {
            if (zipEntry.isDirectory()) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            this.logger().debug(new StringBuilder(26).append("Building virtual file ").append(zipEntry.getName()).append(" in ").append(this.jarFile().getAbsolutePath()).toString());
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new JarVirtualFile(zipEntry.getName(), (ZipEntry)zipEntry, this.zipFile(), this, $this.jarFileNameIdentifierResolver)));
        });
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(list).asJava();
    }

    public WeaveResourceResolver asResourceResolver() {
        return new JarVirtualFSResourceProvider(this);
    }

    @Override
    public void close() {
        this.zipFile().close();
    }

    public JarVirtualFileSystem(String artifactId, File jarFile, JarFileNameIdentifierResolver jarFileNameIdentifierResolver) {
        this.artifactId = artifactId;
        this.jarFile = jarFile;
        this.jarFileNameIdentifierResolver = jarFileNameIdentifierResolver;
        VirtualFileSystem.$init$((VirtualFileSystem)this);
        ReadOnlyVirtualFileSystem.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

