package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.bat.BatUserMessages
import org.mule.weave.lsp.services.ClientLoggerFactory
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WorkspaceServiceManager

import scala.collection.JavaConverters._

class RunBatFolderTestCommand(cl: ClientLoggerFactory, workspaceServiceManager: WorkspaceServiceManager, uIService: UIService) extends BatCommand(workspaceServiceManager) {
  override def commandId(): String = Commands.BAT_RUN_BAT_FOLDER

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val arguments = params.getArguments.asScala
    val batProjectManager = new BatProjectHelper(cl.createLogger(classOf[RunBatFolderTestCommand]))
    if (installCLIIfNeeded(batProjectManager, uIService)) {
      batProjectManager.run(arguments.head.toString, None)
    } else {
      uIService.showMessage(BatUserMessages.batCLINotFound())
      ""
    }
  }


  override def name(): String = "Runs BAT Tests."

  override def description(params: ExecuteCommandParams): String = "Running all Bat Tests inside folder."

}
