package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent.DOCUMENT_FOCUS_CHANGED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.v2.editor.VirtualFile

class DocumentFocusChangedEvent(vf: VirtualFile) extends InternalEvent {
  override type T = OnDocumentFocused

  override def getType: InternalEventType[OnDocumentFocused] = DOCUMENT_FOCUS_CHANGED

  override def dispatch(handler: OnDocumentFocused): Unit = {
    handler.onDocumentFocused(vf)
  }
}

trait OnDocumentFocused extends InternalEventHandler {
  def onDocumentFocused(vf: VirtualFile): Unit
}

object DocumentFocusChangedEvent {
  val DOCUMENT_FOCUS_CHANGED = InternalEventType[OnDocumentFocused]("DOCUMENT_FOCUS_CHANGED")
}
