/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.component.structure.WeaveProjectStructure;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.events.OnProjectStructureChanged;
import org.mule.weave.lsp.project.events.ProjectStructureChangedEvent$;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.vfs.CompositeNameIdentifierResolver;
import org.mule.weave.lsp.vfs.InMemoryVirtualFileResourceResolver;
import org.mule.weave.lsp.vfs.JarFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.NameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileSystemService$;
import org.mule.weave.lsp.vfs.ProjectVirtualFile;
import org.mule.weave.lsp.vfs.ProjectVirtualFile$;
import org.mule.weave.lsp.vfs.SimpleNameIdentifierResolver$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.resource.FolderWeaveResourceResolver;
import org.mule.weave.v2.editor.ChangeListener;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.sdk.ChainedWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0014)\u0001MB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u0002:\u0001A\u0003%A\fC\u0004t\u0001\t\u0007I\u0011\u0002;\t\ra\u0004\u0001\u0015!\u0003v\u0011\u001dI\bA1A\u0005\niDq!a\u0001\u0001A\u0003%1\u0010C\u0006\u0002\u0006\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0001bCA\u000b\u0001\u0001\u0007\t\u0019!C\u0005\u0003/A1\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0014\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%I!a\u000e\t\u0017\u0005m\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0006\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\tY\f\u0001C!\u0003{Cq!!1\u0001\t\u0013\t\u0019\rC\u0004\u0002H\u0002!I!!3\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0005a\u0001&o\u001c6fGR4\u0015\u000e\\3TsN$X-\\*feZL7-\u001a\u0006\u0003S)\n1A\u001e4t\u0015\tYC&A\u0002mgBT!!\f\u0018\u0002\u000b],\u0017M^3\u000b\u0005=\u0002\u0014\u0001B7vY\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0005\u0001QR$\t\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\na!\u001a3ji>\u0014(BA -\u0003\t1('\u0003\u0002By\t\tb+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015S\u0013\u0001C:feZL7-Z:\n\u0005\u001d#%A\u0004+p_2LgnZ*feZL7-Z\u0001\u001eU\u0006\u0014h)\u001b7f\u001d\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<feB\u0011!jS\u0007\u0002Q%\u0011A\n\u000b\u0002\u001e\u0015\u0006\u0014h)\u001b7f\u001d\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\"a\u0014)\u0011\u0005)\u0003\u0001\"\u0002%\u0003\u0001\u0004I\u0015A\u00027pO\u001e,'/F\u0001T!\t!v+D\u0001V\u0015\t1\u0006'A\u0003tY\u001a$$.\u0003\u0002Y+\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0007j]6+Wn\u001c:z\r&dWm]\u000b\u00029B!QL\u00193p\u001b\u0005q&BA0a\u0003\u001diW\u000f^1cY\u0016T!!\u0019\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002d=\n\u0019Q*\u00199\u0011\u0005\u0015dgB\u00014k!\t9g'D\u0001i\u0015\tI''\u0001\u0004=e>|GOP\u0005\u0003WZ\na\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111N\u000e\t\u0003\u0015BL!!\u001d\u0015\u0003%A\u0013xN[3diZK'\u000f^;bY\u001aKG.Z\u0001\u000fS:lU-\\8ss\u001aKG.Z:!\u0003-y\u0007/\u001a8fI\u001aKG.Z:\u0016\u0003U\u00042!\u0018<e\u0013\t9hLA\u0002TKR\fAb\u001c9f]\u0016$g)\u001b7fg\u0002\n!C\u001e4t\u0007\"\fgnZ3MSN$XM\\3sgV\t1\u0010E\u0002^yzL!! 0\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003w}L1!!\u0001=\u00059\u0019\u0005.\u00198hK2K7\u000f^3oKJ\f1C\u001e4t\u0007\"\fgnZ3MSN$XM\\3sg\u0002\n1\u0002\u001d:pU\u0016\u001cGoS5oIV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0016\u0002\u000fA\u0014xN[3di&!\u00111CA\u0007\u0005-\u0001&o\u001c6fGR\\\u0015N\u001c3\u0002\u001fA\u0014xN[3di.Kg\u000eZ0%KF$B!!\u0007\u0002 A\u0019Q'a\u0007\n\u0007\u0005uaG\u0001\u0003V]&$\b\"CA\u0011\u0019\u0005\u0005\t\u0019AA\u0005\u0003\rAH%M\u0001\raJ|'.Z2u\u0017&tG\rI\u0001\tKZ,g\u000e\u001e\"vgV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0016\u0002\u000bU$\u0018\u000e\\:\n\t\u0005M\u0012Q\u0006\u0002\u0011\u0013:$XM\u001d8bY\u00163XM\u001c;CkN\fA\"\u001a<f]R\u0014Uo]0%KF$B!!\u0007\u0002:!I\u0011\u0011E\b\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\nKZ,g\u000e\u001e\"vg\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u0019\tI\"!\u0011\u0002D!9\u0011QA\tA\u0002\u0005%\u0001bBA\u0013#\u0001\u0007\u0011\u0011F\u0001\u001dGJ,\u0017\r^3OC6,\u0017\nZ3oi&4\u0017.\u001a:SKN|GN^3s)\t\tI\u0005E\u0002K\u0003\u0017J1!!\u0014)\u0005Yq\u0015-\\3JI\u0016tG/\u001b4jKJ\u0014Vm]8mm\u0016\u0014\u0018AB;qI\u0006$X\r\u0006\u0004\u0002T\u0005}\u00131\r\t\u0006k\u0005U\u0013\u0011L\u0005\u0004\u0003/2$AB(qi&|g\u000eE\u0002<\u00037J1!!\u0018=\u0005-1\u0016N\u001d;vC24\u0015\u000e\\3\t\r\u0005\u00054\u00031\u0001e\u0003\r)(/\u001b\u0005\u0007\u0003K\u001a\u0002\u0019\u00013\u0002\u000f\r|g\u000e^3oi\u000611\r\\8tK\u0012$B!a\u0015\u0002l!1\u0011\u0011\r\u000bA\u0002\u0011\fQa]1wK\u0012$B!a\u0015\u0002r!1\u0011\u0011M\u000bA\u0002\u0011\fqa\u00195b]\u001e,G\r\u0006\u0003\u0002\u001a\u0005]\u0004BBA1-\u0001\u0007A-\u0001\bjg&sW*Z7pef4\u0015\u000e\\3\u0015\t\u0005u\u00141\u0011\t\u0004k\u0005}\u0014bAAAm\t9!i\\8mK\u0006t\u0007BBA1/\u0001\u0007A-A\u0004eK2,G/\u001a3\u0015\t\u0005e\u0011\u0011\u0012\u0005\u0007\u0003CB\u0002\u0019\u00013\u0002\u000f\r\u0014X-\u0019;fIR!\u0011\u0011DAH\u0011\u0019\t\t'\u0007a\u0001I\u0006q1\r[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BA\r\u0003+Ca!a&\u001b\u0001\u0004q\u0018AA2m\u0003%ygn\u00115b]\u001e,G\r\u0006\u0003\u0002\u001a\u0005u\u0005bBAP7\u0001\u0007\u0011\u0011L\u0001\u0003m\u001a\fa\u0002\u001e:jO\u001e,'o\u00115b]\u001e,7\u000f\u0006\u0003\u0002\u001a\u0005\u0015\u0006bBAP9\u0001\u0007\u0011\u0011L\u0001\u000fiJLwmZ3s\u0007J,\u0017\r^3e)\u0011\tI\"a+\t\u000f\u0005}U\u00041\u0001\u0002Z\u0005qAO]5hO\u0016\u0014H)\u001a7fi\u0016$G\u0003BA\r\u0003cCq!a(\u001f\u0001\u0004\tI&\u0001\u000bsK6|g/Z\"iC:<W\rT5ti\u0016tWM\u001d\u000b\u0005\u00033\t9\f\u0003\u0004\u0002:~\u0001\rA`\u0001\bg\u0016\u0014h/[2f\u0003\u00111\u0017\u000e\\3\u0015\t\u0005e\u0013q\u0018\u0005\u0007\u0003C\u0002\u0003\u0019\u00013\u0002\u0019\r|g\u000e^1j]N4\u0015\u000e\\3\u0015\t\u0005u\u0014Q\u0019\u0005\u0007\u0003C\n\u0003\u0019\u00013\u0002\u0013\u0011|w)\u001a;GS2,GcA8\u0002L\"1\u0011\u0011\r\u0012A\u0002\u0011\fA\u0002Z8Va\u0012\fG/\u001a$jY\u0016$b!!5\u0002T\u0006U\u0007\u0003B\u001b\u0002V=Da!!\u0019$\u0001\u0004!\u0007BBAlG\u0001\u0007q.A\u0006wSJ$X/\u00197GS2,\u0017\u0001D:pkJ\u001cWMU8pi>3G\u0003BAo\u0003_\u0004R!NA+\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0002j_*\u0011\u0011\u0011^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0006\r(\u0001\u0002$jY\u0016Da!!\u0019%\u0001\u0004!\u0017AE1t%\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ,\"!!>\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a??\u0003\r\u0019Hm[\u0005\u0005\u0003\u007f\fIPA\u000bXK\u00064XMU3t_V\u00148-\u001a*fg>dg/\u001a:\u0002\u00131L7\u000f\u001e$jY\u0016\u001cHC\u0001B\u0003!\u0019\u00119A!\u0004\u0002Z5\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\t9/\u0001\u0003vi&d\u0017\u0002\u0002B\b\u0005\u0013\u0011\u0001\"\u0013;fe\u0006$xN\u001d")
public class ProjectFileSystemService
implements VirtualFileSystem,
ToolingService {
    private final JarFileNameIdentifierResolver jarFileNameIdentifierResolver;
    private final Logger logger;
    private final Map<String, ProjectVirtualFile> org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles;
    private final Set<String> org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles;
    private final ArrayBuffer<ChangeListener> vfsChangeListeners;
    private ProjectKind projectKind;
    private InternalEventBus eventBus;

    private Logger logger() {
        return this.logger;
    }

    public Map<String, ProjectVirtualFile> org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles() {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles;
    }

    public Set<String> org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles() {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles;
    }

    private ArrayBuffer<ChangeListener> vfsChangeListeners() {
        return this.vfsChangeListeners;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.eventBus_$eq(eventBus);
        eventBus.register(ProjectStructureChangedEvent$.MODULE$.PROJECT_STRUCTURE_CHANGED(), new OnProjectStructureChanged(this){
            private final /* synthetic */ ProjectFileSystemService $outer;

            public void onProjectStructureChanged(WeaveProjectStructure previousProjectStructure, WeaveProjectStructure newProjectStructure) {
                Set filesNotPresentInProject = ((SetLike)this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().filter((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onProjectStructureChanged$1(newProjectStructure, uri)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().keys().filter((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onProjectStructureChanged$2(newProjectStructure, uri)))).toArray(ClassTag$.MODULE$.apply(String.class)))));
                filesNotPresentInProject.foreach((Function1 & Serializable & scala.Serializable)toBeDeleted -> {
                    $anon$1.$anonfun$onProjectStructureChanged$3(this, toBeDeleted);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ boolean $anonfun$onProjectStructureChanged$1(WeaveProjectStructure newProjectStructure$1, String uri) {
                return !ProjectStructureHelper$.MODULE$.isAProjectFile(uri, newProjectStructure$1);
            }

            public static final /* synthetic */ boolean $anonfun$onProjectStructureChanged$2(WeaveProjectStructure newProjectStructure$1, String uri) {
                return !ProjectStructureHelper$.MODULE$.isAProjectFile(uri, newProjectStructure$1);
            }

            public static final /* synthetic */ void $anonfun$onProjectStructureChanged$3($anon$1 $this, String toBeDeleted) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(toBeDeleted);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onProjectStructureChanged$1$adapted(org.mule.weave.extension.api.component.structure.WeaveProjectStructure java.lang.String ), $anonfun$onProjectStructureChanged$2$adapted(org.mule.weave.extension.api.component.structure.WeaveProjectStructure java.lang.String ), $anonfun$onProjectStructureChanged$3$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$1 java.lang.String )}, serializedLambda);
            }
        });
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this, projectKind){
            private final /* synthetic */ ProjectFileSystemService $outer;
            private final ProjectKind projectKind$1;

            public void onFileChanged(String uri2, FileChangeType changeType) {
                WeaveProjectStructure projectStructure = this.projectKind$1.structure();
                FileChangeType fileChangeType = changeType;
                if (FileChangeType.Created.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, projectStructure) && URLUtils$.MODULE$.toFile(uri2).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$onFileChanged$1(f)))) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$created(uri2);
                        return;
                    }
                    return;
                }
                if (FileChangeType.Changed.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, projectStructure)) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().iterator().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$onFileChanged$2(uri2, p))).foreach((Function1 & Serializable & scala.Serializable)uri -> {
                            $anon$2.$anonfun$onFileChanged$3(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                if (FileChangeType.Deleted.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, projectStructure)) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().iterator().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$onFileChanged$4(uri2, p))).foreach((Function1 & Serializable & scala.Serializable)uri -> {
                            $anon$2.$anonfun$onFileChanged$5(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)fileChangeType);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$1(File f) {
                return f.exists() && f.isFile();
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$2(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$3($anon$2 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$changed(uri);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$4(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$5($anon$2 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(uri);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1$adapted(java.io.File ), $anonfun$onFileChanged$2$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$3$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$2 java.lang.String ), $anonfun$onFileChanged$4$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$5$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$2 java.lang.String )}, serializedLambda);
            }
        });
    }

    private NameIdentifierResolver createNameIdentifierResolver() {
        return new CompositeNameIdentifierResolver((NameIdentifierResolver[])((Object[])new NameIdentifierResolver[]{new ProjectFileNameIdentifierResolver(this.projectKind().structure()), this.jarFileNameIdentifierResolver, SimpleNameIdentifierResolver$.MODULE$}));
    }

    public Option<VirtualFile> update(String uri, String content) {
        this.logger().debug(new StringBuilder(13).append("Update `").append(uri).append("` -> ").append(content).toString());
        Option option = Option$.MODULE$.apply((Object)this.file(uri));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile vf = (VirtualFile)some.value();
            boolean written = vf.write(content);
            if (written) {
                this.triggerChanges(vf);
            }
            return new Some((Object)vf);
        }
        if (None$.MODULE$.equals(option)) {
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.createNameIdentifierResolver(), URLUtils$.MODULE$.toCanonicalString(uri), (Option<File>)None$.MODULE$, (Option<String>)new Some((Object)content), !VFUtils$.MODULE$.isSupportedEditableScheme(uri));
            this.doUpdateFile(uri, virtualFile);
            this.triggerChanges(virtualFile);
            return new Some((Object)virtualFile);
        }
        throw new MatchError((Object)option);
    }

    public Option<VirtualFile> closed(String uri) {
        this.logger().debug(new StringBuilder(7).append("closed ").append(uri).toString());
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().remove((Object)uri);
    }

    public Option<VirtualFile> saved(String uri) {
        this.logger().debug(new StringBuilder(7).append("saved: ").append(uri).toString());
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().get((Object)uri).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.save());
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$changed(String uri) {
        this.logger().debug(new StringBuilder(9).append("changed: ").append(uri).toString());
        VirtualFile virtualFile = this.file(uri);
        this.triggerChanges(virtualFile);
    }

    public boolean isInMemoryFile(String uri) {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().contains((Object)uri);
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(String uri) {
        this.logger().debug(new StringBuilder(8).append("deleted ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().remove((Object)uri);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().remove((Object)uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.createNameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerDeleted(virtualFile);
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$created(String uri) {
        this.logger().debug(new StringBuilder(9).append("created: ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.createNameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerCreated(virtualFile);
    }

    public void changeListener(ChangeListener cl) {
        this.vfsChangeListeners().$plus$eq((Object)cl);
    }

    public void onChanged(VirtualFile vf) {
        this.triggerChanges(vf);
    }

    private void triggerChanges(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onChanged(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileChangedEvent(vf));
            return;
        }
    }

    private void triggerCreated(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onCreated(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileCreatedEvent(vf));
            return;
        }
    }

    private void triggerDeleted(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onDeleted(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileDeletedEvent(vf));
            return;
        }
    }

    public void removeChangeListener(ChangeListener service) {
        this.vfsChangeListeners().remove(this.vfsChangeListeners().indexOf((Object)service));
    }

    public VirtualFile file(String uri) {
        this.logger().debug(new StringBuilder(5).append("file ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)uri);
        if (this.containsFile(uri)) {
            return this.doGetFile(uri);
        }
        Option<File> maybeFile = URLUtils$.MODULE$.toFile(uri);
        if (maybeFile.isEmpty()) {
            this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().remove((Object)uri);
            return null;
        }
        if (((File)maybeFile.get()).exists()) {
            ProjectFileSystemService x$1 = this;
            NameIdentifierResolver x$2 = this.createNameIdentifierResolver();
            String x$3 = URLUtils$.MODULE$.toCanonicalString(uri);
            Option<File> x$4 = maybeFile;
            boolean x$5 = !VFUtils$.MODULE$.isSupportedEditableScheme(uri);
            Option<String> x$6 = ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5();
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(x$1, x$2, x$3, x$4, x$6, x$5);
            this.doUpdateFile(uri, virtualFile);
            return virtualFile;
        }
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().remove((Object)uri);
        return null;
    }

    private boolean containsFile(String uri) {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().contains((Object)URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private ProjectVirtualFile doGetFile(String uri) {
        return (ProjectVirtualFile)this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().apply((Object)URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private Option<ProjectVirtualFile> doUpdateFile(String uri, ProjectVirtualFile virtualFile) {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles().put((Object)URLUtils$.MODULE$.toCanonicalString(uri), (Object)virtualFile);
    }

    public Option<File> sourceRootOf(String uri) {
        File[] rootFolders = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().structure().modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.sources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.resources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rootFolders)).find((Function1 & Serializable & scala.Serializable)root -> BoxesRunTime.boxToBoolean((boolean)ProjectFileSystemService.$anonfun$sourceRootOf$4(uri, root)));
    }

    public WeaveResourceResolver asResourceResolver() {
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver;
        FolderWeaveResourceResolver[] resolvers = (FolderWeaveResourceResolver[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().structure().modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)root -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.sources())).map((Function1 & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.resources())).map((Function1 & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class)));
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver2 = inMemoryVirtualFileResourceResolver = new InMemoryVirtualFileResourceResolver(this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles());
        return new ChainedWeaveResourceResolver((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolvers)).$plus$colon((Object)inMemoryVirtualFileResourceResolver2, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
    }

    public java.util.Iterator<VirtualFile> listFiles() {
        Iterator result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().structure().modules())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root2.sources())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root2.resources())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)))));
        Iterator<VirtualFile> wrapper = new Iterator<VirtualFile>(this, result){
            private final /* synthetic */ ProjectFileSystemService $outer;
            private final Iterator result$1;

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public boolean hasNext() {
                return this.result$1.hasNext();
            }

            public VirtualFile next() {
                VirtualFile next = (VirtualFile)this.result$1.next();
                this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)next.url());
                return next;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        };
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter((Iterator)wrapper).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$sourceRootOf$4(String uri$2, File root) {
        Option<Path> maybePath = URLUtils$.MODULE$.toPath(uri$2);
        return maybePath.exists((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)path.startsWith(root.toPath())));
    }

    public ProjectFileSystemService(JarFileNameIdentifierResolver jarFileNameIdentifierResolver) {
        this.jarFileNameIdentifierResolver = jarFileNameIdentifierResolver;
        VirtualFileSystem.$init$((VirtualFileSystem)this);
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$inMemoryFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.vfsChangeListeners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

