/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.extension.api.component.structure.WeaveModuleStructure;
import org.mule.weave.extension.api.component.structure.WeaveRootStructure;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams$;
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxParams;
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxParams$;
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxResult;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickResult;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.utils.URLUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4Qa\u0003\u0007\u0002\u0002]AQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u00045\u0001\u0001\u0006I!\r\u0005\u0006k\u00011\tA\u000e\u0005\u0006{\u00011\tA\u0010\u0005\u0006\u0005\u00021\ta\u0011\u0005\u0006!\u00021\t!\u0015\u0005\u0006G\u00021\t\u0001\u001a\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006o\u0002!\t\u0005\u001f\u0002\u001a\u0003\n\u001cHO]1di\u000e\u0013X-\u0019;f\r&dWmQ8n[\u0006tGM\u0003\u0002\u000e\u001d\u0005A1m\\7nC:$7O\u0003\u0002\u0010!\u0005\u0019An\u001d9\u000b\u0005E\u0011\u0012!B<fCZ,'BA\n\u0015\u0003\u0011iW\u000f\\3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\r!!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u00142kK\u000e$\bCA\u0011*\u001b\u0005\u0011#BA\u0012%\u0003\u001d\u0019w.\\7b]\u0012T!!\n\u0014\u0002\u0013\u0015DH/\u001a8tS>t'BA\u0014)\u0003\r\t\u0007/\u001b\u0006\u0003KAI!A\u000b\u0012\u0003\u0019]+\u0017M^3D_6l\u0017M\u001c3\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005a\u0011aG%O)\u0016;%+\u0011+J\u001f:{V*\u0011)Q\u0013:;ulQ(O)\u0016sE+F\u00012!\tI\"'\u0003\u000245\t11\u000b\u001e:j]\u001e\fA$\u0013(U\u000b\u001e\u0013\u0016\tV%P\u001d~k\u0015\t\u0015)J\u001d\u001e{6i\u0014(U\u000b:#\u0006%A\u0005v\u0013N+'O^5dKV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;\u001d\u0005A1/\u001a:wS\u000e,7/\u0003\u0002=s\tIQ+S*feZL7-Z\u0001\u0018o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ,\u0012a\u0010\t\u0003q\u0001K!!Q\u001d\u0003/]{'o[:qC\u000e,7+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\u0018!D4fi&s\u0007/\u001e;MC\n,G.F\u0001E!\t)eJ\u0004\u0002G\u0019B\u0011qIS\u0007\u0002\u0011*\u0011\u0011JF\u0001\u0007yI|w\u000e\u001e \u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0002\rA\u0013X\rZ3g\u0013\t\u0019tJ\u0003\u0002N\u0015\u0006qq-\u001a;EK\u001a\fW\u000f\u001c;OC6,Gc\u0001#S9\")1k\u0002a\u0001)\u00061\u0001/\u0019:b[N\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0005e#\u0012aB3dY&\u00048/Z\u0005\u00037Z\u0013A#\u0012=fGV$XmQ8n[\u0006tG\rU1sC6\u001c\b\"B/\b\u0001\u0004q\u0016a\u00029s_*,7\r\u001e\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003;:I!A\u00191\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\fO\u0016$H+Z7qY\u0006$X\rF\u0002EK\u001aDQa\u0015\u0005A\u0002QCQ!\u0018\u0005A\u0002y\u000bQC]3ue&,g/\u001a#fM\u0006,H\u000e\u001e$pY\u0012,'\u000f\u0006\u0002jmB\u0019!n[7\u000e\u0003)K!\u0001\u001c&\u0003\r=\u0003H/[8o!\u0011Qg\u000e\u001d0\n\u0005=T%A\u0002+va2,'\u0007\u0005\u0002ri6\t!O\u0003\u0002t9\u0005\u0011\u0011n\\\u0005\u0003kJ\u0014AAR5mK\")Q'\u0003a\u0001o\u00059Q\r_3dkR,GCA=}!\tQ'0\u0003\u0002|\u0015\n1\u0011I\\=SK\u001aDQa\u0015\u0006A\u0002Q\u0003")
public abstract class AbstractCreateFileCommand
implements WeaveCommand {
    private final String INTEGRATION_MAPPING_CONTENT;

    public String INTEGRATION_MAPPING_CONTENT() {
        return this.INTEGRATION_MAPPING_CONTENT;
    }

    public abstract UIService uIService();

    public abstract WorkspaceServiceManager workspaceServiceManager();

    public abstract String getInputLabel();

    public abstract String getDefaultName(ExecuteCommandParams var1, ProjectKind var2);

    public abstract String getTemplate(ExecuteCommandParams var1, ProjectKind var2);

    private Option<Tuple2<File, ProjectKind>> retrieveDefaultFolder(UIService uIService) {
        ProjectKind[] projectKinds = this.workspaceServiceManager().projectKinds();
        Option maybeProjectKind = Option$.MODULE$.empty();
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectKinds)).isEmpty()) {
            if (projectKinds.length == 1) {
                maybeProjectKind = Option$.MODULE$.apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectKinds)).head());
            } else {
                WeaveQuickPickItem[] inputs = (WeaveQuickPickItem[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectKinds)).map((Function1 & Serializable & scala.Serializable)p -> new WeaveQuickPickItem(p.projectMetadata().home().getAbsolutePath(), p.project().getName(), WeaveQuickPickItem$.MODULE$.apply$default$3(), WeaveQuickPickItem$.MODULE$.apply$default$4(), WeaveQuickPickItem$.MODULE$.apply$default$5(), WeaveQuickPickItem$.MODULE$.apply$default$6()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveQuickPickItem.class)));
                WeaveQuickPickResult result = uIService.weaveQuickPick(new WeaveQuickPickParams(Arrays.asList((Object[])inputs), "Select the Project where to create the File", WeaveQuickPickParams$.MODULE$.apply$default$3(), WeaveQuickPickParams$.MODULE$.apply$default$4(), WeaveQuickPickParams$.MODULE$.apply$default$5(), WeaveQuickPickParams$.MODULE$.apply$default$6(), WeaveQuickPickParams$.MODULE$.apply$default$7(), WeaveQuickPickParams$.MODULE$.apply$default$8(), WeaveQuickPickParams$.MODULE$.apply$default$9(), WeaveQuickPickParams$.MODULE$.apply$default$10())).get();
                if (!Predef$.MODULE$.Boolean2boolean(result.cancelled()) && !result.itemsId().isEmpty()) {
                    String projectPath = result.itemsId().get(0);
                    maybeProjectKind = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectKinds)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractCreateFileCommand.$anonfun$retrieveDefaultFolder$2(projectPath, x$1)));
                }
            }
        } else {
            uIService.showMessage(new MessageParams(MessageType.Error, "No source folder was detected. Please open a Project before trying to create an element."));
        }
        if (maybeProjectKind.isDefined()) {
            ProjectKind project = (ProjectKind)maybeProjectKind.get();
            WeaveModuleStructure[] modulesWithRoots = (WeaveModuleStructure[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])project.structure().modules())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractCreateFileCommand.$anonfun$retrieveDefaultFolder$3(x$2)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).isEmpty()) {
                uIService.showMessage(new MessageParams(MessageType.Info, "Selected project doesn't have modules with source folder. Please check the project before trying to create an element."));
                return None$.MODULE$;
            }
            if (modulesWithRoots.length == 1) {
                return Option$.MODULE$.apply((Object)new Tuple2((Object)((WeaveRootStructure)ProjectStructureHelper$.MODULE$.mainRoot((WeaveModuleStructure)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).head()).get()).defaultSourceFolder(), (Object)project));
            }
            WeaveQuickPickItem[] inputs = (WeaveQuickPickItem[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).map((Function1 & Serializable & scala.Serializable)m -> new WeaveQuickPickItem(m.name(), m.name(), WeaveQuickPickItem$.MODULE$.apply$default$3(), WeaveQuickPickItem$.MODULE$.apply$default$4(), WeaveQuickPickItem$.MODULE$.apply$default$5(), WeaveQuickPickItem$.MODULE$.apply$default$6()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveQuickPickItem.class)));
            WeaveQuickPickResult result = uIService.weaveQuickPick(new WeaveQuickPickParams(Arrays.asList((Object[])inputs), "Select the Module where to create the File", WeaveQuickPickParams$.MODULE$.apply$default$3(), WeaveQuickPickParams$.MODULE$.apply$default$4(), WeaveQuickPickParams$.MODULE$.apply$default$5(), WeaveQuickPickParams$.MODULE$.apply$default$6(), WeaveQuickPickParams$.MODULE$.apply$default$7(), WeaveQuickPickParams$.MODULE$.apply$default$8(), WeaveQuickPickParams$.MODULE$.apply$default$9(), WeaveQuickPickParams$.MODULE$.apply$default$10())).get();
            if (Predef$.MODULE$.Boolean2boolean(result.cancelled()) || result.itemsId().isEmpty()) {
                return None$.MODULE$;
            }
            String moduleName = result.itemsId().get(0);
            Option maybeStructure = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractCreateFileCommand.$anonfun$retrieveDefaultFolder$5(moduleName, x$3)));
            return Option$.MODULE$.apply((Object)new Tuple2(maybeStructure.map((Function1 & Serializable & scala.Serializable)x$4 -> ((WeaveRootStructure)ProjectStructureHelper$.MODULE$.mainRoot((WeaveModuleStructure)x$4).get()).defaultSourceFolder()).get(), (Object)project));
        }
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object execute(ExecuteCommandParams params) {
        Some some;
        Tuple2 tuple2;
        Option directoryProjectKindTuple;
        Option option;
        if (params.getArguments() != null && !params.getArguments().isEmpty()) {
            String directoryUri = Commands$.MODULE$.argAsString(params.getArguments(), 0);
            Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager().projectKind(directoryUri);
            if (maybeProjectKind.isDefined()) {
                option = URLUtils$.MODULE$.toFile(directoryUri).map((Function1 & Serializable & scala.Serializable)directory -> new Tuple2(directory, maybeProjectKind.get()));
            } else {
                this.uIService().showMessage(new MessageParams(MessageType.Error, new StringBuilder(50).append("No project is associated to: ").append(directoryUri).append(". ").append(this.commandId()).append(" cannot be executed").toString()));
                option = None$.MODULE$;
            }
        } else {
            option = this.retrieveDefaultFolder(this.uIService());
        }
        Option option2 = directoryProjectKindTuple = option;
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            File folder = (File)tuple2._1();
            ProjectKind project = (ProjectKind)tuple2._2();
            if (folder != null) {
                File file = folder;
                if (project != null) {
                    ProjectKind projectKind = project;
                    WeaveInputBoxResult result = this.uIService().weaveInputBox(new WeaveInputBoxParams(this.getInputLabel(), this.getDefaultName(params, projectKind), WeaveInputBoxParams$.MODULE$.apply$default$3(), WeaveInputBoxParams$.MODULE$.apply$default$4(), WeaveInputBoxParams$.MODULE$.apply$default$5(), WeaveInputBoxParams$.MODULE$.apply$default$6(), WeaveInputBoxParams$.MODULE$.apply$default$7(), WeaveInputBoxParams$.MODULE$.apply$default$8(), WeaveInputBoxParams$.MODULE$.apply$default$9(), WeaveInputBoxParams$.MODULE$.apply$default$10())).get();
                    if (Predef$.MODULE$.Boolean2boolean(result.cancelled())) return null;
                    String name = result.value();
                    if (StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)name))) {
                        name = new StringBuilder(4).append(name).append(".dwl").toString();
                    }
                    String mappingFile = URLUtils$.MODULE$.toLSPUrl(new File(file, name));
                    Either createFile = Either.forRight((Object)new CreateFile(mappingFile));
                    TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), this.getTemplate(params, projectKind));
                    TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(mappingFile, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
                    Either insertText = Either.forLeft((Object)textDocumentEdit);
                    ArrayList<Object> edits = new ArrayList<Object>();
                    edits.add(createFile);
                    edits.add(insertText);
                    edits.addAll(Arrays.asList((Object[])projectKind.newFile(file, name)));
                    ApplyWorkspaceEditResponse response = this.workspaceServiceManager().workspaceEditService().applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(edits))).get();
                    if (!response.isApplied()) return null;
                    this.uIService().openTextDocument(new OpenTextDocumentParams(mappingFile, OpenTextDocumentParams$.MODULE$.apply$default$2()));
                    return null;
                }
            }
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$retrieveDefaultFolder$2(String projectPath$1, ProjectKind x$1) {
        return x$1.projectMetadata().home().getAbsolutePath().equals(projectPath$1);
    }

    public static final /* synthetic */ boolean $anonfun$retrieveDefaultFolder$3(WeaveModuleStructure x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.roots())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$retrieveDefaultFolder$5(String moduleName$1, WeaveModuleStructure x$3) {
        return x$3.name().equals(moduleName$1);
    }

    public AbstractCreateFileCommand() {
        this.INTEGRATION_MAPPING_CONTENT = "|/**\n       |* This mapping won't be shared through your library, but you can use it to try out your module and create integration tests.\n       |*/";
    }
}

