package org.mule.weave.lsp.indexer.events

import org.mule.weave.lsp.indexer.events.IndexingStartedEvent.INDEXING_STARTED
import org.mule.weave.lsp.indexer.events.IndexingType.IndexingType
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class IndexingStartedEvent(indexingType: IndexingType) extends InternalEvent {
  override type T = OnIndexingStarted

  override def getType: InternalEventType[OnIndexingStarted] = {
    INDEXING_STARTED
  }

  override def dispatch(handler: OnIndexingStarted): Unit = {
    handler.onIndexingStarted(indexingType)
  }
}

object IndexingStartedEvent {
  val INDEXING_STARTED: InternalEventType[OnIndexingStarted] = InternalEventType[OnIndexingStarted]("INDEXING_STARTED")
}

trait OnIndexingStarted extends InternalEventHandler {
  def onIndexingStarted(indexingType: IndexingType)
}
