package org.mule.weave.lsp.project.events

import org.mule.weave.extension.api.component.structure.WeaveProjectStructure
import org.mule.weave.lsp.utils.{InternalEvent, InternalEventHandler, InternalEventType}

class ProjectStructureChangedEvent(previousProjectStructure: WeaveProjectStructure, newProjectStructure: WeaveProjectStructure) extends InternalEvent {

  override type T = OnProjectStructureChanged

  override def getType: InternalEventType[OnProjectStructureChanged] = {
    ProjectStructureChangedEvent.PROJECT_STRUCTURE_CHANGED
  }

  override def dispatch(handler: OnProjectStructureChanged): Unit = {
    handler.onProjectStructureChanged(previousProjectStructure, newProjectStructure)
  }
}

trait OnProjectStructureChanged extends InternalEventHandler {
  def onProjectStructureChanged(previousProjectStructure: WeaveProjectStructure, newProjectStructure: WeaveProjectStructure): Unit
}


object ProjectStructureChangedEvent {
  val PROJECT_STRUCTURE_CHANGED: InternalEventType[OnProjectStructureChanged] = InternalEventType[OnProjectStructureChanged]("PROJECT_STRUCTURE_CHANGED")
}
