package org.mule.weave.lsp.services

import org.eclipse.lsp4j.ApplyWorkspaceEditParams
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse
import org.eclipse.lsp4j.services.LanguageClient

import java.util.concurrent.CompletableFuture

class WorkspaceEditApplier(languageClient: LanguageClient, scheme: Option[String]) {
  def handles(uri: String): Boolean = {
    scheme.isDefined && uri.startsWith(scheme.get)
  }

  def applyEdit(params: ApplyWorkspaceEditParams): CompletableFuture[ApplyWorkspaceEditResponse] = {
    languageClient.applyEdit(params);
  }

}
